/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.output;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.TraceObject;
import com.oceanbase.jdbc.internal.io.output.AbstractPacketOutputStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import com.oceanbase.jdbc.internal.protocol.flt.OceanBaseProtocolV20;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.MaxAllowedPacketException;
import com.oceanbase.jdbc.util.OceanBaseCRC16;
import com.oceanbase.jdbc.util.OceanBaseCRC32C;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class Ob20PacketOutputStream
extends AbstractPacketOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(Ob20PacketOutputStream.class);
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final int MAX_PAYLOAD_LENGTH = 0xFFFFE3;
    private static final int PROTO20_SPLIT_LEN = 0xFFFFE3;
    private OceanBaseProtocolV20 ob20;
    private OceanBaseCRC32C crc32 = new OceanBaseCRC32C();
    private boolean enableOb20Checksum;
    byte[] outBytes;
    private int totalPacketLength;

    public Ob20PacketOutputStream(OutputStream out, long threadId, Options options, OceanBaseProtocolV20 ob20, TimeTrace timeTrace) {
        super(out, options.maxQuerySizeToLog, threadId, options.getCharacterEncoding(), timeTrace, options.encloseParamInParentheses);
        this.maxPacketLength = 0xFFFFFF;
        this.ob20 = ob20;
        this.enableOb20Checksum = options.enableOb20Checksum;
    }

    @Override
    public int initialPacketPos() {
        return 0;
    }

    @Override
    public void startPacket(int compressSeqNo) {
        this.ob20.initObSeqNo(compressSeqNo);
        this.mysqlSeqNo = 0;
        this.pos = 0;
        this.cmdLength = 0L;
        this.startSendRequest();
    }

    @Override
    protected void flushBuffer(boolean commandEnd) throws IOException {
        if (this.enableNetworkStatistics) {
            this.timestampBeforeFlush = System.currentTimeMillis();
        }
        if (this.pos > 0) {
            Buffer tmpBuf;
            byte[] totalPayload;
            int basicPayloadLength;
            int extraPayloadLength = 0;
            int totalPayloadLength = basicPayloadLength = 4 + this.pos;
            if (this.ob20.isExtraInfoExist()) {
                this.ob20.setExtraInfoLength();
                extraPayloadLength = (int)(4L + this.ob20.extraInfo.extraLength);
                totalPayloadLength += extraPayloadLength;
                if (extraPayloadLength > 0xFFFFE3) {
                    throw new IOException("Extra info is larger than PROTO20_SPLIT_LEN");
                }
                totalPayload = new byte[totalPayloadLength];
                tmpBuf = new Buffer(totalPayload);
                this.fillOb20ExtraInfo(tmpBuf);
                this.fillOb20BasicInfo(tmpBuf);
            } else {
                totalPayload = new byte[totalPayloadLength];
                tmpBuf = new Buffer(totalPayload);
                this.fillOb20BasicInfo(tmpBuf);
            }
            this.ob20.header.connectionId = this.threadId;
            this.ob20.header.requestId = this.ob20.curRequestId;
            int totalPayloadPos = 0;
            while (totalPayloadPos < totalPayloadLength) {
                int uncompressSize = this.ob20.isExtraInfoExist() && totalPayloadPos < extraPayloadLength ? (extraPayloadLength + basicPayloadLength <= 0xFFFFE3 ? extraPayloadLength + basicPayloadLength : extraPayloadLength) : Math.min(0xFFFFE3, totalPayloadLength - totalPayloadPos);
                this.ob20.header.compressSeqNo = this.ob20.header.obSeqNo = (short)((byte)this.ob20.getObSeqNo());
                this.ob20.header.payloadLength = uncompressSize;
                this.ob20.header.compressLength = 24 + uncompressSize + 4;
                if (this.ob20.isExtraInfoExist() && totalPayloadPos >= extraPayloadLength) {
                    this.ob20.header.flag &= 0xFFFFFFFE;
                }
                if (commandEnd && totalPayloadPos + uncompressSize == totalPayloadLength) {
                    this.ob20.header.flag |= 2;
                }
                this.totalPacketLength = 7 + this.ob20.header.compressLength;
                this.outBytes = new byte[this.totalPacketLength];
                Buffer outBuffer = new Buffer(this.outBytes);
                this.writeOb20Header(outBuffer);
                outBuffer.writeBytes(totalPayload, totalPayloadPos, uncompressSize);
                this.writeOb20TailChecksum(outBuffer, totalPayload, (totalPayloadPos += uncompressSize) - uncompressSize, uncompressSize);
                logger.debug("prepare to send: {}", (Object)this.headerToString());
                this.out.write(this.outBytes, 0, this.totalPacketLength);
                this.doTrace();
            }
            if (commandEnd) {
                if (this.ob20.header.payloadLength == 0xFFFFE3L) {
                    this.writeEmptyPacket();
                } else {
                    this.ob20.updateRequestId();
                }
            }
            this.pos = 0;
            this.ob20.header.reset();
            this.ob20.extraInfo.reset();
            this.ob20.tailChecksum = 0L;
        }
    }

    @Override
    public void writeEmptyPacket() throws IOException {
        if (this.enableNetworkStatistics) {
            this.timestampBeforeFlush = System.currentTimeMillis();
        }
        this.ob20.header.connectionId = this.threadId;
        this.ob20.header.requestId = this.ob20.curRequestId;
        this.ob20.updateRequestId();
        this.ob20.header.compressSeqNo = this.ob20.header.obSeqNo = (short)((byte)this.ob20.getObSeqNo());
        this.ob20.header.payloadLength = 4L;
        this.ob20.header.compressLength = 32;
        this.ob20.header.flag &= 0xFFFFFFFE;
        this.ob20.header.flag |= 2;
        this.totalPacketLength = 7 + this.ob20.header.compressLength;
        this.outBytes = new byte[this.totalPacketLength];
        Buffer outBuffer = new Buffer(this.outBytes);
        this.writeOb20Header(outBuffer);
        byte[] totalPayload = new byte[]{0, 0, 0, (byte)this.mysqlSeqNo++};
        outBuffer.writeBytes(totalPayload, 0, 4);
        this.writeOb20TailChecksum(outBuffer, totalPayload, 0, 4);
        logger.debug("prepare to send: {}", (Object)this.headerToString());
        this.out.write(this.outBytes, 0, this.totalPacketLength);
        this.doTrace();
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
        this.maxPacketLength = Math.min(0xFFFFFF, maxAllowedPacket + 4);
    }

    private String headerToString() {
        return "connectionId = " + this.ob20.header.connectionId + ", requestId = " + this.ob20.header.requestId + ", obSeqNo = " + this.ob20.header.obSeqNo + ", payloadLength = " + this.ob20.header.payloadLength + ", headerChecksum = " + this.ob20.header.headerChecksum;
    }

    private void writeOb20Header(Buffer outBuffer) {
        outBuffer.writeLongInt(this.ob20.header.compressLength);
        outBuffer.writeByte((byte)this.ob20.header.compressSeqNo);
        outBuffer.writeLongInt(this.ob20.header.uncompressLength);
        outBuffer.writeShort(this.ob20.header.magicNum);
        outBuffer.writeShort(this.ob20.header.version);
        outBuffer.writeInt((int)this.ob20.header.connectionId);
        outBuffer.writeLongInt(this.ob20.header.requestId);
        outBuffer.writeByte((byte)this.ob20.header.obSeqNo);
        outBuffer.writeInt((int)this.ob20.header.payloadLength);
        outBuffer.writeInt(this.ob20.header.flag);
        outBuffer.writeShort(this.ob20.header.reserved);
        this.ob20.header.headerChecksum = this.enableOb20Checksum ? OceanBaseCRC16.calculate(outBuffer.getByteBuffer(), 29) : 0;
        outBuffer.writeShort((short)this.ob20.header.headerChecksum);
    }

    private void fillOb20ExtraInfo(Buffer outBuffer) throws IOException {
        outBuffer.writeInt((int)this.ob20.extraInfo.extraLength);
        outBuffer.writeBytes(this.ob20.getExtraInfoBytes(), 0, (int)this.ob20.extraInfo.extraLength);
    }

    private void fillOb20BasicInfo(Buffer outBuffer) throws MaxAllowedPacketException {
        outBuffer.writeLongInt(this.pos);
        outBuffer.writeByte((byte)this.mysqlSeqNo++);
        this.checkMaxAllowedLength(this.pos);
        outBuffer.writeBytes(this.buf, 0, this.pos);
        this.cmdLength += (long)this.pos;
    }

    private void writeOb20TailChecksum(Buffer outBuffer, byte[] payload, int pos, int len) {
        if (this.enableOb20Checksum) {
            this.crc32.reset();
            this.crc32.update(payload, pos, len);
            this.ob20.tailChecksum = this.crc32.getValue();
        } else {
            this.ob20.tailChecksum = 0L;
        }
        outBuffer.writeInt((int)this.ob20.tailChecksum);
    }

    private void doTrace() {
        if (this.traceCache != null && this.permitTrace) {
            this.traceCache.put(new TraceObject(true, 3, this.threadId, new byte[][]{Arrays.copyOfRange(this.outBytes, 0, Math.min(this.totalPacketLength, 1000))}));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("send: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog, 0, this.totalPacketLength, (byte[][])new byte[][]{this.outBytes}));
        }
    }

    public OceanBaseProtocolV20 getOb20() {
        return this.ob20;
    }
}

