/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.Blob;
import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.Lob;
import com.oceanbase.jdbc.ObArray;
import com.oceanbase.jdbc.ObPrepareStatement;
import com.oceanbase.jdbc.ObStruct;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.BigDecimalParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.BooleanParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ByteArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ByteParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.DateParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.DateTimeParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.DoubleParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.FloatParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.IntParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.LocalTimeParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.LongParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.NullParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBBINARY_DOUBLEParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBBINARY_FLOATParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBByteArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBEmptyLobParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBINTERVALDSParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBINTERVALYMParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBNStringParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBNUMBERParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBNUMBER_FLOATParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBReaderParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBSerializableParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStreamParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStringParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStructParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBTIMESTAMPLTZParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBTIMESTAMPParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBTIMESTAMPTZParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBVarcharParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OffsetTimeParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.com.send.parameters.ReaderParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.SerializableParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ShortParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.StreamParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.StringParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.TimeParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.TimestampParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ZonedDateTimeParameter;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public abstract class BasePrepareStatement
extends OceanBaseStatement
implements ObPrepareStatement {
    public static final DateTimeFormatter SPEC_ISO_ZONED_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter();
    protected int autoGeneratedKeys;
    protected boolean hasLongData = false;
    private boolean useFractionalSeconds;
    private boolean noBackslashEscapes = this.protocol.noBackslashEscapes();
    protected Map<String, Integer> indexMap;
    protected int parameterCount = -1;

    public BasePrepareStatement(OceanBaseConnection connection, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys, ExceptionFactory exceptionFactory) {
        super(connection, resultSetScrollType, resultSetConcurrency, exceptionFactory);
        this.useFractionalSeconds = this.options.useFractionalSeconds;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    @Override
    public BasePrepareStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        BasePrepareStatement base = (BasePrepareStatement)super.clone(connection);
        base.useFractionalSeconds = this.options.useFractionalSeconds;
        return base;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (this.executeInternal(this.getFetchSize())) {
            if (this.protocol.isOracleMode() && this.results.getResultSet() != null) {
                return this.results.getResultSet().getProcessedRows();
            }
            return 0L;
        }
        if (this.results.isReturning() && this.results.getResultSet() != null) {
            return this.results.getResultSet().getProcessedRows();
        }
        return this.getLargeUpdateCount();
    }

    protected abstract boolean executeInternal(int var1) throws SQLException;

    public void setIndexMap(Map<String, Integer> indexMap) {
        this.indexMap = indexMap;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null || length == 0L && this.protocol.isOracleMode()) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBReaderParameter(reader, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        long length = -1L;
        if (reader != null) {
            try {
                if (!reader.markSupported()) {
                    reader = new BufferedReader(reader, 5);
                }
                reader.mark(100);
                if (reader.read() == -1) {
                    length = 0L;
                } else {
                    reader.reset();
                    length = Long.MAX_VALUE;
                }
            }
            catch (IOException e) {
                throw new SQLException("Can't calculate whether the reader contains an empty string \"\" or not");
            }
        }
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        throw this.exceptionFactory.notSupported("REF parameter are not supported");
    }

    @Override
    public void setBlob(int parameterIndex, java.sql.Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (blob instanceof Blob) {
            if (((Blob)blob).isEmptyLob()) {
                if (((Blob)blob).getLocator() != null) {
                    this.setParameter(parameterIndex, new OBEmptyLobParameter(0, ((Blob)blob).getLocator().binaryData));
                } else {
                    this.setParameter(parameterIndex, new OBEmptyLobParameter(0));
                }
                return;
            }
            if (this.connection.getProtocol().isOracleMode()) {
                if (((Blob)blob).getLocator() != null && (this.options.useServerPrepStmts || this.isInternal)) {
                    this.setParameter(parameterIndex, new OBStreamParameter(((Blob)blob).getLocator().binaryData, this.noBackslashEscapes));
                } else {
                    this.setParameter(parameterIndex, new OBStreamParameter((Blob)blob, this.noBackslashEscapes));
                }
            } else if (this.options.useServerPrepStmts) {
                this.setParameter(parameterIndex, new StreamParameter((Lob)((Object)blob), blob.length(), this.noBackslashEscapes));
            } else {
                this.setParameter(parameterIndex, new ByteArrayParameter(blob.getBytes(1L, (int)blob.length()), this.noBackslashEscapes));
            }
        } else {
            throw this.exceptionFactory.notSupported(blob.getClass().getName() + " is not supported");
        }
        this.hasLongData = true;
    }

    public void setLobLocator(int parameterIndex, java.sql.Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(((Blob)blob).getLocator().binaryData, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(inputStream, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(inputStream, length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(inputStream, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(inputStream, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setClob(int parameterIndex, java.sql.Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(parameterIndex, ColumnType.ORA_CLOB);
            return;
        }
        if (clob instanceof Clob) {
            if (((Clob)clob).isEmptyLob()) {
                if (((Clob)clob).getLocator() != null) {
                    this.setParameter(parameterIndex, new OBEmptyLobParameter(1, ((Clob)clob).getLocator().binaryData));
                } else {
                    this.setParameter(parameterIndex, new OBEmptyLobParameter(1));
                }
                return;
            }
            if (this.connection.getProtocol().isOracleMode()) {
                if (((Clob)clob).getLocator() != null && (this.options.useServerPrepStmts || this.isInternal)) {
                    this.setParameter(parameterIndex, new OBReaderParameter(((Clob)clob).getLocator().binaryData, this.noBackslashEscapes));
                } else {
                    this.setParameter(parameterIndex, new OBReaderParameter((Clob)clob, this.noBackslashEscapes));
                }
            } else if (this.options.useServerPrepStmts) {
                this.setParameter(parameterIndex, new ReaderParameter((Clob)clob, clob.length(), this.noBackslashEscapes));
            } else {
                this.setParameter(parameterIndex, new StringParameter(clob.getSubString(1L, (int)clob.length()), this.noBackslashEscapes, this.protocol.getEncoding()));
            }
        } else {
            throw this.exceptionFactory.notSupported(clob.getClass().getName() + " is not supported");
        }
        this.hasLongData = true;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        if (array == null) {
            this.setNull(parameterIndex, ColumnType.NULL);
            return;
        }
        this.setParameter(parameterIndex, new OBArrayParameter((ObArray)array, this.protocol.getOptions()));
    }

    @Override
    public void setDate(int parameterIndex, java.sql.Date date, Calendar cal) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        if (this.protocol.isOracleMode()) {
            Timestamp timestamp = new Timestamp(date.getTime());
            if (this.options.compatibleOjdbcVersion == 6) {
                timestamp = Timestamp.valueOf(timestamp.toLocalDateTime().withHour(0).withMinute(0).withSecond(0));
            }
            timestamp.setNanos(0);
            this.setParameter(parameterIndex, new DateTimeParameter(timestamp, cal != null ? cal.getTimeZone() : TimeZone.getDefault(), this.useFractionalSeconds, true));
        } else {
            this.setParameter(parameterIndex, new DateParameter(date, cal != null ? cal.getTimeZone() : TimeZone.getDefault(), this.options));
        }
    }

    @Override
    public void setDate(int parameterIndex, java.sql.Date date) throws SQLException {
        this.setDate(parameterIndex, date, null);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        if (time == null) {
            this.setNull(parameterIndex, ColumnType.TIME);
            return;
        }
        if (this.protocol.isOracleMode()) {
            Timestamp ts = new Timestamp(time.getTime());
            TimeZone tz = this.protocol.getTimeZone();
            this.setParameter(parameterIndex, new OBTIMESTAMPParameter(ts, tz, this.useFractionalSeconds));
        } else {
            this.setParameter(parameterIndex, new TimeParameter(time, TimeZone.getDefault(), this.useFractionalSeconds));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.setTime(parameterIndex, time, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        if (this.protocol.isOracleMode()) {
            if (timestamp != null && timestamp.getNanos() == 0) {
                this.setTimestampToDate(parameterIndex, new java.sql.Date(timestamp.getTime()));
            } else {
                this.setTIMESTAMP(parameterIndex, timestamp);
            }
        } else {
            if (timestamp == null) {
                this.setNull(parameterIndex, ColumnType.DATETIME);
                return;
            }
            TimeZone tz = cal != null ? cal.getTimeZone() : this.protocol.getTimeZone();
            this.setParameter(parameterIndex, new TimestampParameter(timestamp, tz, this.useFractionalSeconds));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.setTimestamp(parameterIndex, timestamp, null);
    }

    private void setTimestampToDate(int parameterIndex, java.sql.Date date) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        if (this.protocol.isOracleMode()) {
            Timestamp timestamp = new Timestamp(date.getTime());
            if (timestamp == null) {
                this.setNull(parameterIndex, ColumnType.TIMESTAMP_NANO);
                return;
            }
            this.setParameter(parameterIndex, new DateTimeParameter(timestamp, this.protocol.getTimeZone(), this.useFractionalSeconds, true));
        } else {
            this.setParameter(parameterIndex, new DateParameter(date, TimeZone.getDefault(), this.options));
        }
    }

    public void setLocalDateTime(int parameterIndex, LocalDateTime localDateTime) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            if (localDateTime == null) {
                this.setNull(parameterIndex, ColumnType.TIMESTAMP_NANO);
                return;
            }
            this.setParameter(parameterIndex, new OBTIMESTAMPParameter(Timestamp.valueOf(localDateTime), TimeZone.getDefault(), this.useFractionalSeconds));
        } else {
            this.setParameter(parameterIndex, new TimestampParameter(Timestamp.valueOf(localDateTime), TimeZone.getDefault(), this.useFractionalSeconds));
        }
    }

    @Override
    public void setTIMESTAMP(int parameterIndex, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, ColumnType.TIMESTAMP_NANO);
            return;
        }
        this.setParameter(parameterIndex, new OBTIMESTAMPParameter(timestamp, this.protocol.getTimeZone(), this.useFractionalSeconds));
    }

    @Override
    public void setTIMESTAMPTZ(int parameterIndex, TIMESTAMPTZ timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, ColumnType.TIMESTAMP_TZ);
            return;
        }
        this.setParameter(parameterIndex, new OBTIMESTAMPTZParameter(timestamp, this.protocol.isTZTablesImported()));
    }

    @Override
    public void setTIMESTAMPLTZ(int parameterIndex, TIMESTAMPLTZ timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, ColumnType.TIMESTAMP_LTZ);
            return;
        }
        this.setParameter(parameterIndex, new OBTIMESTAMPLTZParameter(timestamp, this.connection));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    public void setNull(int parameterIndex, ColumnType mariadbType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter(mariadbType));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    public abstract void setParameter(int var1, ParameterHolder var2) throws SQLException;

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        if (url == null) {
            this.setNull(parameterIndex, ColumnType.STRING);
            return;
        }
        this.setParameter(parameterIndex, new StringParameter(url.toString(), this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding()));
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @Override
    public void setRowId(int parameterIndex, RowId rowid) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            if (rowid == null) {
                this.setNull(parameterIndex, ColumnType.ROWID);
                return;
            }
        } else {
            throw this.exceptionFactory.notSupported("RowIDs not supported");
        }
        this.setParameter(parameterIndex, new StringParameter(rowid.toString(), this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding()));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (value == null) {
            this.setNull(parameterIndex, ColumnType.VARCHAR);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBNStringParameter(value, this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding(), this.protocol.getOptions().nCharacterEncoding));
        } else {
            this.setParameter(parameterIndex, new StringParameter(value, this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding()));
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory.notSupported("SQlXML not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, obj, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, obj, targetSqlType, Long.MAX_VALUE);
    }

    private Timestamp getTimeStamp(ZonedDateTime obj) {
        StringBuilder stringBuilder = new StringBuilder();
        String nanoString = Integer.toString(obj.getNano());
        if (nanoString.length() < 9) {
            StringBuilder sb = new StringBuilder();
            int x = 9 - nanoString.length();
            for (int i = 0; i < x; ++i) {
                sb.append("0");
            }
            nanoString = sb.toString() + nanoString;
        }
        return Timestamp.valueOf(stringBuilder.append(obj.getYear()).append("-").append(obj.getMonthValue()).append("-").append(obj.getDayOfMonth()).append(" ").append(obj.getHour()).append(":").append(obj.getMinute()).append(":").append(obj.getSecond()).append(".").append(nanoString).toString());
    }

    @Override
    public void setObject(int parameterIndex, Object obj) throws SQLException {
        if (obj == null) {
            this.setNull(parameterIndex, 4);
        } else if (obj instanceof String) {
            this.setString(parameterIndex, (String)obj);
        } else if (obj instanceof Integer) {
            this.setInt(parameterIndex, (Integer)obj);
        } else if (obj instanceof Long) {
            this.setLong(parameterIndex, (Long)obj);
        } else if (obj instanceof Short) {
            this.setShort(parameterIndex, (Short)obj);
        } else if (obj instanceof Double) {
            this.setDouble(parameterIndex, (Double)obj);
        } else if (obj instanceof Float) {
            this.setFloat(parameterIndex, ((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            this.setByte(parameterIndex, (Byte)obj);
        } else if (obj instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])obj);
        } else if (obj instanceof java.sql.Date) {
            this.setDate(parameterIndex, (java.sql.Date)obj);
        } else if (obj instanceof Time) {
            this.setTime(parameterIndex, (Time)obj);
        } else if (obj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)obj);
        } else if (obj instanceof Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((Date)obj).getTime()));
        } else if (obj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)obj);
        } else if (obj instanceof java.sql.Blob) {
            this.setBlob(parameterIndex, (java.sql.Blob)obj);
        } else if (obj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)obj);
        } else if (obj instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)obj);
        } else if (obj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
        } else if (obj instanceof BigInteger) {
            this.setString(parameterIndex, obj.toString());
        } else if (obj instanceof java.sql.Clob) {
            this.setClob(parameterIndex, (java.sql.Clob)obj);
        } else if (obj instanceof LocalDateTime) {
            this.setLocalDateTime(parameterIndex, (LocalDateTime)obj);
        } else if (obj instanceof Instant) {
            this.setTimestamp(parameterIndex, Timestamp.from((Instant)obj));
        } else if (obj instanceof LocalDate) {
            this.setDate(parameterIndex, java.sql.Date.valueOf((LocalDate)obj));
        } else if (obj instanceof OffsetDateTime) {
            this.setParameter(parameterIndex, new ZonedDateTimeParameter(((OffsetDateTime)obj).toZonedDateTime(), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
        } else if (obj instanceof OffsetTime) {
            this.setParameter(parameterIndex, new OffsetTimeParameter((OffsetTime)obj, this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
        } else if (obj instanceof ZonedDateTime) {
            String zoneId = ((ZonedDateTime)obj).getZone().getId();
            TimeZone tz = zoneId == null || zoneId.isEmpty() ? TimeZone.getDefault() : (zoneId.charAt(0) == '+' || zoneId.charAt(0) == '-' ? TimeZone.getTimeZone("GMT" + zoneId) : TimeZone.getTimeZone(zoneId));
            TIMESTAMPTZ timestamptz = new TIMESTAMPTZ(this.connection, this.getTimeStamp((ZonedDateTime)obj), Calendar.getInstance(tz), this.protocol.isTZTablesImported());
            this.setTIMESTAMPTZ(parameterIndex, timestamptz);
        } else if (obj instanceof LocalTime) {
            this.setParameter(parameterIndex, new LocalTimeParameter((LocalTime)obj, this.useFractionalSeconds));
        } else if (obj instanceof Array) {
            this.setArray(parameterIndex, (Array)obj);
        } else if (obj instanceof Struct) {
            this.setStruct(parameterIndex, (Struct)obj);
        } else if (obj instanceof RowId) {
            this.setRowId(parameterIndex, (RowId)obj);
        } else {
            if (this.connection.getProtocol().isOracleMode()) {
                this.setParameter(parameterIndex, new OBSerializableParameter(obj, this.noBackslashEscapes));
            } else {
                this.setParameter(parameterIndex, new SerializableParameter(obj, this.noBackslashEscapes));
            }
            this.hasLongData = true;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object obj, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, obj, targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object obj, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, obj, targetSqlType.getVendorTypeNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setInternalObject(int parameterIndex, Object obj, int targetSqlType, long scaleOrLength) throws SQLException {
        switch (targetSqlType) {
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: {
                throw this.exceptionFactory.notSupported("Type not supported");
            }
        }
        if (obj == null) {
            this.setNull(parameterIndex, 4);
            return;
        } else if (obj instanceof String) {
            if (targetSqlType == 2004) {
                throw this.exceptionFactory.create("Cannot convert a String to a Blob");
            }
            String str = (String)obj;
            try {
                switch (targetSqlType) {
                    case -7: {
                        int intVal = "1".equals(str) || "0".equals(str) ? Integer.valueOf(str).intValue() : ("true".equalsIgnoreCase(str) ? Integer.valueOf(1) : Integer.valueOf(0)).intValue();
                        this.setInt(parameterIndex, intVal);
                        return;
                    }
                    case 16: {
                        if ("true".equalsIgnoreCase(str) || "Y".equalsIgnoreCase(str)) {
                            this.setBoolean(parameterIndex, true);
                            return;
                        }
                        if ("false".equalsIgnoreCase(str) || "N".equalsIgnoreCase(str)) {
                            this.setBoolean(parameterIndex, false);
                            return;
                        }
                        if (!str.matches("-?\\d+\\.?\\d*")) throw new SQLException("No conversion from " + str + " to Types.BOOLEAN possible.", "S1009", 0);
                        this.setBoolean(parameterIndex, !str.matches("-?[0]+[.]*[0]*"));
                        return;
                    }
                    case -6: {
                        this.setByte(parameterIndex, Byte.parseByte(str));
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, Short.parseShort(str));
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, Integer.parseInt(str));
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(parameterIndex, Double.valueOf(str));
                        return;
                    }
                    case 7: {
                        this.setFloat(parameterIndex, Float.valueOf(str).floatValue());
                        return;
                    }
                    case -5: {
                        this.setLong(parameterIndex, Long.valueOf(str));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.setBigDecimal(parameterIndex, new BigDecimal(str));
                        return;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        this.setString(parameterIndex, str);
                        return;
                    }
                    case 93: {
                        if (str.startsWith("0000-00-00")) {
                            this.setTimestamp(parameterIndex, null);
                            return;
                        }
                        this.setTimestamp(parameterIndex, Timestamp.valueOf(str));
                        return;
                    }
                    case 92: {
                        this.setTime(parameterIndex, Time.valueOf((String)obj));
                        return;
                    }
                    case 2013: {
                        this.setParameter(parameterIndex, new OffsetTimeParameter(OffsetTime.parse(str), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
                        return;
                    }
                    case 2014: {
                        this.setParameter(parameterIndex, new ZonedDateTimeParameter(ZonedDateTime.parse(str, SPEC_ISO_ZONED_DATE_TIME), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
                        return;
                    }
                    default: {
                        throw this.exceptionFactory.create(String.format("Could not convert [%s] to %s", str, targetSqlType));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw this.exceptionFactory.create(String.format("Could not convert [%s] to %s", str, targetSqlType), e);
            }
        } else if (obj instanceof Number) {
            Number bd = (Number)obj;
            switch (targetSqlType) {
                case -6: {
                    this.setByte(parameterIndex, bd.byteValue());
                    return;
                }
                case 5: {
                    this.setShort(parameterIndex, bd.shortValue());
                    return;
                }
                case 4: {
                    this.setInt(parameterIndex, bd.intValue());
                    return;
                }
                case -5: {
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(parameterIndex, bd.doubleValue());
                    return;
                }
                case 7: {
                    this.setFloat(parameterIndex, bd.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (obj instanceof BigDecimal) {
                        this.setBigDecimal(parameterIndex, (BigDecimal)obj);
                        return;
                    }
                    if (obj instanceof Double || obj instanceof Float) {
                        this.setDouble(parameterIndex, bd.doubleValue());
                        return;
                    }
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case -7: {
                    this.setBoolean(parameterIndex, bd.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.setString(parameterIndex, bd.toString());
                    return;
                }
                case 16: {
                    int intValue = bd.intValue();
                    this.setBoolean(parameterIndex, intValue != 0);
                    return;
                }
                default: {
                    throw this.exceptionFactory.create(String.format("Could not convert [%s] to %s", bd, targetSqlType));
                }
            }
        } else if (obj instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4 && targetSqlType != 2004) throw this.exceptionFactory.create("Can only convert a byte[] to BLOB,BINARY, VARBINARY or LONGVARBINARY");
            this.setBytes(parameterIndex, (byte[])obj);
            return;
        } else if (obj instanceof Time) {
            this.setTime(parameterIndex, (Time)obj);
            return;
        } else if (obj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)obj);
            return;
        } else if (obj instanceof java.sql.Date) {
            this.setDate(parameterIndex, (java.sql.Date)obj);
            return;
        } else if (obj instanceof Date) {
            long timemillis = ((Date)obj).getTime();
            if (targetSqlType == 91) {
                this.setDate(parameterIndex, new java.sql.Date(timemillis));
                return;
            } else if (targetSqlType == 92) {
                this.setTime(parameterIndex, new Time(timemillis));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.setTimestamp(parameterIndex, new Timestamp(timemillis));
            }
            return;
        } else if (obj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)obj);
            return;
        } else if (obj instanceof java.sql.Blob) {
            this.setBlob(parameterIndex, (java.sql.Blob)obj);
            return;
        } else if (obj instanceof java.sql.Clob) {
            this.setClob(parameterIndex, (java.sql.Clob)obj);
            return;
        } else if (obj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)obj, scaleOrLength);
            return;
        } else if (obj instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)obj, scaleOrLength);
            return;
        } else if (obj instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)obj));
            return;
        } else if (obj instanceof Instant) {
            this.setTimestamp(parameterIndex, Timestamp.from((Instant)obj));
            return;
        } else if (obj instanceof LocalDate) {
            this.setDate(parameterIndex, java.sql.Date.valueOf((LocalDate)obj));
            return;
        } else if (obj instanceof OffsetDateTime) {
            this.setParameter(parameterIndex, new ZonedDateTimeParameter(((OffsetDateTime)obj).toZonedDateTime(), this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
            return;
        } else if (obj instanceof OffsetTime) {
            this.setParameter(parameterIndex, new OffsetTimeParameter((OffsetTime)obj, this.protocol.getTimeZone().toZoneId(), this.useFractionalSeconds, this.options));
            return;
        } else if (obj instanceof ZonedDateTime) {
            String zoneId = ((ZonedDateTime)obj).getZone().getId();
            TimeZone tz = zoneId == null || zoneId.isEmpty() ? TimeZone.getDefault() : (zoneId.charAt(0) == '+' || zoneId.charAt(0) == '-' ? TimeZone.getTimeZone("GMT" + zoneId) : TimeZone.getTimeZone(zoneId));
            this.protocol.isTZTablesImported();
            TIMESTAMPTZ timestamptz = new TIMESTAMPTZ(this.connection, this.getTimeStamp((ZonedDateTime)obj), Calendar.getInstance(tz), this.protocol.isTZTablesImported());
            this.setTIMESTAMPTZ(parameterIndex, timestamptz);
            return;
        } else {
            if (!(obj instanceof LocalTime)) throw this.exceptionFactory.create(String.format("Could not set parameter in setObject, could not convert: %s to %s", obj.getClass(), targetSqlType));
            this.setParameter(parameterIndex, new LocalTimeParameter((LocalTime)obj, this.useFractionalSeconds));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.protocol.isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(stream, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(stream, length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.protocol.isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(stream, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(stream, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.protocol.isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(stream, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(stream, (long)length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.protocol.isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(stream, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(stream, length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(stream, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(stream, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.protocol.isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(stream, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(stream, (long)length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setParameter(parameterIndex, new BooleanParameter(value));
    }

    @Override
    public void setByte(int parameterIndex, byte bit) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(bit));
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setParameter(parameterIndex, new ShortParameter(value));
    }

    @Override
    public void setString(int parameterIndex, String str) throws SQLException {
        if (str == null) {
            this.setNull(parameterIndex, ColumnType.VARCHAR);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBVarcharParameter(str, this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding()));
        } else {
            String parameterString = str;
            this.setParameter(parameterIndex, new StringParameter(parameterString, this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding()));
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        if (bytes == null) {
            this.setNull(parameterIndex, ColumnType.BLOB);
            return;
        }
        if (this.connection.getProtocol().isOracleMode()) {
            this.setParameter(parameterIndex, new OBByteArrayParameter(bytes, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new ByteArrayParameter(bytes, this.noBackslashEscapes));
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (this.protocol.isOracleMode()) {
            this.setParameter(parameterIndex, new OBStreamParameter(x, length, this.noBackslashEscapes));
        } else {
            this.setParameter(parameterIndex, new StreamParameter(x, (long)length, this.noBackslashEscapes));
        }
        this.hasLongData = true;
    }

    @Override
    public void setInt(int column, int value) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            this.setNUMBER(column, value);
            return;
        }
        this.setParameter(column, new IntParameter(value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setParameter(parameterIndex, new LongParameter(value));
    }

    @Override
    public void setFixedCHAR(int parameterIndex, String parameterStr) throws SQLException {
        if (this.connection.getProtocol().isOracleMode()) {
            if (parameterStr == null) {
                this.setNull(parameterIndex, 1);
                return;
            }
            this.setParameter(parameterIndex, new OBStringParameter(parameterStr, this.noBackslashEscapes, this.connection.getProtocol().getOptions().getCharacterEncoding()));
            return;
        }
        throw this.exceptionFactory.notSupported("Method PrepareStatement.setFixedCHAR() not supported");
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setParameter(parameterIndex, new FloatParameter(value));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        if (!this.options.allowNanAndInf && (value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY || Double.isNaN(value))) {
            throw new SQLException("'" + value + "' is not a valid numeric or approximate numeric value");
        }
        this.setParameter(parameterIndex, new DoubleParameter(value));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(parameterIndex, ColumnType.DECIMAL);
            return;
        }
        this.setParameter(parameterIndex, new BigDecimalParameter(bigDecimal));
    }

    public void setNUMBER(int parameterIndex, Integer number) throws SQLException {
        if (number == null) {
            this.setNull(parameterIndex, ColumnType.NUMBER);
            return;
        }
        this.setParameter(parameterIndex, new OBNUMBERParameter((int)number));
    }

    public void setNUMBER_FLOAT(int parameterIndex, Float number) throws SQLException {
        if (number == null) {
            this.setNull(parameterIndex, ColumnType.NUMBER_FLOAT);
            return;
        }
        this.setParameter(parameterIndex, new OBNUMBER_FLOATParameter(number.floatValue()));
    }

    public void setBINARY_FLOAT(int parameterIndex, Float number) throws SQLException {
        if (number == null) {
            this.setNull(parameterIndex, ColumnType.BINARY_FLOAT);
            return;
        }
        this.setParameter(parameterIndex, new OBBINARY_FLOATParameter(number.floatValue()));
    }

    public void setBINARY_DOUBLE(int parameterIndex, Double number) throws SQLException {
        if (number == null) {
            this.setNull(parameterIndex, ColumnType.BINARY_DOUBLE);
            return;
        }
        this.setParameter(parameterIndex, new OBBINARY_DOUBLEParameter(number.floatValue()));
    }

    @Override
    public void setINTERVALDS(int parameterIndex, INTERVALDS intervalds) throws SQLException {
        if (intervalds == null) {
            this.setNull(parameterIndex, ColumnType.INTERVALDS);
            return;
        }
        this.setParameter(parameterIndex, new OBINTERVALDSParameter(intervalds));
    }

    @Override
    public void setINTERVALYM(int parameterIndex, INTERVALYM intervalym) throws SQLException {
        if (intervalym == null) {
            this.setNull(parameterIndex, ColumnType.INTERVALDS);
            return;
        }
        this.setParameter(parameterIndex, new OBINTERVALYMParameter(intervalym));
    }

    public void setStruct(int parameterIndex, Struct x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, ColumnType.STRUCT);
            return;
        }
        this.setParameter(parameterIndex, new OBStructParameter((ObStruct)x, this.protocol.getOptions()));
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void setParameterCount(int count) {
        this.parameterCount = count;
    }

    public abstract ParameterHolder[] getParameters();

    public abstract void setParameters(ParameterHolder[] var1);

    public String asSql() throws SQLException {
        return null;
    }
}

