/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.DateUtil;
import com.mybatisflex.core.util.StringUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.regex.Matcher;

public class SqlUtil {
    private static String SQL_ORDER_BY_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";
    private static final char[] UN_SAFE_CHARS = "'`\"<>&+=#-;".toCharArray();

    private SqlUtil() {
    }

    public static void keepColumnSafely(String column) {
        if (StringUtil.isBlank(column)) {
            throw new IllegalArgumentException("Column must not be empty");
        }
        column = column.trim();
        int strLen = column.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = column.charAt(i);
            if (Character.isWhitespace(ch)) {
                throw new IllegalArgumentException("Column must not has space char.");
            }
            if (!SqlUtil.isUnSafeChar(ch)) continue;
            throw new IllegalArgumentException("Column has unsafe char: [" + ch + "].");
        }
    }

    public static void keepOrderBySqlSafely(String value) {
        if (!value.matches(SQL_ORDER_BY_PATTERN)) {
            throw new IllegalArgumentException("Order By sql not safe, order by string: " + value);
        }
    }

    private static boolean isUnSafeChar(char ch) {
        for (char c : UN_SAFE_CHARS) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static boolean toBool(Number result) {
        return result != null && result.longValue() > 0L;
    }

    public static String replaceSqlParams(String sql, Object[] params) {
        if (params != null && params.length > 0) {
            for (Object value : params) {
                if (value == null) {
                    sql = sql.replaceFirst("\\?", "null");
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    sql = sql.replaceFirst("\\?", value.toString());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                if (value instanceof Date) {
                    sb.append(DateUtil.toDateTimeString((Date)value));
                } else if (value instanceof LocalDateTime) {
                    sb.append(DateUtil.toDateTimeString(DateUtil.toDate((LocalDateTime)value)));
                } else {
                    sb.append(value);
                }
                sb.append("'");
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(sb.toString()));
            }
        }
        return sql;
    }
}

