/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.field.FieldQuery;
import com.mybatisflex.core.field.FieldQueryBuilder;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.DistinctQueryColumn;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.FieldWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.ibatis.exceptions.TooManyResultsException;

public class MapperUtil {
    private MapperUtil() {
    }

    public static QueryWrapper rawCountQueryWrapper(QueryWrapper queryWrapper) {
        return QueryWrapper.create().select(QueryMethods.count().as("total")).from(queryWrapper).as("t");
    }

    public static QueryWrapper optimizeCountQueryWrapper(QueryWrapper queryWrapper) {
        QueryWrapper clone = queryWrapper.clone();
        CPI.setOrderBys(clone, null);
        List<QueryColumn> selectColumns = CPI.getSelectColumns(clone);
        List<QueryColumn> groupByColumns = CPI.getGroupByColumns(clone);
        if (MapperUtil.hasDistinct(selectColumns) || MapperUtil.hasGroupBy(groupByColumns)) {
            return MapperUtil.rawCountQueryWrapper(clone);
        }
        if (MapperUtil.canClearJoins(clone)) {
            CPI.setJoins(clone, null);
        }
        CPI.setSelectColumns(clone, Collections.singletonList(QueryMethods.count().as("total")));
        return clone;
    }

    private static boolean hasDistinct(List<QueryColumn> selectColumns) {
        if (CollectionUtil.isEmpty(selectColumns)) {
            return false;
        }
        for (QueryColumn selectColumn : selectColumns) {
            if (!(selectColumn instanceof DistinctQueryColumn)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasGroupBy(List<QueryColumn> groupByColumns) {
        return CollectionUtil.isNotEmpty(groupByColumns);
    }

    private static boolean canClearJoins(QueryWrapper queryWrapper) {
        List<Join> joins = CPI.getJoins(queryWrapper);
        if (CollectionUtil.isEmpty(joins)) {
            return false;
        }
        for (Join join2 : joins) {
            if (" LEFT JOIN ".equals(CPI.getJoinType(join2))) continue;
            return false;
        }
        ArrayList joinTables = new ArrayList();
        joins.forEach(join -> {
            QueryTable joinQueryTable = CPI.getJoinQueryTable(join);
            if (joinQueryTable != null && StringUtil.isNotBlank(joinQueryTable.getName())) {
                joinTables.add(joinQueryTable.getName());
            }
        });
        QueryCondition where = CPI.getWhereQueryCondition(queryWrapper);
        return !CPI.containsTable(where, CollectionUtil.toArrayString(joinTables));
    }

    public static <R> void queryFields(BaseMapper<?> mapper, List<R> list, Consumer<FieldQueryBuilder<R>>[] consumers) {
        if (CollectionUtil.isEmpty(list) || ArrayUtil.isEmpty(consumers) || consumers[0] == null) {
            return;
        }
        list.forEach(entity -> {
            for (Consumer consumer : consumers) {
                Collection<Object> value;
                FieldQueryBuilder<Object> fieldQueryBuilder = new FieldQueryBuilder<Object>(entity);
                consumer.accept(fieldQueryBuilder);
                FieldQuery fieldQuery = fieldQueryBuilder.build();
                QueryWrapper childQuery = fieldQuery.getQueryWrapper();
                FieldWrapper fieldWrapper = FieldWrapper.of(entity.getClass(), fieldQuery.getField());
                Class<?> fieldType = fieldWrapper.getFieldType();
                Class<?> mappingType = fieldWrapper.getMappingType();
                if (Collection.class.isAssignableFrom(fieldType)) {
                    value = mapper.selectListByQueryAs(childQuery, mappingType);
                    if (!fieldType.isAssignableFrom(value.getClass())) {
                        fieldType = MapperUtil.getWrapType(fieldType);
                        Collection newValue = (Collection)ClassUtil.newInstance(fieldType);
                        newValue.addAll((Collection)value);
                        value = newValue;
                    }
                } else if (fieldType.isArray()) {
                    value = mapper.selectListByQueryAs(childQuery, mappingType);
                    value = value.toArray();
                } else {
                    value = mapper.selectOneByQueryAs(childQuery, mappingType);
                }
                fieldWrapper.set(value, entity);
            }
        });
    }

    private static Class<?> getWrapType(Class<?> type) {
        if (ClassUtil.canInstance(type.getModifiers())) {
            return type;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return HashSet.class;
        }
        throw new IllegalStateException("Field query can not support type: " + type.getName());
    }

    public static <T> T getSelectOneResult(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + size);
    }
}

