/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.query.BaseQueryWrapper;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.Joiner;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryConditionBuilder;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.query.StringQueryColumn;
import com.mybatisflex.core.query.StringQueryOrderBy;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class QueryWrapper
extends BaseQueryWrapper<QueryWrapper> {
    public static QueryWrapper create() {
        return new QueryWrapper();
    }

    public QueryWrapper select() {
        return this;
    }

    public QueryWrapper select(String ... columns) {
        for (String column : columns) {
            this.addSelectColumn(new StringQueryColumn(column));
        }
        return this;
    }

    public <T> QueryWrapper select(LambdaGetter<T> ... lambdaGetters) {
        for (LambdaGetter<T> lambdaGetter : lambdaGetters) {
            QueryColumn queryColumn = LambdaUtil.getQueryColumn(lambdaGetter);
            this.addSelectColumn(queryColumn);
        }
        return this;
    }

    public QueryWrapper select(QueryColumn ... queryColumns) {
        for (QueryColumn column : queryColumns) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper from(TableDef ... tableDefs) {
        for (TableDef tableDef : tableDefs) {
            this.from(new QueryTable(tableDef));
        }
        return this;
    }

    public QueryWrapper from(Class<?> ... entityClasses) {
        for (Class<?> entityClass : entityClasses) {
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
            this.from(new QueryTable(tableInfo.getSchema(), tableInfo.getTableName()));
        }
        return this;
    }

    public QueryWrapper from(String ... tables) {
        for (String table : tables) {
            if (StringUtil.isBlank(table)) {
                throw new IllegalArgumentException("table must not be null or blank.");
            }
            int indexOf = table.indexOf(".");
            if (indexOf > 0) {
                String schema = table.substring(0, indexOf);
                table = table.substring(indexOf + 1);
                this.from(new QueryTable(schema, table));
                continue;
            }
            this.from(new QueryTable(table));
        }
        return this;
    }

    public QueryWrapper from(QueryTable ... tables) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            this.queryTables = new ArrayList();
            this.queryTables.addAll(Arrays.asList(tables));
        } else {
            for (QueryTable table : tables) {
                boolean contains = false;
                for (QueryTable queryTable : this.queryTables) {
                    if (!queryTable.isSameTable(table)) continue;
                    contains = true;
                }
                if (contains) continue;
                this.queryTables.add(table);
            }
        }
        return this;
    }

    public QueryWrapper from(QueryWrapper queryWrapper) {
        return this.from(new SelectQueryTable(queryWrapper));
    }

    public QueryWrapper as(String alias) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            throw new IllegalArgumentException("query table must not be empty.");
        }
        ((QueryTable)this.queryTables.get((int)(this.queryTables.size() - 1))).alias = alias;
        return this;
    }

    public QueryWrapper where(QueryCondition queryCondition) {
        this.setWhereQueryCondition(queryCondition);
        return this;
    }

    public QueryWrapper where(String sql) {
        this.setWhereQueryCondition(new RawFragment(sql));
        return this;
    }

    public QueryWrapper where(String sql, Object ... params) {
        this.setWhereQueryCondition(new RawFragment(sql, params));
        return this;
    }

    public QueryWrapper where(Map<String, Object> whereConditions) {
        if (whereConditions != null) {
            whereConditions.forEach((s, o) -> this.and(QueryCondition.create(new QueryColumn((String)s), o)));
        }
        return this;
    }

    public <T> QueryConditionBuilder where(LambdaGetter<T> fn) {
        return new QueryConditionBuilder(this, LambdaUtil.getQueryColumn(fn), SqlConnector.AND);
    }

    public QueryWrapper and(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.AND);
    }

    public QueryWrapper and(String sql) {
        this.addWhereQueryCondition(new RawFragment(sql), SqlConnector.AND);
        return this;
    }

    public QueryWrapper and(String sql, Object ... params) {
        this.addWhereQueryCondition(new RawFragment(sql, params), SqlConnector.AND);
        return this;
    }

    public <T> QueryConditionBuilder and(LambdaGetter<T> fn) {
        return new QueryConditionBuilder(this, LambdaUtil.getQueryColumn(fn), SqlConnector.AND);
    }

    public QueryWrapper and(Consumer<QueryWrapper> consumer) {
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        QueryCondition whereQueryCondition = newWrapper.whereQueryCondition;
        if (whereQueryCondition != null) {
            this.and(new Brackets(whereQueryCondition));
        }
        return this;
    }

    public QueryWrapper or(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.OR);
    }

    public QueryWrapper or(String sql) {
        this.addWhereQueryCondition(new RawFragment(sql), SqlConnector.OR);
        return this;
    }

    public QueryWrapper or(String sql, Object ... params) {
        this.addWhereQueryCondition(new RawFragment(sql, params), SqlConnector.OR);
        return this;
    }

    public <T> QueryConditionBuilder or(LambdaGetter<T> fn) {
        return new QueryConditionBuilder(this, LambdaUtil.getQueryColumn(fn), SqlConnector.OR);
    }

    public QueryWrapper or(Consumer<QueryWrapper> consumer) {
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        QueryCondition whereQueryCondition = newWrapper.whereQueryCondition;
        if (whereQueryCondition != null) {
            this.or(new Brackets(whereQueryCondition));
        }
        return this;
    }

    public Joiner<QueryWrapper> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> leftJoin(String table, boolean when) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> leftJoin(Class<?> entityClass) {
        return this.joining(" LEFT JOIN ", entityClass, true);
    }

    public Joiner<QueryWrapper> leftJoin(Class<?> entityClass, boolean when) {
        return this.joining(" LEFT JOIN ", entityClass, when);
    }

    public Joiner<QueryWrapper> leftJoin(TableDef table) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> leftJoin(TableDef table, boolean when) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> leftJoin(QueryWrapper table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<QueryWrapper> leftJoin(QueryWrapper table, boolean when) {
        return this.joining(" LEFT JOIN ", table, when);
    }

    public Joiner<QueryWrapper> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> rightJoin(String table, boolean when) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> rightJoin(Class<?> entityClass) {
        return this.joining(" RIGHT JOIN ", entityClass, true);
    }

    public Joiner<QueryWrapper> rightJoin(Class<?> entityClass, boolean when) {
        return this.joining(" RIGHT JOIN ", entityClass, when);
    }

    public Joiner<QueryWrapper> rightJoin(TableDef table) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> rightJoin(TableDef table, boolean when) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> rightJoin(QueryWrapper table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<QueryWrapper> rightJoin(QueryWrapper table, boolean when) {
        return this.joining(" RIGHT JOIN ", table, when);
    }

    public Joiner<QueryWrapper> innerJoin(String table) {
        return this.joining(" INNER JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> innerJoin(String table, boolean when) {
        return this.joining(" INNER JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> innerJoin(Class<?> entityClass) {
        return this.joining(" INNER JOIN ", entityClass, true);
    }

    public Joiner<QueryWrapper> innerJoin(Class<?> entityClass, boolean when) {
        return this.joining(" INNER JOIN ", entityClass, when);
    }

    public Joiner<QueryWrapper> innerJoin(TableDef table) {
        return this.innerJoin(table, true);
    }

    public Joiner<QueryWrapper> innerJoin(TableDef table, boolean when) {
        return this.joining(" INNER JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> innerJoin(QueryWrapper table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<QueryWrapper> innerJoin(QueryWrapper table, boolean when) {
        return this.joining(" INNER JOIN ", table, when);
    }

    public Joiner<QueryWrapper> fullJoin(String table) {
        return this.joining(" FULL JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> fullJoin(String table, boolean when) {
        return this.joining(" FULL JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> fullJoin(Class<?> entityClass) {
        return this.joining(" FULL JOIN ", entityClass, true);
    }

    public Joiner<QueryWrapper> fullJoin(Class<?> entityClass, boolean when) {
        return this.joining(" FULL JOIN ", entityClass, when);
    }

    public Joiner<QueryWrapper> fullJoin(TableDef table) {
        return this.joining(" FULL JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> fullJoin(TableDef table, boolean when) {
        return this.joining(" FULL JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> fullJoin(QueryWrapper table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<QueryWrapper> fullJoin(QueryWrapper table, boolean when) {
        return this.joining(" FULL JOIN ", table, when);
    }

    public Joiner<QueryWrapper> crossJoin(String table) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> crossJoin(String table, boolean when) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> crossJoin(Class<?> entityClass) {
        return this.joining(" CROSS JOIN ", entityClass, true);
    }

    public Joiner<QueryWrapper> crossJoin(Class<?> entityClass, boolean when) {
        return this.joining(" CROSS JOIN ", entityClass, when);
    }

    public Joiner<QueryWrapper> crossJoin(TableDef table) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> crossJoin(TableDef table, boolean when) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> crossJoin(QueryWrapper table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public Joiner<QueryWrapper> crossJoin(QueryWrapper table, boolean when) {
        return this.joining(" CROSS JOIN ", table, when);
    }

    public Joiner<QueryWrapper> join(String table) {
        return this.joining(" JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> join(String table, boolean when) {
        return this.joining(" JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> join(Class<?> entityClass) {
        return this.joining(" JOIN ", entityClass, true);
    }

    public Joiner<QueryWrapper> join(Class<?> entityClass, boolean when) {
        return this.joining(" JOIN ", entityClass, when);
    }

    public Joiner<QueryWrapper> join(TableDef table) {
        return this.joining(" JOIN ", new QueryTable(table), true);
    }

    public Joiner<QueryWrapper> join(TableDef table, boolean when) {
        return this.joining(" JOIN ", new QueryTable(table), when);
    }

    public Joiner<QueryWrapper> join(QueryWrapper table) {
        return this.joining(" JOIN ", table, true);
    }

    public Joiner<QueryWrapper> join(QueryWrapper table, boolean when) {
        return this.joining(" JOIN ", table, when);
    }

    public QueryWrapper union(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.union(unionQuery));
        return this;
    }

    public QueryWrapper unionAll(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.unionAll(unionQuery));
        return this;
    }

    public QueryWrapper forUpdate() {
        this.addEndFragment("FOR UPDATE");
        return this;
    }

    public QueryWrapper forUpdateNoWait() {
        this.addEndFragment("FOR UPDATE NOWAIT");
        return this;
    }

    protected Joiner<QueryWrapper> joining(String type, QueryTable table, boolean when) {
        Join join = new Join(type, table, when);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<QueryWrapper>((QueryWrapper)this.addJoin(join), join);
    }

    protected Joiner<QueryWrapper> joining(String type, Class<?> entityClass, boolean when) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        QueryTable queryTable = new QueryTable(tableInfo.getSchema(), tableInfo.getTableName());
        return this.joining(type, queryTable, when);
    }

    protected Joiner<QueryWrapper> joining(String type, QueryWrapper queryWrapper, boolean when) {
        Join join = new Join(type, queryWrapper, when);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<QueryWrapper>((QueryWrapper)this.addJoin(join), join);
    }

    public QueryWrapper groupBy(String name) {
        this.addGroupByColumns(new QueryColumn(name));
        return this;
    }

    public QueryWrapper groupBy(String ... names) {
        for (String name : names) {
            this.groupBy(name);
        }
        return this;
    }

    public QueryWrapper groupBy(QueryColumn column) {
        this.addGroupByColumns(column);
        return this;
    }

    public QueryWrapper groupBy(QueryColumn ... columns) {
        for (QueryColumn column : columns) {
            this.groupBy(column);
        }
        return this;
    }

    public QueryWrapper having(QueryCondition queryCondition) {
        this.addHavingQueryCondition(queryCondition, SqlConnector.AND);
        return this;
    }

    public QueryWrapper orderBy(QueryOrderBy ... orderBys) {
        for (QueryOrderBy queryOrderBy : orderBys) {
            this.addOrderBy(queryOrderBy);
        }
        return this;
    }

    public QueryWrapper orderBy(String ... orderBys) {
        if (orderBys == null || orderBys.length == 0) {
            return this;
        }
        for (String queryOrderBy : orderBys) {
            if (!StringUtil.isNotBlank(queryOrderBy)) continue;
            this.addOrderBy(new StringQueryOrderBy(queryOrderBy));
        }
        return this;
    }

    public QueryWrapper limit(Integer rows) {
        this.setLimitRows(rows);
        return this;
    }

    public QueryWrapper offset(Integer offset) {
        this.setLimitOffset(offset);
        return this;
    }

    public QueryWrapper limit(Integer offset, Integer rows) {
        this.setLimitOffset(offset);
        this.setLimitRows(rows);
        return this;
    }

    public QueryWrapper datasource(String datasource) {
        this.setDataSource(datasource);
        return this;
    }

    public QueryWrapper hint(String hint) {
        this.setHint(hint);
        return this;
    }

    Object[] getValueArray() {
        ArrayList<Object> columnValues = null;
        List<QueryColumn> selectColumns = this.getSelectColumns();
        if (CollectionUtil.isNotEmpty(selectColumns)) {
            for (QueryColumn selectColumn : selectColumns) {
                Object[] paramValues;
                if (!(selectColumn instanceof HasParamsColumn) || !ArrayUtil.isNotEmpty(paramValues = ((HasParamsColumn)((Object)selectColumn)).getParamValues())) continue;
                if (columnValues == null) {
                    columnValues = new ArrayList<Object>();
                }
                columnValues.addAll(Arrays.asList(paramValues));
            }
        }
        ArrayList<Object> tableValues = null;
        List<QueryTable> queryTables = this.getQueryTables();
        if (CollectionUtil.isNotEmpty(queryTables)) {
            for (QueryTable queryTable : queryTables) {
                Object[] tableValueArray = queryTable.getValueArray();
                if (tableValueArray.length <= 0) continue;
                if (tableValues == null) {
                    tableValues = new ArrayList<Object>();
                }
                tableValues.addAll(Arrays.asList(tableValueArray));
            }
        }
        ArrayList joinValues = null;
        List<Join> joins = this.getJoins();
        if (CollectionUtil.isNotEmpty(joins)) {
            for (Join join : joins) {
                QueryCondition onCondition;
                Object[] values;
                QueryTable joinTable = join.getQueryTable();
                Object[] valueArray = joinTable.getValueArray();
                if (valueArray.length > 0) {
                    if (joinValues == null) {
                        joinValues = new ArrayList();
                    }
                    joinValues.addAll(Arrays.asList(valueArray));
                }
                if ((values = WrapperUtil.getValues(onCondition = join.getOnCondition())).length <= 0) continue;
                if (joinValues == null) {
                    joinValues = new ArrayList();
                }
                joinValues.addAll(Arrays.asList(values));
            }
        }
        Object[] whereValues = WrapperUtil.getValues(this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues(this.havingQueryCondition);
        Object[] paramValues = ArrayUtil.concat(whereValues, havingValues);
        if (CollectionUtil.isNotEmpty(this.unions)) {
            for (UnionWrapper union : this.unions) {
                QueryWrapper queryWrapper = union.getQueryWrapper();
                paramValues = ArrayUtil.concat(paramValues, queryWrapper.getValueArray());
            }
        }
        Object[] returnValues = columnValues == null ? FlexConsts.EMPTY_ARRAY : columnValues.toArray();
        returnValues = tableValues != null ? ArrayUtil.concat(returnValues, tableValues.toArray()) : returnValues;
        returnValues = joinValues != null ? ArrayUtil.concat(returnValues, joinValues.toArray()) : returnValues;
        returnValues = ArrayUtil.concat(returnValues, paramValues);
        return returnValues;
    }

    List<QueryWrapper> getChildSelect() {
        List<QueryWrapper> whereChildQuery = WrapperUtil.getChildQueryWrapper(this.whereQueryCondition);
        List<QueryWrapper> havingChildQuery = WrapperUtil.getChildQueryWrapper(this.havingQueryCondition);
        if (whereChildQuery.isEmpty() && havingChildQuery.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueryWrapper> childQueryWrappers = new ArrayList<QueryWrapper>(whereChildQuery);
        childQueryWrappers.addAll(havingChildQuery);
        return childQueryWrappers;
    }

    public String toSQL() {
        String sql = DialectFactory.getDialect().forSelectByQuery(this);
        return SqlUtil.replaceSqlParams(sql, this.getValueArray());
    }

    @Override
    public QueryWrapper clone() {
        return (QueryWrapper)super.clone();
    }
}

