/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.WebSocketRoute;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.WebSocketRouteImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class WebSocketRouter {
    private List<RouteInfo> routes = new ArrayList<RouteInfo>();

    void add(UrlMatcher matcher, Consumer<WebSocketRoute> handler) {
        this.routes.add(0, new RouteInfo(matcher, handler));
    }

    boolean handle(WebSocketRouteImpl route) {
        for (RouteInfo routeInfo : this.routes) {
            if (!routeInfo.matcher.test(route.url())) continue;
            routeInfo.handle(route);
            return true;
        }
        return false;
    }

    JsonObject interceptionPatterns() {
        List<UrlMatcher> matchers = this.routes.stream().map(r -> r.matcher).collect(Collectors.toList());
        return Utils.interceptionPatterns(matchers);
    }

    private static class RouteInfo {
        final UrlMatcher matcher;
        private final Consumer<WebSocketRoute> handler;

        RouteInfo(UrlMatcher matcher, Consumer<WebSocketRoute> handler) {
            this.matcher = matcher;
            this.handler = handler;
        }

        void handle(WebSocketRouteImpl route) {
            this.handler.accept(route);
            route.afterHandle();
        }
    }
}

