/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.Waitable;
import java.util.Collection;

class WaitableRace<T>
implements Waitable<T> {
    private final Collection<Waitable<T>> waitables;
    private Waitable<T> firstReady;

    WaitableRace(Collection<Waitable<T>> waitables) {
        this.waitables = waitables;
    }

    @Override
    public boolean isDone() {
        if (this.firstReady != null) {
            return true;
        }
        for (Waitable<T> w : this.waitables) {
            if (!w.isDone()) continue;
            this.firstReady = w;
            return true;
        }
        return false;
    }

    @Override
    public T get() {
        try {
            T t = this.firstReady.get();
            return t;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        for (Waitable<T> w : this.waitables) {
            w.dispose();
        }
    }
}

