/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.WritableStream;
import com.microsoft.playwright.options.ClientCertificate;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.HttpHeader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Utils {
    static <F, T> T convertType(F f, Class<T> t) {
        if (f == null) {
            return null;
        }
        if (!t.getSuperclass().equals(Object.class) && !t.getSuperclass().equals(Enum.class)) {
            throw new PlaywrightException("Cannot convert to " + t.getCanonicalName() + " that has superclass " + t.getSuperclass().getCanonicalName());
        }
        if (!f.getClass().getSuperclass().equals(t.getSuperclass())) {
            throw new PlaywrightException("Cannot convert from " + t.getCanonicalName() + " that has superclass " + t.getSuperclass().getCanonicalName());
        }
        if (f instanceof Enum) {
            return Enum.valueOf(t, ((Enum)f).name());
        }
        try {
            T result = t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field toField : t.getDeclaredFields()) {
                if (toField.isSynthetic()) continue;
                if (Modifier.isStatic(toField.getModifiers())) {
                    throw new RuntimeException("Unexpected field modifiers: " + t.getCanonicalName() + "." + toField.getName() + ", modifiers: " + toField.getModifiers());
                }
                try {
                    Field fromField = f.getClass().getDeclaredField(toField.getName());
                    Object value = fromField.get(f);
                    if (value == null) continue;
                    toField.set(result, value);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PlaywrightException("Internal error", e);
        }
    }

    public static <T> T clone(T f) {
        if (f == null) {
            return f;
        }
        return (T)Utils.convertType(f, f.getClass());
    }

    static String mimeType(Path path) {
        String mimeType;
        try {
            mimeType = Files.probeContentType(path);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to determine mime type", e);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    static void addFilePathUploadParams(Path[] items, JsonObject params, BrowserContextImpl context) {
        List<Path> localPaths = new ArrayList<Path>();
        Path localDirectory = Utils.resolvePathsAndDirectoryForInputFiles(items, localPaths);
        if (items.length == 0) {
            params.add("payloads", (JsonElement)new JsonArray());
        } else if (context.connection.isRemote) {
            if (localDirectory != null) {
                localPaths = Utils.collectFiles(localDirectory);
            }
            JsonObject json = Utils.createTempFiles(context, localDirectory, localPaths);
            JsonArray writableStreams = json.getAsJsonArray("writableStreams");
            JsonArray jsonStreams = Utils.copyLocalToTempFiles(context, localPaths, writableStreams);
            if (json.has("rootDir")) {
                params.add("directoryStream", json.get("rootDir"));
            } else {
                params.add("streams", (JsonElement)jsonStreams);
            }
        } else {
            if (!localPaths.isEmpty()) {
                params.add("localPaths", (JsonElement)Serialization.toJsonArray(localPaths.toArray(new Path[0])));
            }
            if (localDirectory != null) {
                params.addProperty("localDirectory", localDirectory.toString());
            }
        }
    }

    private static Path resolvePathsAndDirectoryForInputFiles(Path[] items, List<Path> outLocalPaths) {
        Path localDirectory = null;
        try {
            for (Path item : items) {
                if (Files.isDirectory(item, new LinkOption[0])) {
                    if (localDirectory != null) {
                        throw new PlaywrightException("Multiple directories are not supported");
                    }
                    localDirectory = item.toRealPath(new LinkOption[0]);
                    continue;
                }
                outLocalPaths.add(item.toRealPath(new LinkOption[0]));
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Cannot get absolute file path", e);
        }
        if (!outLocalPaths.isEmpty() && localDirectory != null) {
            throw new PlaywrightException("File paths must be all files or a single directory");
        }
        return localDirectory;
    }

    private static List<Path> collectFiles(Path localDirectory) {
        try {
            return Files.walk(localDirectory, new FileVisitOption[0]).filter(e -> Files.isRegularFile(e, new LinkOption[0])).collect(Collectors.toList());
        }
        catch (IOException e2) {
            throw new PlaywrightException("Failed to traverse directory", e2);
        }
    }

    private static JsonArray copyLocalToTempFiles(BrowserContextImpl context, List<Path> localPaths, JsonArray writableStreams) {
        JsonArray jsonStreams = new JsonArray();
        for (int i = 0; i < localPaths.size(); ++i) {
            JsonObject jsonStream = writableStreams.get(i).getAsJsonObject();
            WritableStream temp = (WritableStream)context.connection.getExistingObject(jsonStream.get("guid").getAsString());
            try (OutputStream out = temp.stream();){
                Files.copy(localPaths.get(i), out);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to copy file to remote server.", e);
            }
            jsonStreams.add((JsonElement)temp.toProtocolRef());
        }
        return jsonStreams;
    }

    private static JsonObject createTempFiles(BrowserContextImpl context, Path localDirectory, List<Path> localPaths) {
        JsonObject tempFilesParams = new JsonObject();
        if (localDirectory != null) {
            tempFilesParams.addProperty("rootDirName", localDirectory.getFileName().toString());
        }
        JsonArray items = new JsonArray();
        for (Path path : localPaths) {
            long lastModifiedMs;
            try {
                lastModifiedMs = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                throw new PlaywrightException("Cannot read file timestamp: " + path, e);
            }
            Path name = localDirectory == null ? path.getFileName() : localDirectory.relativize(path);
            JsonObject item = new JsonObject();
            item.addProperty("name", name.toString());
            item.addProperty("lastModifiedMs", (Number)lastModifiedMs);
            items.add((JsonElement)item);
        }
        tempFilesParams.add("items", (JsonElement)items);
        return context.sendMessage("createTempFiles", tempFilesParams, ChannelOwner.NO_TIMEOUT).getAsJsonObject();
    }

    static void checkFilePayloadSize(FilePayload[] files) {
        long totalSize = 0L;
        for (FilePayload file : files) {
            totalSize += (long)file.buffer.length;
        }
        if (totalSize > 0x3200000L) {
            throw new PlaywrightException("Cannot set buffer larger than 50Mb, please write it to a file and pass its path instead.");
        }
    }

    static FilePayload[] toFilePayloads(Path[] files) {
        ArrayList<FilePayload> payloads = new ArrayList<FilePayload>();
        for (Path file : files) {
            payloads.add(Utils.toFilePayload(file));
        }
        return payloads.toArray(new FilePayload[0]);
    }

    static FilePayload toFilePayload(Path file) {
        byte[] buffer;
        try {
            buffer = Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to read from file", e);
        }
        return new FilePayload(file.getFileName().toString(), null, buffer);
    }

    static void mkParentDirs(Path file) {
        Path dir = file.getParent();
        if (dir != null && !Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to create parent directory: " + dir, e);
            }
        }
    }

    static void writeToFile(byte[] buffer, Path path) {
        Utils.mkParentDirs(path);
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            out.write(buffer);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to write to file", e);
        }
    }

    static void writeToFile(InputStream inputStream, Path path) {
        Utils.mkParentDirs(path);
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            int length;
            byte[] buf = new byte[0x100000];
            while ((length = inputStream.read(buf)) > 0) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to write to file", e);
        }
    }

    static boolean isSafeCloseError(PlaywrightException exception) {
        return Utils.isSafeCloseError(exception.getMessage());
    }

    static boolean isSafeCloseError(String error) {
        return error.contains("Browser has been closed") || error.contains("Target page, context or browser has been closed");
    }

    static String createGuid() {
        StringBuffer result = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 4; ++i) {
            result.append(Integer.toHexString(random.nextInt()));
        }
        return result.toString();
    }

    static Map<String, String> toHeadersMap(List<HttpHeader> headers) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (HttpHeader header : headers) {
            map.put(header.name.toLowerCase(), header.value);
        }
        return map;
    }

    static List<HttpHeader> toHeadersList(Map<String, String> headers) {
        ArrayList<HttpHeader> list = new ArrayList<HttpHeader>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            HttpHeader header = new HttpHeader();
            header.name = entry.getKey();
            header.value = entry.getValue();
            list.add(header);
        }
        return list;
    }

    static String toJsRegexFlags(Pattern pattern) {
        String regexFlags = "";
        if ((pattern.flags() & 2) != 0) {
            regexFlags = regexFlags + "i";
        }
        if ((pattern.flags() & 0x20) != 0) {
            regexFlags = regexFlags + "s";
        }
        if ((pattern.flags() & 8) != 0) {
            regexFlags = regexFlags + "m";
        }
        if ((pattern.flags() & 0xFFFFFFD5) != 0) {
            throw new PlaywrightException("Unexpected RegEx flag, only CASE_INSENSITIVE, DOTALL and MULTILINE are supported.");
        }
        return regexFlags;
    }

    static int fromJsRegexFlags(String regexFlags) {
        int flags = 0;
        if (regexFlags.contains("i")) {
            flags |= 2;
        }
        if (regexFlags.contains("s")) {
            flags |= 0x20;
        }
        if (regexFlags.contains("m")) {
            flags |= 8;
        }
        return flags;
    }

    static String addSourceUrlToScript(String source, Path path) {
        return source + "\n//# sourceURL=" + path.toString().replace("\n", "");
    }

    static void addToProtocol(JsonObject params, List<ClientCertificate> clientCertificateList) {
        if (clientCertificateList == null) {
            return;
        }
        JsonArray clientCertificates = new JsonArray();
        for (ClientCertificate cert : clientCertificateList) {
            JsonObject jsonCert = new JsonObject();
            jsonCert.addProperty("origin", cert.origin);
            try {
                String pfxBase64;
                String keyBase64;
                String certBase64 = Utils.base64Buffer(cert.cert, cert.certPath);
                if (certBase64 != null) {
                    jsonCert.addProperty("cert", certBase64);
                }
                if ((keyBase64 = Utils.base64Buffer(cert.key, cert.keyPath)) != null) {
                    jsonCert.addProperty("key", keyBase64);
                }
                if ((pfxBase64 = Utils.base64Buffer(cert.pfx, cert.pfxPath)) != null) {
                    jsonCert.addProperty("pfx", pfxBase64);
                }
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read from file", e);
            }
            if (cert.passphrase != null) {
                jsonCert.addProperty("passphrase", cert.passphrase);
            }
            clientCertificates.add((JsonElement)jsonCert);
        }
        params.remove("clientCertificates");
        params.add("clientCertificates", (JsonElement)clientCertificates);
    }

    private static String base64Buffer(byte[] bytes, Path path) throws IOException {
        if (path != null) {
            bytes = Files.readAllBytes(path);
        }
        if (bytes == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    static JsonObject interceptionPatterns(List<UrlMatcher> matchers) {
        JsonArray jsonPatterns = new JsonArray();
        for (UrlMatcher matcher : matchers) {
            JsonObject jsonPattern = new JsonObject();
            if (matcher.glob != null) {
                jsonPattern.addProperty("glob", matcher.glob);
            } else if (matcher.pattern != null) {
                jsonPattern.addProperty("regexSource", matcher.pattern.pattern());
                jsonPattern.addProperty("regexFlags", Utils.toJsRegexFlags(matcher.pattern));
            } else {
                jsonPattern.addProperty("glob", "**/*");
                jsonPatterns = new JsonArray();
                jsonPatterns.add((JsonElement)jsonPattern);
                break;
            }
            jsonPatterns.add((JsonElement)jsonPattern);
        }
        JsonObject result = new JsonObject();
        result.add("patterns", (JsonElement)jsonPatterns);
        return result;
    }
}

