/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.FileChooser;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.impl.ElementHandleImpl;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.FilePayload;
import java.nio.file.Path;

class FileChooserImpl
implements FileChooser {
    private final PageImpl page;
    private final ElementHandleImpl element;
    private final boolean isMultiple;

    FileChooserImpl(PageImpl page, ElementHandleImpl element, boolean isMultiple) {
        this.page = page;
        this.element = element;
        this.isMultiple = isMultiple;
    }

    @Override
    public ElementHandle element() {
        return this.element;
    }

    @Override
    public boolean isMultiple() {
        return this.isMultiple;
    }

    @Override
    public Page page() {
        return this.page;
    }

    @Override
    public void setFiles(Path files, FileChooser.SetFilesOptions options) {
        this.setFiles(new Path[]{files}, options);
    }

    @Override
    public void setFiles(Path[] files, FileChooser.SetFilesOptions options) {
        this.element.setInputFiles(files, Utils.convertType(options, ElementHandle.SetInputFilesOptions.class));
    }

    @Override
    public void setFiles(FilePayload files, FileChooser.SetFilesOptions options) {
        this.setFiles(new FilePayload[]{files}, options);
    }

    @Override
    public void setFiles(FilePayload[] files, FileChooser.SetFilesOptions options) {
        this.element.setInputFiles(files, Utils.convertType(options, ElementHandle.SetInputFilesOptions.class));
    }
}

