/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.APIResponse;
import com.microsoft.playwright.assertions.APIResponseAssertions;
import com.microsoft.playwright.impl.APIResponseImpl;
import java.util.List;
import java.util.regex.Pattern;
import org.opentest4j.AssertionFailedError;

public class APIResponseAssertionsImpl
implements APIResponseAssertions {
    private final APIResponse actual;
    private final boolean isNot;

    APIResponseAssertionsImpl(APIResponse response, boolean isNot) {
        this.actual = response;
        this.isNot = isNot;
    }

    public APIResponseAssertionsImpl(APIResponse response) {
        this(response, false);
    }

    @Override
    public APIResponseAssertions not() {
        return new APIResponseAssertionsImpl(this.actual, !this.isNot);
    }

    @Override
    public void isOK() {
        String text;
        String contentType;
        List<String> logList;
        String log;
        if (this.actual.ok() == !this.isNot) {
            return;
        }
        String message = "Response status expected to be within [200..299] range, was " + this.actual.status();
        if (this.isNot) {
            message = message.replace("expected to", "expected not to");
        }
        if (!(log = String.join((CharSequence)"\n", logList = ((APIResponseImpl)this.actual).fetchLog())).isEmpty()) {
            log = "\nCall log:\n" + log;
        }
        boolean isTextEncoding = (contentType = this.actual.headers().get("content-type")) == null ? false : APIResponseAssertionsImpl.isTextualMimeType(contentType);
        String responseText = "";
        if (isTextEncoding && (text = this.actual.text()) != null) {
            responseText = "\nResponse text:\n" + (text.length() > 1000 ? text.substring(0, 1000) : text);
        }
        throw new AssertionFailedError(message + log + responseText);
    }

    static boolean isTextualMimeType(String mimeType) {
        return Pattern.matches("^(text/.*?|application/(json|(x-)?javascript|xml.*?|ecmascript|graphql|x-www-form-urlencoded)|image/svg(\\+xml)?|application/.*?(\\+json|\\+xml))(;\\s*charset=.*)?$", mimeType);
    }
}

