/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class VelocityRender
extends Render {
    private static final String contentType = "text/html; charset=" + VelocityRender.getEncoding();
    private static final Properties properties = new Properties();
    private static boolean notInit = true;

    public VelocityRender(String view) {
        this.view = view;
    }

    static void init(ServletContext servletContext) {
        String webPath = servletContext.getRealPath("/");
        properties.setProperty("file.resource.loader.path", webPath);
        properties.setProperty("ISO-8859-1", VelocityRender.getEncoding());
        properties.setProperty("input.encoding", VelocityRender.getEncoding());
        properties.setProperty("output.encoding", VelocityRender.getEncoding());
    }

    public static void setProperties(Properties properties) {
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        for (Map.Entry<Object, Object> e : set) {
            VelocityRender.properties.put(e.getKey(), e.getValue());
        }
    }

    public String getContentType() {
        return contentType;
    }

    @Override
    public void render() {
        if (notInit) {
            Velocity.init((Properties)properties);
            notInit = false;
        }
        PrintWriter writer = null;
        try {
            VelocityContext context = new VelocityContext();
            Enumeration attrs = this.request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String attrName = (String)attrs.nextElement();
                context.put(attrName, this.request.getAttribute(attrName));
            }
            Template template = Velocity.getTemplate((String)this.view);
            this.response.setContentType(this.getContentType());
            writer = this.response.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.flush();
        }
        catch (ResourceNotFoundException e) {
            throw new RenderException("Example : error : cannot find template " + this.view, e);
        }
        catch (ParseErrorException e) {
            throw new RenderException("Example : Syntax error in template " + this.view + ":" + (Object)((Object)e), e);
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

