/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.config.Constants;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.ModelRecordElResolver;
import com.jfinal.render.CaptchaRender;
import com.jfinal.render.ContentType;
import com.jfinal.render.ErrorRender;
import com.jfinal.render.FileRender;
import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.HtmlRender;
import com.jfinal.render.IErrorRenderFactory;
import com.jfinal.render.IMainRenderFactory;
import com.jfinal.render.IXmlRenderFactory;
import com.jfinal.render.JavascriptRender;
import com.jfinal.render.JsonRender;
import com.jfinal.render.JspRender;
import com.jfinal.render.NullRender;
import com.jfinal.render.Redirect301Render;
import com.jfinal.render.RedirectRender;
import com.jfinal.render.Render;
import com.jfinal.render.TextRender;
import com.jfinal.render.VelocityRender;
import com.jfinal.render.ViewType;
import com.jfinal.render.XmlRender;
import java.io.File;
import java.util.Locale;
import javax.servlet.ServletContext;

public class RenderFactory {
    private Constants constants;
    private ServletContext servletContext;
    private IMainRenderFactory mainRenderFactory = null;
    private IErrorRenderFactory errorRenderFactory = null;
    private IXmlRenderFactory xmlRenderFactory = null;
    private static final RenderFactory me = new RenderFactory();

    ServletContext getServletContext() {
        return this.servletContext;
    }

    private RenderFactory() {
    }

    public static RenderFactory me() {
        return me;
    }

    public void setMainRenderFactory(IMainRenderFactory mainRenderFactory) {
        if (mainRenderFactory != null) {
            this.mainRenderFactory = mainRenderFactory;
        }
    }

    public void setErrorRenderFactory(IErrorRenderFactory errorRenderFactory) {
        if (errorRenderFactory != null) {
            this.errorRenderFactory = errorRenderFactory;
        }
    }

    public void setXmlRenderFactory(IXmlRenderFactory xmlRenderFactory) {
        if (xmlRenderFactory != null) {
            this.xmlRenderFactory = xmlRenderFactory;
        }
    }

    public void init(Constants constants, ServletContext servletContext) {
        this.constants = constants;
        this.servletContext = servletContext;
        Render.init(constants.getEncoding(), constants.getDevMode());
        this.initFreeMarkerRender(servletContext);
        this.initVelocityRender(servletContext);
        this.initJspRender(servletContext);
        this.initFileRender(servletContext);
        if (this.mainRenderFactory == null) {
            ViewType defaultViewType = constants.getViewType();
            if (defaultViewType == ViewType.FREE_MARKER) {
                this.mainRenderFactory = new FreeMarkerRenderFactory();
            } else if (defaultViewType == ViewType.JSP) {
                this.mainRenderFactory = new JspRenderFactory();
            } else if (defaultViewType == ViewType.VELOCITY) {
                this.mainRenderFactory = new VelocityRenderFactory();
            } else {
                throw new RuntimeException("View Type can not be null.");
            }
        }
        if (this.errorRenderFactory == null) {
            this.errorRenderFactory = new ErrorRenderFactory();
        }
        if (this.xmlRenderFactory == null) {
            this.xmlRenderFactory = new XmlRenderFactory();
        }
    }

    private void initFreeMarkerRender(ServletContext servletContext) {
        try {
            Class.forName("freemarker.template.Template");
            FreeMarkerRender.init(servletContext, Locale.getDefault(), this.constants.getFreeMarkerTemplateUpdateDelay());
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
    }

    private void initVelocityRender(ServletContext servletContext) {
        try {
            Class.forName("org.apache.velocity.VelocityContext");
            VelocityRender.init(servletContext);
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
    }

    private void initJspRender(ServletContext servletContext) {
        try {
            Class.forName("javax.el.ELResolver");
            Class.forName("javax.servlet.jsp.JspFactory");
            ModelRecordElResolver.init(servletContext);
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            LogKit.logNothing(e);
        }
    }

    private void initFileRender(ServletContext servletContext) {
        String downloadPath = this.constants.getBaseDownloadPath();
        downloadPath = downloadPath.trim();
        String baseDownloadPath = PathKit.isAbsolutelyPath(downloadPath = downloadPath.replaceAll("\\\\", "/")) ? downloadPath : PathKit.getWebRootPath() + File.separator + downloadPath;
        if (!baseDownloadPath.equals("/") && baseDownloadPath.endsWith("/")) {
            baseDownloadPath = baseDownloadPath.substring(0, baseDownloadPath.length() - 1);
        }
        FileRender.init(baseDownloadPath, servletContext);
    }

    public Render getRender(String view) {
        return this.mainRenderFactory.getRender(view);
    }

    public Render getFreeMarkerRender(String view) {
        return new FreeMarkerRender(view);
    }

    public Render getJspRender(String view) {
        return new JspRender(view);
    }

    public Render getVelocityRender(String view) {
        return new VelocityRender(view);
    }

    public Render getJsonRender() {
        return new JsonRender();
    }

    public Render getJsonRender(String key, Object value) {
        return new JsonRender(key, value);
    }

    public Render getJsonRender(String[] attrs) {
        return new JsonRender(attrs);
    }

    public Render getJsonRender(String jsonText) {
        return new JsonRender(jsonText);
    }

    public Render getJsonRender(Object object) {
        return new JsonRender(object);
    }

    public Render getTextRender(String text) {
        return new TextRender(text);
    }

    public Render getTextRender(String text, String contentType) {
        return new TextRender(text, contentType);
    }

    public Render getTextRender(String text, ContentType contentType) {
        return new TextRender(text, contentType);
    }

    public Render getDefaultRender(String view) {
        ViewType viewType = this.constants.getViewType();
        if (viewType == ViewType.FREE_MARKER) {
            return new FreeMarkerRender(view + this.constants.getFreeMarkerViewExtension());
        }
        if (viewType == ViewType.JSP) {
            return new JspRender(view + this.constants.getJspViewExtension());
        }
        if (viewType == ViewType.VELOCITY) {
            return new VelocityRender(view + this.constants.getVelocityViewExtension());
        }
        return this.mainRenderFactory.getRender(view + this.mainRenderFactory.getViewExtension());
    }

    public Render getErrorRender(int errorCode, String view) {
        return this.errorRenderFactory.getRender(errorCode, view);
    }

    public Render getErrorRender(int errorCode) {
        return this.errorRenderFactory.getRender(errorCode, this.constants.getErrorView(errorCode));
    }

    public Render getFileRender(String fileName) {
        return new FileRender(fileName);
    }

    public Render getFileRender(File file) {
        return new FileRender(file);
    }

    public Render getRedirectRender(String url) {
        return new RedirectRender(url);
    }

    public Render getRedirectRender(String url, boolean withQueryString) {
        return new RedirectRender(url, withQueryString);
    }

    public Render getRedirect301Render(String url) {
        return new Redirect301Render(url);
    }

    public Render getRedirect301Render(String url, boolean withQueryString) {
        return new Redirect301Render(url, withQueryString);
    }

    public Render getNullRender() {
        return new NullRender();
    }

    public Render getJavascriptRender(String jsText) {
        return new JavascriptRender(jsText);
    }

    public Render getHtmlRender(String htmlText) {
        return new HtmlRender(htmlText);
    }

    public Render getXmlRender(String view) {
        return this.xmlRenderFactory.getRender(view);
    }

    public Render getCaptchaRender() {
        return new CaptchaRender();
    }

    private static final class XmlRenderFactory
    implements IXmlRenderFactory {
        private XmlRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new XmlRender(view);
        }
    }

    private static final class ErrorRenderFactory
    implements IErrorRenderFactory {
        private ErrorRenderFactory() {
        }

        @Override
        public Render getRender(int errorCode, String view) {
            return new ErrorRender(errorCode, view);
        }
    }

    private static final class VelocityRenderFactory
    implements IMainRenderFactory {
        private VelocityRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new VelocityRender(view);
        }

        @Override
        public String getViewExtension() {
            return ".html";
        }
    }

    private static final class JspRenderFactory
    implements IMainRenderFactory {
        private JspRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new JspRender(view);
        }

        @Override
        public String getViewExtension() {
            return ".jsp";
        }
    }

    private static final class FreeMarkerRenderFactory
    implements IMainRenderFactory {
        private FreeMarkerRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new FreeMarkerRender(view);
        }

        @Override
        public String getViewExtension() {
            return ".html";
        }
    }
}

