/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.core.JFinal;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;

public class RedirectRender
extends Render {
    private String url;
    private boolean withQueryString;
    private static final String contextPath = RedirectRender.getContxtPath();

    static String getContxtPath() {
        String cp = JFinal.me().getContextPath();
        return "".equals(cp) || "/".equals(cp) ? null : cp;
    }

    public RedirectRender(String url) {
        this.url = url;
        this.withQueryString = false;
    }

    public RedirectRender(String url, boolean withQueryString) {
        this.url = url;
        this.withQueryString = withQueryString;
    }

    public String buildFinalUrl() {
        String queryString;
        String result = contextPath != null && this.url.indexOf("://") == -1 ? contextPath + this.url : this.url;
        if (this.withQueryString && (queryString = this.request.getQueryString()) != null) {
            result = result.indexOf("?") == -1 ? result + "?" + queryString : result + "&" + queryString;
        }
        return result;
    }

    @Override
    public void render() {
        String finalUrl = this.buildFinalUrl();
        try {
            this.response.sendRedirect(finalUrl);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }
}

