/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.c3p0;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;

public class C3p0Plugin
implements IPlugin,
IDataSourceProvider {
    private String jdbcUrl;
    private String user;
    private String password;
    private String driverClass = "com.mysql.jdbc.Driver";
    private int maxPoolSize = 100;
    private int minPoolSize = 10;
    private int initialPoolSize = 10;
    private int maxIdleTime = 20;
    private int acquireIncrement = 2;
    private ComboPooledDataSource dataSource;
    private boolean isStarted = false;

    public C3p0Plugin setDriverClass(String driverClass) {
        if (StrKit.isBlank(driverClass)) {
            throw new IllegalArgumentException("driverClass can not be blank.");
        }
        this.driverClass = driverClass;
        return this;
    }

    public C3p0Plugin setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must more than 0.");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public C3p0Plugin setMinPoolSize(int minPoolSize) {
        if (minPoolSize < 1) {
            throw new IllegalArgumentException("minPoolSize must more than 0.");
        }
        this.minPoolSize = minPoolSize;
        return this;
    }

    public C3p0Plugin setInitialPoolSize(int initialPoolSize) {
        if (initialPoolSize < 1) {
            throw new IllegalArgumentException("initialPoolSize must more than 0.");
        }
        this.initialPoolSize = initialPoolSize;
        return this;
    }

    public C3p0Plugin setMaxIdleTime(int maxIdleTime) {
        if (maxIdleTime < 1) {
            throw new IllegalArgumentException("maxIdleTime must more than 0.");
        }
        this.maxIdleTime = maxIdleTime;
        return this;
    }

    public C3p0Plugin setAcquireIncrement(int acquireIncrement) {
        if (acquireIncrement < 1) {
            throw new IllegalArgumentException("acquireIncrement must more than 0.");
        }
        this.acquireIncrement = acquireIncrement;
        return this;
    }

    public C3p0Plugin(String jdbcUrl, String user, String password) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
    }

    public C3p0Plugin(String jdbcUrl, String user, String password, String driverClass) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
        this.driverClass = driverClass != null ? driverClass : this.driverClass;
    }

    public C3p0Plugin(String jdbcUrl, String user, String password, String driverClass, Integer maxPoolSize, Integer minPoolSize, Integer initialPoolSize, Integer maxIdleTime, Integer acquireIncrement) {
        this.initC3p0Properties(jdbcUrl, user, password, driverClass, maxPoolSize, minPoolSize, initialPoolSize, maxIdleTime, acquireIncrement);
    }

    private void initC3p0Properties(String jdbcUrl, String user, String password, String driverClass, Integer maxPoolSize, Integer minPoolSize, Integer initialPoolSize, Integer maxIdleTime, Integer acquireIncrement) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
        this.driverClass = driverClass != null ? driverClass : this.driverClass;
        this.maxPoolSize = maxPoolSize != null ? maxPoolSize : this.maxPoolSize;
        this.minPoolSize = minPoolSize != null ? minPoolSize : this.minPoolSize;
        this.initialPoolSize = initialPoolSize != null ? initialPoolSize : this.initialPoolSize;
        this.maxIdleTime = maxIdleTime != null ? maxIdleTime : this.maxIdleTime;
        this.acquireIncrement = acquireIncrement != null ? acquireIncrement : this.acquireIncrement;
    }

    public C3p0Plugin(File propertyfile) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propertyfile);
            Properties ps = new Properties();
            ps.load(fis);
            this.initC3p0Properties(ps.getProperty("jdbcUrl"), ps.getProperty("user"), ps.getProperty("password"), ps.getProperty("driverClass"), this.toInt(ps.getProperty("maxPoolSize")), this.toInt(ps.getProperty("minPoolSize")), this.toInt(ps.getProperty("initialPoolSize")), this.toInt(ps.getProperty("maxIdleTime")), this.toInt(ps.getProperty("acquireIncrement")));
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }

    public C3p0Plugin(Properties properties) {
        Properties ps = properties;
        this.initC3p0Properties(ps.getProperty("jdbcUrl"), ps.getProperty("user"), ps.getProperty("password"), ps.getProperty("driverClass"), this.toInt(ps.getProperty("maxPoolSize")), this.toInt(ps.getProperty("minPoolSize")), this.toInt(ps.getProperty("initialPoolSize")), this.toInt(ps.getProperty("maxIdleTime")), this.toInt(ps.getProperty("acquireIncrement")));
    }

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        this.dataSource = new ComboPooledDataSource();
        this.dataSource.setJdbcUrl(this.jdbcUrl);
        this.dataSource.setUser(this.user);
        this.dataSource.setPassword(this.password);
        try {
            this.dataSource.setDriverClass(this.driverClass);
        }
        catch (PropertyVetoException e) {
            this.dataSource = null;
            System.err.println("C3p0Plugin start error");
            throw new RuntimeException(e);
        }
        this.dataSource.setMaxPoolSize(this.maxPoolSize);
        this.dataSource.setMinPoolSize(this.minPoolSize);
        this.dataSource.setInitialPoolSize(this.initialPoolSize);
        this.dataSource.setMaxIdleTime(this.maxIdleTime);
        this.dataSource.setAcquireIncrement(this.acquireIncrement);
        this.isStarted = true;
        return true;
    }

    private Integer toInt(String str) {
        return Integer.parseInt(str);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ComboPooledDataSource getComboPooledDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean stop() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        this.dataSource = null;
        this.isStarted = false;
        return true;
    }
}

