/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

public class MappingKitGenerator {
    protected String packageTemplate = "package %s;%n%n";
    protected String importTemplate = "import com.jfinal.plugin.activerecord.ActiveRecordPlugin;%n%n";
    protected String classDefineTemplate = "/**%n * Generated by JFinal, do not modify this file.%n * <pre>%n * Example:%n * public void configPlugin(Plugins me) {%n *     ActiveRecordPlugin arp = new ActiveRecordPlugin(...);%n *     %s.mapping(arp);%n *     me.add(arp);%n * }%n * </pre>%n */%npublic class %s {%n%n";
    protected String mappingMethodDefineTemplate = "\tpublic static void mapping(ActiveRecordPlugin arp) {%n";
    protected String mappingMethodContentTemplate = "\t\tarp.addMapping(\"%s\", \"%s\", %s.class);%n";
    protected String compositeKeyTemplate = "\t\t// Composite Primary Key order: %s%n";
    protected String mappingKitPackageName;
    protected String mappingKitOutputDir;
    protected String mappingKitClassName = "_MappingKit";

    public MappingKitGenerator(String mappingKitPackageName, String mappingKitOutputDir) {
        this.mappingKitPackageName = mappingKitPackageName;
        this.mappingKitOutputDir = mappingKitOutputDir;
    }

    public void setMappingKitOutputDir(String mappingKitOutputDir) {
        if (StrKit.notBlank(mappingKitOutputDir)) {
            this.mappingKitOutputDir = mappingKitOutputDir;
        }
    }

    public void setMappingKitPackageName(String mappingKitPackageName) {
        if (StrKit.notBlank(mappingKitPackageName)) {
            this.mappingKitPackageName = mappingKitPackageName;
        }
    }

    public void setMappingKitClassName(String mappingKitClassName) {
        if (StrKit.notBlank(mappingKitClassName)) {
            this.mappingKitClassName = StrKit.firstCharToUpperCase(mappingKitClassName);
        }
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate MappingKit file ...");
        StringBuilder ret = new StringBuilder();
        this.genPackage(ret);
        this.genImport(ret);
        this.genClassDefine(ret);
        this.genMappingMethod(tableMetas, ret);
        ret.append(String.format("}%n%n", new Object[0]));
        this.wirtToFile(ret);
    }

    protected void genPackage(StringBuilder ret) {
        ret.append(String.format(this.packageTemplate, this.mappingKitPackageName));
    }

    protected void genImport(StringBuilder ret) {
        ret.append(String.format(this.importTemplate, new Object[0]));
    }

    protected void genClassDefine(StringBuilder ret) {
        ret.append(String.format(this.classDefineTemplate, this.mappingKitClassName, this.mappingKitClassName));
    }

    protected void genMappingMethod(List<TableMeta> tableMetas, StringBuilder ret) {
        ret.append(String.format(this.mappingMethodDefineTemplate, new Object[0]));
        for (TableMeta tableMeta : tableMetas) {
            boolean isCompositPrimaryKey = tableMeta.primaryKey.contains(",");
            if (isCompositPrimaryKey) {
                ret.append(String.format(this.compositeKeyTemplate, tableMeta.primaryKey));
            }
            String add = String.format(this.mappingMethodContentTemplate, tableMeta.name, tableMeta.primaryKey, tableMeta.modelName);
            ret.append(add);
        }
        ret.append(String.format("\t}%n", new Object[0]));
    }

    protected void wirtToFile(StringBuilder ret) {
        OutputStreamWriter fw = null;
        try {
            File dir = new File(this.mappingKitOutputDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String target = this.mappingKitOutputDir + File.separator + this.mappingKitClassName + ".java";
            fw = new FileWriter(target);
            fw.write(ret.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }
}

