/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.ModelBuilder;
import com.jfinal.plugin.activerecord.Record;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RecordBuilder {
    public static final List<Record> build(Config config, ResultSet rs) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        RecordBuilder.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Record record = new Record();
            record.setColumnsMap(config.containerFactory.getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                columns.put(labelNames[i], value);
            }
            result.add(record);
        }
        return result;
    }

    private static final void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }
}

