/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.ModelBuilder;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import com.jfinal.plugin.activerecord.cache.ICache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Model<M extends Model>
implements Serializable {
    private static final long serialVersionUID = -990334519496260591L;
    private Map<String, Object> attrs = this.getAttrsMap();
    private Set<String> modifyFlag;
    private String configName = null;

    private Map<String, Object> getAttrsMap() {
        Config config = this.getConfig();
        if (config == null) {
            return DbKit.brokenConfig.containerFactory.getAttrsMap();
        }
        return config.containerFactory.getAttrsMap();
    }

    Set<String> getModifyFlag() {
        if (this.modifyFlag == null) {
            Config config = this.getConfig();
            this.modifyFlag = config == null ? DbKit.brokenConfig.containerFactory.getModifyFlagSet() : config.containerFactory.getModifyFlagSet();
        }
        return this.modifyFlag;
    }

    public M use(String configName) {
        this.configName = configName;
        return (M)this;
    }

    private Config getConfig() {
        if (this.configName != null) {
            return DbKit.getConfig(this.configName);
        }
        return DbKit.getConfig(this.getUsefulClass());
    }

    private Table getTable() {
        return TableMapping.me().getTable(this.getUsefulClass());
    }

    public M set(String attr, Object value) {
        Table table = this.getTable();
        if (table == null) {
            this.attrs.put(attr, value);
            this.getModifyFlag().add(attr);
            return (M)this;
        }
        if (table.hasColumnLabel(attr)) {
            this.attrs.put(attr, value);
            this.getModifyFlag().add(attr);
            return (M)this;
        }
        throw new ActiveRecordException("The attribute name does not exist: " + attr);
    }

    public M put(String key, Object value) {
        this.attrs.put(key, value);
        return (M)this;
    }

    public M put(Map<String, Object> map) {
        this.attrs.putAll(map);
        return (M)this;
    }

    public M put(Model model) {
        this.attrs.putAll(model.getAttrs());
        return (M)this;
    }

    public M put(Record record) {
        this.attrs.putAll(record.getColumns());
        return (M)this;
    }

    public Record toRecord() {
        return new Record().setColumns(this.getAttrs());
    }

    public <T> T get(String attr) {
        return (T)this.attrs.get(attr);
    }

    public <T> T get(String attr, Object defaultValue) {
        Object result = this.attrs.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        return (String)this.attrs.get(attr);
    }

    public Integer getInt(String attr) {
        return (Integer)this.attrs.get(attr);
    }

    public Long getLong(String attr) {
        return (Long)this.attrs.get(attr);
    }

    public BigInteger getBigInteger(String attr) {
        return (BigInteger)this.attrs.get(attr);
    }

    public Date getDate(String attr) {
        return (Date)this.attrs.get(attr);
    }

    public Time getTime(String attr) {
        return (Time)this.attrs.get(attr);
    }

    public Timestamp getTimestamp(String attr) {
        return (Timestamp)this.attrs.get(attr);
    }

    public Double getDouble(String attr) {
        return (Double)this.attrs.get(attr);
    }

    public Float getFloat(String attr) {
        return (Float)this.attrs.get(attr);
    }

    public Boolean getBoolean(String attr) {
        return (Boolean)this.attrs.get(attr);
    }

    public BigDecimal getBigDecimal(String attr) {
        return (BigDecimal)this.attrs.get(attr);
    }

    public byte[] getBytes(String attr) {
        return (byte[])this.attrs.get(attr);
    }

    public Number getNumber(String attr) {
        return (Number)this.attrs.get(attr);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String sql, Object ... paras) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            Page<M> page = this.paginate(config, conn, pageNumber, pageSize, sql, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public Page<M> paginate(int pageNumber, int pageSize, String[] selectAndSqlExceptSelect, Object ... paras) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            String totalRowSql = "select count(*) " + config.dialect.replaceOrderBy(selectAndSqlExceptSelect[1]);
            String sql = selectAndSqlExceptSelect[0] + " " + selectAndSqlExceptSelect[1];
            conn = config.getConnection();
            Page<M> page = this.doPaginate(config, conn, pageNumber, pageSize, totalRowSql, sql, paras);
            config.close(conn);
            return page;
        }
        catch (Exception e) {
            try {
                throw new ActiveRecordException(e);
            }
            catch (Throwable throwable) {
                config.close(conn);
                throw throwable;
            }
        }
    }

    private Page<M> paginate(Config config, Connection conn, int pageNumber, int pageSize, String sql, Object ... paras) throws Exception {
        Object[] actualSqlParas = new Object[2];
        String totalRowSql = config.dialect.forTotalRow(actualSqlParas, sql, paras);
        sql = (String)actualSqlParas[0];
        paras = (Object[])actualSqlParas[1];
        return this.doPaginate(config, conn, pageNumber, pageSize, totalRowSql, sql, paras);
    }

    private Page<M> doPaginate(Config config, Connection conn, int pageNumber, int pageSize, String totalRowSql, String sql, Object ... paras) throws Exception {
        long totalRow;
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must be more than 0");
        }
        if (config.dialect.isTakeOverModelPaginate()) {
            return config.dialect.takeOverModelPaginate(conn, this.getUsefulClass(), pageNumber, pageSize, totalRowSql, sql, paras);
        }
        List result = Db.query(config, conn, totalRowSql, paras);
        if (config.dialect.isGroupBySql(sql)) {
            totalRow = result.size();
        } else {
            long l = totalRow = result.size() > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        sql = config.dialect.forPaginate(pageNumber, pageSize, sql);
        List<M> list = this.find(conn, sql, paras);
        return new Page<M>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String sql) {
        return this.paginate(pageNumber, pageSize, sql, DbKit.NULL_PARA_ARRAY);
    }

    protected Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public Set<Map.Entry<String, Object>> _getAttrsEntrySet() {
        return this.attrs.entrySet();
    }

    public boolean save() {
        Config config = this.getConfig();
        Table table = this.getTable();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forModelSave(table, this.attrs, sql, paras);
        Connection conn = null;
        PreparedStatement pst = null;
        int result = 0;
        try {
            conn = config.getConnection();
            pst = config.dialect.isOracle() ? conn.prepareStatement(sql.toString(), table.getPrimaryKey()) : conn.prepareStatement(sql.toString(), 1);
            config.dialect.fillStatement(pst, paras);
            result = pst.executeUpdate();
            this.getGeneratedKey(pst, table, config);
            this.getModifyFlag().clear();
            boolean bl = result >= 1;
            config.close(pst, conn);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new ActiveRecordException(e);
            }
            catch (Throwable throwable) {
                config.close(pst, conn);
                throw throwable;
            }
        }
    }

    private void getGeneratedKey(PreparedStatement pst, Table table, Config config) throws SQLException {
        String[] pKeys = table.getPrimaryKey();
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            if (this.get(pKey) != null && !config.dialect.isOracle() || !rs.next()) continue;
            Class<?> colType = table.getColumnType(pKey);
            if (colType == Integer.class || colType == Integer.TYPE) {
                this.set(pKey, rs.getInt(1));
                continue;
            }
            if (colType == Long.class || colType == Long.TYPE) {
                this.set(pKey, rs.getLong(1));
                continue;
            }
            this.set(pKey, rs.getObject(1));
        }
        rs.close();
    }

    public boolean delete() {
        Table table = this.getTable();
        String[] pKeys = table.getPrimaryKey();
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = this.attrs.get(pKeys[i]);
            if (ids[i] != null) continue;
            throw new ActiveRecordException("You can't delete model without primary key value, " + pKeys[i] + " is null");
        }
        return this.deleteById(table, ids);
    }

    public boolean deleteById(Object idValue) {
        if (idValue == null) {
            throw new IllegalArgumentException("idValue can not be null");
        }
        return this.deleteById(this.getTable(), idValue);
    }

    public boolean deleteById(Object ... idValues) {
        Table table = this.getTable();
        if (idValues == null || idValues.length != table.getPrimaryKey().length) {
            throw new IllegalArgumentException("Primary key nubmer must equals id value number and can not be null");
        }
        return this.deleteById(table, idValues);
    }

    private boolean deleteById(Table table, Object ... idValues) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            String sql = config.dialect.forModelDeleteById(table);
            boolean bl = Db.update(config, conn, sql, idValues) >= 1;
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public boolean update() {
        String[] pKeys;
        if (this.getModifyFlag().isEmpty()) {
            return false;
        }
        Table table = this.getTable();
        for (String pKey : pKeys = table.getPrimaryKey()) {
            Object id = this.attrs.get(pKey);
            if (id != null) continue;
            throw new ActiveRecordException("You can't update model without Primary Key, " + pKey + " can not be null.");
        }
        Config config = this.getConfig();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forModelUpdate(table, this.attrs, this.getModifyFlag(), sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        Connection conn = null;
        try {
            conn = config.getConnection();
            int result = Db.update(config, conn, sql.toString(), paras.toArray());
            if (result >= 1) {
                this.getModifyFlag().clear();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private List<M> find(Connection conn, String sql, Object ... paras) throws Exception {
        Config config = this.getConfig();
        Class<Model> modelClass = this.getUsefulClass();
        if (config.devMode) {
            this.checkTableName(modelClass, sql);
        }
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        List result = ModelBuilder.build(rs, modelClass);
        DbKit.close(rs, pst);
        return result;
    }

    public List<M> find(String sql, Object ... paras) {
        Config config = this.getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            List<M> list = this.find(conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private void checkTableName(Class<? extends Model> modelClass, String sql) {
        Table table = TableMapping.me().getTable(modelClass);
        if (!sql.toLowerCase().contains(table.getName().toLowerCase())) {
            throw new ActiveRecordException("The table name: " + table.getName() + " not in your sql.");
        }
    }

    public List<M> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findFirst(String sql, Object ... paras) {
        List<M> result = this.find(sql, paras);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findFirst(String sql) {
        return this.findFirst(sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findById(Object idValue) {
        return this.findByIdLoadColumns(new Object[]{idValue}, "*");
    }

    public M findById(Object ... idValues) {
        return this.findByIdLoadColumns(idValues, "*");
    }

    public M findByIdLoadColumns(Object idValue, String columns) {
        return this.findByIdLoadColumns(new Object[]{idValue}, columns);
    }

    public M findByIdLoadColumns(Object[] idValues, String columns) {
        Table table = this.getTable();
        if (table.getPrimaryKey().length != idValues.length) {
            throw new IllegalArgumentException("id values error, need " + table.getPrimaryKey().length + " id value");
        }
        String sql = this.getConfig().dialect.forModelFindById(table, columns);
        List<M> result = this.find(sql, idValues);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M _setAttrs(M model) {
        return this._setAttrs(((Model)model).getAttrs());
    }

    public M _setAttrs(Map<String, Object> attrs) {
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return (M)this;
    }

    public M remove(String attr) {
        this.attrs.remove(attr);
        this.getModifyFlag().remove(attr);
        return (M)this;
    }

    public M remove(String ... attrs) {
        if (attrs != null) {
            for (String a : attrs) {
                this.attrs.remove(a);
                this.getModifyFlag().remove(a);
            }
        }
        return (M)this;
    }

    public M removeNullValueAttrs() {
        Iterator<Map.Entry<String, Object>> it = this.attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
            this.getModifyFlag().remove(e.getKey());
        }
        return (M)this;
    }

    public M keep(String ... attrs) {
        if (attrs != null && attrs.length > 0) {
            Config config = this.getConfig();
            Map newAttrs = config.containerFactory.getAttrsMap();
            Set newModifyFlag = config.containerFactory.getModifyFlagSet();
            for (String a : attrs) {
                if (this.attrs.containsKey(a)) {
                    newAttrs.put(a, this.attrs.get(a));
                }
                if (!this.getModifyFlag().contains(a)) continue;
                newModifyFlag.add(a);
            }
            this.attrs = newAttrs;
            this.modifyFlag = newModifyFlag;
        } else {
            this.attrs.clear();
            this.getModifyFlag().clear();
        }
        return (M)this;
    }

    public M keep(String attr) {
        if (this.attrs.containsKey(attr)) {
            Object keepIt = this.attrs.get(attr);
            boolean keepFlag = this.getModifyFlag().contains(attr);
            this.attrs.clear();
            this.getModifyFlag().clear();
            this.attrs.put(attr, keepIt);
            if (keepFlag) {
                this.getModifyFlag().add(attr);
            }
        } else {
            this.attrs.clear();
            this.getModifyFlag().clear();
        }
        return (M)this;
    }

    public M clear() {
        this.attrs.clear();
        this.getModifyFlag().clear();
        return (M)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" {");
        boolean first = true;
        for (Map.Entry<String, Object> e : this.attrs.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(":").append(value);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        if (this.getUsefulClass() != ((Model)o).getUsefulClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.attrs.equals(((Model)o).attrs);
    }

    public int hashCode() {
        return (this.attrs == null ? 0 : this.attrs.hashCode()) ^ (this.getModifyFlag() == null ? 0 : this.getModifyFlag().hashCode());
    }

    public List<M> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.getConfig().getCache();
        List<M> result = (List<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<M> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.getConfig().getCache();
        Model<M> result = (Model)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, result);
        }
        return (M)result;
    }

    public M findFirstByCache(String cacheName, Object key, String sql) {
        return this.findFirstByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String sql, Object ... paras) {
        ICache cache = this.getConfig().getCache();
        Page<M> result = (Page<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.paginate(pageNumber, pageSize, sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String[] selectAndSqlExceptSelect, Object ... paras) {
        ICache cache = this.getConfig().getCache();
        Page<M> result = (Page<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.paginate(pageNumber, pageSize, selectAndSqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String sql) {
        return this.paginateByCache(cacheName, key, pageNumber, pageSize, sql, DbKit.NULL_PARA_ARRAY);
    }

    public String[] _getAttrNames() {
        Set<String> attrNameSet = this.attrs.keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] _getAttrValues() {
        Collection<Object> attrValueCollection = this.attrs.values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public String toJson() {
        return JsonKit.toJson(this.attrs);
    }

    private Class<? extends Model> getUsefulClass() {
        Class<?> c = this.getClass();
        return c.getName().indexOf("EnhancerByCGLIB") == -1 ? c : c.getSuperclass();
    }
}

