/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.ICallback;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.RecordBuilder;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import com.jfinal.plugin.activerecord.cache.ICache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbPro {
    private final Config config;
    private static final Map<String, DbPro> map = new HashMap<String, DbPro>();

    public DbPro() {
        if (DbKit.config == null) {
            throw new RuntimeException("The main config is null, initialize ActiveRecordPlugin first");
        }
        this.config = DbKit.config;
    }

    public DbPro(String configName) {
        this.config = DbKit.getConfig(configName);
        if (this.config == null) {
            throw new IllegalArgumentException("Config not found by configName: " + configName);
        }
    }

    public static DbPro use(String configName) {
        DbPro result = map.get(configName);
        if (result == null) {
            result = new DbPro(configName);
            map.put(configName, result);
        }
        return result;
    }

    public static DbPro use() {
        return DbPro.use(DbKit.config.name);
    }

    <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        int colAmount = rs.getMetaData().getColumnCount();
        if (colAmount > 1) {
            while (rs.next()) {
                Object[] temp = new Object[colAmount];
                for (int i = 0; i < colAmount; ++i) {
                    temp[i] = rs.getObject(i + 1);
                }
                result.add(temp);
            }
        } else if (colAmount == 1) {
            while (rs.next()) {
                result.add(rs.getObject(1));
            }
        }
        DbKit.close(rs, pst);
        return result;
    }

    public <T> List<T> query(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<T> list = this.query(this.config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public <T> List<T> query(String sql) {
        return this.query(sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> T queryFirst(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryFirst(String sql) {
        List<T> result = this.query(sql, DbKit.NULL_PARA_ARRAY);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryColumn(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        if (result.size() > 0) {
            T temp = result.get(0);
            if (temp instanceof Object[]) {
                throw new ActiveRecordException("Only ONE COLUMN can be queried.");
            }
            return temp;
        }
        return null;
    }

    public <T> T queryColumn(String sql) {
        return this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public String queryStr(String sql, Object ... paras) {
        return (String)this.queryColumn(sql, paras);
    }

    public String queryStr(String sql) {
        return (String)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Integer queryInt(String sql, Object ... paras) {
        return (Integer)this.queryColumn(sql, paras);
    }

    public Integer queryInt(String sql) {
        return (Integer)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Long queryLong(String sql, Object ... paras) {
        return (Long)this.queryColumn(sql, paras);
    }

    public Long queryLong(String sql) {
        return (Long)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Double queryDouble(String sql, Object ... paras) {
        return (Double)this.queryColumn(sql, paras);
    }

    public Double queryDouble(String sql) {
        return (Double)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Float queryFloat(String sql, Object ... paras) {
        return (Float)this.queryColumn(sql, paras);
    }

    public Float queryFloat(String sql) {
        return (Float)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public BigDecimal queryBigDecimal(String sql, Object ... paras) {
        return (BigDecimal)this.queryColumn(sql, paras);
    }

    public BigDecimal queryBigDecimal(String sql) {
        return (BigDecimal)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public byte[] queryBytes(String sql, Object ... paras) {
        return (byte[])this.queryColumn(sql, paras);
    }

    public byte[] queryBytes(String sql) {
        return (byte[])this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public java.util.Date queryDate(String sql, Object ... paras) {
        return (java.util.Date)this.queryColumn(sql, paras);
    }

    public java.util.Date queryDate(String sql) {
        return (java.util.Date)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Time queryTime(String sql, Object ... paras) {
        return (Time)this.queryColumn(sql, paras);
    }

    public Time queryTime(String sql) {
        return (Time)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Timestamp queryTimestamp(String sql, Object ... paras) {
        return (Timestamp)this.queryColumn(sql, paras);
    }

    public Timestamp queryTimestamp(String sql) {
        return (Timestamp)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Boolean queryBoolean(String sql, Object ... paras) {
        return (Boolean)this.queryColumn(sql, paras);
    }

    public Boolean queryBoolean(String sql) {
        return (Boolean)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Number queryNumber(String sql, Object ... paras) {
        return (Number)this.queryColumn(sql, paras);
    }

    public Number queryNumber(String sql) {
        return (Number)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    int update(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        int result = pst.executeUpdate();
        DbKit.close(pst);
        return result;
    }

    public int update(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            int n = this.update(this.config, conn, sql, paras);
            return n;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public int update(String sql) {
        return this.update(sql, DbKit.NULL_PARA_ARRAY);
    }

    List<Record> find(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        List<Record> result = RecordBuilder.build(config, rs);
        DbKit.close(rs, pst);
        return result;
    }

    public List<Record> find(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Record> list = this.find(this.config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public List<Record> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findFirst(String sql, Object ... paras) {
        List<Record> result = this.find(sql, paras);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Record findFirst(String sql) {
        return this.findFirst(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findById(String tableName, Object idValue) {
        return this.findById(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public Record findById(String tableName, String primaryKey, Object ... idValue) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValue.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbFindById(tableName, pKeys);
        List<Record> result = this.find(sql, idValue);
        return result.size() > 0 ? result.get(0) : null;
    }

    public boolean deleteById(String tableName, Object idValue) {
        return this.deleteById(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public boolean deleteById(String tableName, String primaryKey, Object ... idValue) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValue.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbDeleteById(tableName, pKeys);
        return this.update(sql, idValue) >= 1;
    }

    public boolean delete(String tableName, String primaryKey, Record record) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length <= 1) {
            return this.deleteById(tableName, primaryKey, record.get(primaryKey));
        }
        this.config.dialect.trimPrimaryKeys(pKeys);
        Object[] idValue = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            idValue[i] = record.get(pKeys[i]);
            if (idValue[i] != null) continue;
            throw new IllegalArgumentException("The value of primary key \"" + pKeys[i] + "\" can not be null in record object");
        }
        return this.deleteById(tableName, primaryKey, idValue);
    }

    public boolean delete(String tableName, Record record) {
        String defaultPrimaryKey = this.config.dialect.getDefaultPrimaryKey();
        return this.deleteById(tableName, defaultPrimaryKey, record.get(defaultPrimaryKey));
    }

    Page<Record> paginate(Config config, Connection conn, int pageNumber, int pageSize, String sql, Object ... paras) throws SQLException {
        Object[] actualSqlParas = new Object[2];
        String totalRowSql = config.dialect.forTotalRow(actualSqlParas, sql, paras);
        sql = (String)actualSqlParas[0];
        paras = (Object[])actualSqlParas[1];
        return this.doPaginate(config, conn, pageNumber, pageSize, totalRowSql, sql, paras);
    }

    Page<Record> doPaginate(Config config, Connection conn, int pageNumber, int pageSize, String totalRowSql, String sql, Object ... paras) throws SQLException {
        long totalRow;
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must be more than 0");
        }
        if (config.dialect.isTakeOverDbPaginate()) {
            return config.dialect.takeOverDbPaginate(conn, pageNumber, pageSize, totalRowSql, sql, paras);
        }
        List result = this.query(config, conn, totalRowSql, paras);
        if (config.dialect.isGroupBySql(sql)) {
            totalRow = result.size();
        } else {
            long l = totalRow = result.size() > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page<Record>(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page<Record>(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        sql = config.dialect.forPaginate(pageNumber, pageSize, sql);
        List<Record> list = this.find(config, conn, sql, paras);
        return new Page<Record>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            Page<Record> page = this.paginate(this.config, conn, pageNumber, pageSize, sql, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String[] selectAndSqlExceptSelect, Object ... paras) {
        Connection conn = null;
        try {
            String totalRowSql = "select count(*) " + this.config.dialect.replaceOrderBy(selectAndSqlExceptSelect[1]);
            String sql = selectAndSqlExceptSelect[0] + " " + selectAndSqlExceptSelect[1];
            conn = this.config.getConnection();
            Page<Record> page = this.doPaginate(this.config, conn, pageNumber, pageSize, totalRowSql, sql, paras);
            this.config.close(conn);
            return page;
        }
        catch (Exception e) {
            try {
                throw new ActiveRecordException(e);
            }
            catch (Throwable throwable) {
                this.config.close(conn);
                throw throwable;
            }
        }
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String sql) {
        return this.paginate(pageNumber, pageSize, sql, DbKit.NULL_PARA_ARRAY);
    }

    boolean save(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        String[] pKeys = primaryKey.split(",");
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        config.dialect.forDbSave(tableName, pKeys, record, sql, paras);
        PreparedStatement pst = config.dialect.isOracle() ? conn.prepareStatement(sql.toString(), pKeys) : conn.prepareStatement(sql.toString(), 1);
        config.dialect.fillStatement(pst, paras);
        int result = pst.executeUpdate();
        this.getGeneratedKey(pst, record, pKeys);
        DbKit.close(pst);
        return result >= 1;
    }

    private void getGeneratedKey(PreparedStatement pst, Record record, String[] pKeys) throws SQLException {
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            if (record.get(pKey) != null && !this.config.dialect.isOracle() || !rs.next()) continue;
            record.set(pKey, rs.getObject(1));
        }
        rs.close();
    }

    public boolean save(String tableName, String primaryKey, Record record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.save(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean save(String tableName, Record record) {
        return this.save(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    boolean update(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        String[] pKeys = primaryKey.split(",");
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = record.get(pKeys[i].trim());
            if (ids[i] != null) continue;
            throw new ActiveRecordException("You can't update record without Primary Key, " + pKeys[i] + " can not be null.");
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forDbUpdate(tableName, pKeys, ids, record, sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        return this.update(config, conn, sql.toString(), paras.toArray()) >= 1;
    }

    public boolean update(String tableName, String primaryKey, Record record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.update(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean update(String tableName, Record record) {
        return this.update(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    public Object execute(ICallback callback) {
        return this.execute(this.config, callback);
    }

    Object execute(Config config, ICallback callback) {
        Connection conn = null;
        try {
            conn = config.getConnection();
            Object object = callback.call(conn);
            return object;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tx(Config config, int transactionLevel, IAtom atom) {
        Connection conn = config.getThreadLocalConnection();
        if (conn != null) {
            try {
                boolean result;
                if (conn.getTransactionIsolation() < transactionLevel) {
                    conn.setTransactionIsolation(transactionLevel);
                }
                if (!(result = atom.run())) throw new NestedTransactionHelpException("Notice the outer transaction that the nested transaction return false");
                return true;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(transactionLevel);
            conn.setAutoCommit(false);
            boolean result = atom.run();
            if (result) {
                conn.commit();
            } else {
                conn.rollback();
            }
            boolean bl = result;
            return bl;
        }
        catch (NestedTransactionHelpException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    LogKit.error(e1.getMessage(), e1);
                }
            }
            LogKit.logNothing(e);
            boolean e1 = false;
            return e1;
        }
        catch (Throwable t) {
            RuntimeException runtimeException;
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    LogKit.error(e1.getMessage(), e1);
                }
            }
            if (t instanceof RuntimeException) {
                runtimeException = (RuntimeException)t;
                throw runtimeException;
            }
            runtimeException = new ActiveRecordException(t);
            throw runtimeException;
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                LogKit.error(t.getMessage(), t);
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }

    public boolean tx(int transactionLevel, IAtom atom) {
        return this.tx(this.config, transactionLevel, atom);
    }

    public boolean tx(IAtom atom) {
        return this.tx(this.config, this.config.getTransactionLevel(), atom);
    }

    public List<Record> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.config.getCache();
        List<Record> result = (List<Record>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<Record> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        ICache cache = this.config.getCache();
        Record result = (Record)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Record findFirstByCache(String cacheName, Object key, String sql) {
        return this.findFirstByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String sql, Object ... paras) {
        ICache cache = this.config.getCache();
        Page<Record> result = (Page<Record>)cache.get(cacheName, key);
        if (result == null) {
            result = this.paginate(pageNumber, pageSize, sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String[] selectAndSqlExceptSelect, Object ... paras) {
        ICache cache = this.config.getCache();
        Page<Record> result = (Page<Record>)cache.get(cacheName, key);
        if (result == null) {
            result = this.paginate(pageNumber, pageSize, selectAndSqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String sql) {
        return this.paginateByCache(cacheName, key, pageNumber, pageSize, sql, DbKit.NULL_PARA_ARRAY);
    }

    private int[] batch(Config config, Connection conn, String sql, Object[][] paras, int batchSize) throws SQLException {
        if (paras == null || paras.length == 0) {
            return new int[0];
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int[] result = new int[paras.length];
        PreparedStatement pst = conn.prepareStatement(sql);
        for (int i = 0; i < paras.length; ++i) {
            for (int j = 0; j < paras[i].length; ++j) {
                Object value = paras[i][j];
                if (config.dialect.isOracle()) {
                    if (value instanceof Date) {
                        pst.setDate(j + 1, (Date)value);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        pst.setTimestamp(j + 1, (Timestamp)value);
                        continue;
                    }
                    pst.setObject(j + 1, value);
                    continue;
                }
                pst.setObject(j + 1, value);
            }
            pst.addBatch();
            if (++counter < batchSize) continue;
            counter = 0;
            int[] r = pst.executeBatch();
            if (!isInTransaction) {
                conn.commit();
            }
            for (int k = 0; k < r.length; ++k) {
                result[pointer++] = r[k];
            }
        }
        int[] r = pst.executeBatch();
        if (!isInTransaction) {
            conn.commit();
        }
        for (int k = 0; k < r.length; ++k) {
            result[pointer++] = r[k];
        }
        DbKit.close(pst);
        return result;
    }

    public int[] batch(String sql, Object[][] paras, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, paras, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
            this.config.close(conn);
        }
    }

    private int[] batch(Config config, Connection conn, String sql, String columns, List list, int batchSize) throws SQLException {
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        Object element = list.get(0);
        if (!(element instanceof Record) && !(element instanceof Model)) {
            throw new IllegalArgumentException("The element in list must be Model or Record.");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isModel = element instanceof Model;
        String[] columnArray = columns.split(",");
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = columnArray[i].trim();
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int size = list.size();
        int[] result = new int[size];
        PreparedStatement pst = conn.prepareStatement(sql);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = isModel ? ((Model)list.get(i)).getAttrs() : ((Record)list.get(i)).getColumns();
            for (int j = 0; j < columnArray.length; ++j) {
                Object value = map.get(columnArray[j]);
                if (config.dialect.isOracle()) {
                    if (value instanceof Date) {
                        pst.setDate(j + 1, (Date)value);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        pst.setTimestamp(j + 1, (Timestamp)value);
                        continue;
                    }
                    pst.setObject(j + 1, value);
                    continue;
                }
                pst.setObject(j + 1, value);
            }
            pst.addBatch();
            if (++counter < batchSize) continue;
            counter = 0;
            int[] r = pst.executeBatch();
            if (!isInTransaction) {
                conn.commit();
            }
            for (int k = 0; k < r.length; ++k) {
                result[pointer++] = r[k];
            }
        }
        int[] r = pst.executeBatch();
        if (!isInTransaction) {
            conn.commit();
        }
        for (int k = 0; k < r.length; ++k) {
            result[pointer++] = r[k];
        }
        DbKit.close(pst);
        return result;
    }

    public int[] batch(String sql, String columns, List modelOrRecordList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, columns, modelOrRecordList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
            this.config.close(conn);
        }
    }

    private int[] batch(Config config, Connection conn, List<String> sqlList, int batchSize) throws SQLException {
        if (sqlList == null || sqlList.size() == 0) {
            return new int[0];
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int size = sqlList.size();
        int[] result = new int[size];
        Statement st = conn.createStatement();
        for (int i = 0; i < size; ++i) {
            st.addBatch(sqlList.get(i));
            if (++counter < batchSize) continue;
            counter = 0;
            int[] r = st.executeBatch();
            if (!isInTransaction) {
                conn.commit();
            }
            for (int k = 0; k < r.length; ++k) {
                result[pointer++] = r[k];
            }
        }
        int[] r = st.executeBatch();
        if (!isInTransaction) {
            conn.commit();
        }
        for (int k = 0; k < r.length; ++k) {
            result[pointer++] = r[k];
        }
        DbKit.close(st);
        return result;
    }

    public int[] batch(List<String> sqlList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sqlList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
            this.config.close(conn);
        }
    }

    public int[] batchSave(List<? extends Model> modelList, int batchSize) {
        if (modelList == null || modelList.size() == 0) {
            return new int[0];
        }
        Model model = modelList.get(0);
        Map<String, Object> attrs = model.getAttrs();
        String[] attrNames = new String[attrs.entrySet().size()];
        int index = 0;
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            attrNames[index++] = e.getKey();
        }
        String columns = StrKit.join(attrNames, ",");
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forModelSave(TableMapping.me().getTable(model.getClass()), attrs, sql, parasNoUse);
        return this.batch(sql.toString(), columns, modelList, batchSize);
    }

    public int[] batchSave(String tableName, List<Record> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        Record record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        String[] colNames = new String[cols.entrySet().size()];
        int index = 0;
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            colNames[index++] = e.getKey();
        }
        String columns = StrKit.join(colNames, ",");
        String[] pKeysNoUse = new String[]{};
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbSave(tableName, pKeysNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns, recordList, batchSize);
    }

    public int[] batchUpdate(List<? extends Model> modelList, int batchSize) {
        if (modelList == null || modelList.size() == 0) {
            return new int[0];
        }
        Model model = modelList.get(0);
        Table table = TableMapping.me().getTable(model.getClass());
        String[] pKeys = table.getPrimaryKey();
        Map<String, Object> attrs = model.getAttrs();
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String attr = e.getKey();
            if (this.config.dialect.isPrimaryKey(attr, pKeys)) continue;
            attrNames.add(attr);
        }
        for (String pKey : pKeys) {
            attrNames.add(pKey);
        }
        String columns = StrKit.join(attrNames.toArray(new String[attrNames.size()]), ",");
        Set<String> modifyFlag = attrs.keySet();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forModelUpdate(TableMapping.me().getTable(model.getClass()), attrs, modifyFlag, sql, parasNoUse);
        return this.batch(sql.toString(), columns, modelList, batchSize);
    }

    public int[] batchUpdate(String tableName, String primaryKey, List<Record> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        String[] pKeys = primaryKey.split(",");
        this.config.dialect.trimPrimaryKeys(pKeys);
        Record record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        ArrayList<String> colNames = new ArrayList<String>();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            String col = e.getKey();
            if (this.config.dialect.isPrimaryKey(col, pKeys)) continue;
            colNames.add(col);
        }
        for (String pKey : pKeys) {
            colNames.add(pKey);
        }
        String columns = StrKit.join(colNames.toArray(new String[colNames.size()]), ",");
        Object[] idsNoUse = new Object[pKeys.length];
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbUpdate(tableName, pKeys, idsNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns, recordList, batchSize);
    }

    public int[] batchUpdate(String tableName, List<Record> recordList, int batchSize) {
        return this.batchUpdate(tableName, this.config.dialect.getDefaultPrimaryKey(), recordList, batchSize);
    }

    static void removeDbProWithConfig(String configName) {
        map.remove(configName);
    }
}

