/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Enhancer;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionException;
import com.jfinal.core.ActionRender;
import com.jfinal.core.Config;
import com.jfinal.core.Injector;
import com.jfinal.core.TypeConverter;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.render.CaptchaRender;
import com.jfinal.render.ContentType;
import com.jfinal.render.JsonRender;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import com.jfinal.token.TokenManager;
import com.jfinal.upload.MultipartRequest;
import com.jfinal.upload.UploadFile;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class Controller {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String urlPara;
    private String[] urlParaArray;
    private static final String[] NULL_URL_PARA_ARRAY = new String[0];
    private static final String URL_PARA_SEPARATOR = Config.getConstants().getUrlParaSeparator();
    private static final RenderFactory renderFactory = RenderFactory.me();
    private Render render;

    void init(HttpServletRequest request, HttpServletResponse response, String urlPara) {
        this.request = request;
        this.response = response;
        this.urlPara = urlPara;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setUrlPara(String urlPara) {
        this.urlPara = urlPara;
        this.urlParaArray = null;
    }

    public Controller setAttr(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public Controller removeAttr(String name) {
        this.request.removeAttribute(name);
        return this;
    }

    public Controller setAttrs(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            this.request.setAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String getPara(String name) {
        return this.request.getParameter(name);
    }

    public String getPara(String name, String defaultValue) {
        String result = this.request.getParameter(name);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public Map<String, String[]> getParaMap() {
        return this.request.getParameterMap();
    }

    public Enumeration<String> getParaNames() {
        return this.request.getParameterNames();
    }

    public String[] getParaValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Integer[] getParaValuesToInt(String name) {
        String[] values = this.request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public Long[] getParaValuesToLong(String name) {
        String[] values = this.request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        Long[] result = new Long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.parseLong(values[i]);
        }
        return result;
    }

    public Enumeration<String> getAttrNames() {
        return this.request.getAttributeNames();
    }

    public <T> T getAttr(String name) {
        return (T)this.request.getAttribute(name);
    }

    public String getAttrForStr(String name) {
        return (String)this.request.getAttribute(name);
    }

    public Integer getAttrForInt(String name) {
        return (Integer)this.request.getAttribute(name);
    }

    private Integer toInt(String value, Integer defaultValue) {
        try {
            if (value == null || "".equals(value.trim())) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return -Integer.parseInt(value.substring(1));
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ActionException(404, renderFactory.getErrorRender(404), "Can not parse the parameter \"" + value + "\" to Integer value.");
        }
    }

    public Integer getParaToInt(String name) {
        return this.toInt(this.request.getParameter(name), null);
    }

    public Integer getParaToInt(String name, Integer defaultValue) {
        return this.toInt(this.request.getParameter(name), defaultValue);
    }

    private Long toLong(String value, Long defaultValue) {
        try {
            if (value == null || "".equals(value.trim())) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return -Long.parseLong(value.substring(1));
            }
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new ActionException(404, renderFactory.getErrorRender(404), "Can not parse the parameter \"" + value + "\" to Long value.");
        }
    }

    public Long getParaToLong(String name) {
        return this.toLong(this.request.getParameter(name), null);
    }

    public Long getParaToLong(String name, Long defaultValue) {
        return this.toLong(this.request.getParameter(name), defaultValue);
    }

    private Boolean toBoolean(String value, Boolean defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        if ("1".equals(value = value.trim().toLowerCase()) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new ActionException(404, renderFactory.getErrorRender(404), "Can not parse the parameter \"" + value + "\" to Boolean value.");
    }

    public Boolean getParaToBoolean(String name) {
        return this.toBoolean(this.request.getParameter(name), null);
    }

    public Boolean getParaToBoolean(String name, Boolean defaultValue) {
        return this.toBoolean(this.request.getParameter(name), defaultValue);
    }

    public Boolean getParaToBoolean() {
        return this.toBoolean(this.getPara(), null);
    }

    public Boolean getParaToBoolean(int index) {
        return this.toBoolean(this.getPara(index), null);
    }

    public Boolean getParaToBoolean(int index, Boolean defaultValue) {
        return this.toBoolean(this.getPara(index), defaultValue);
    }

    private Date toDate(String value, Date defaultValue) {
        try {
            if (value == null || "".equals(value.trim())) {
                return defaultValue;
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(value.trim());
        }
        catch (Exception e) {
            throw new ActionException(404, renderFactory.getErrorRender(404), "Can not parse the parameter \"" + value + "\" to Date value.");
        }
    }

    public Date getParaToDate(String name) {
        return this.toDate(this.request.getParameter(name), null);
    }

    public Date getParaToDate(String name, Date defaultValue) {
        return this.toDate(this.request.getParameter(name), defaultValue);
    }

    public Date getParaToDate() {
        return this.toDate(this.getPara(), null);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public <T> T getSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        return (T)(session != null ? session.getAttribute(key) : null);
    }

    public Controller setSessionAttr(String key, Object value) {
        this.request.getSession(true).setAttribute(key, value);
        return this;
    }

    public Controller removeSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
        return this;
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    public Integer getCookieToInt(String name) {
        String result = this.getCookie(name);
        return result != null ? Integer.valueOf(Integer.parseInt(result)) : null;
    }

    public Integer getCookieToInt(String name, Integer defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    public Long getCookieToLong(String name) {
        String result = this.getCookie(name);
        return result != null ? Long.valueOf(Long.parseLong(result)) : null;
    }

    public Long getCookieToLong(String name, Long defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public Cookie[] getCookieObjects() {
        Cookie[] result = this.request.getCookies();
        return result != null ? result : new Cookie[]{};
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, null, null, isHttpOnly);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds) {
        return this.doSetCookie(name, value, maxAgeInSeconds, null, null, null);
    }

    public Controller setCookie(Cookie cookie) {
        this.response.addCookie(cookie);
        return this;
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, path, null, isHttpOnly);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path) {
        return this.doSetCookie(name, value, maxAgeInSeconds, path, null, null);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path, String domain, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, path, domain, isHttpOnly);
    }

    public Controller removeCookie(String name) {
        return this.doSetCookie(name, null, 0, null, null, null);
    }

    public Controller removeCookie(String name, String path) {
        return this.doSetCookie(name, null, 0, path, null, null);
    }

    public Controller removeCookie(String name, String path, String domain) {
        return this.doSetCookie(name, null, 0, path, domain, null);
    }

    private Controller doSetCookie(String name, String value, int maxAgeInSeconds, String path, String domain, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        if (path != null) {
            cookie.setPath(path);
        }
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (isHttpOnly != null) {
            cookie.setHttpOnly(isHttpOnly.booleanValue());
        }
        this.response.addCookie(cookie);
        return this;
    }

    public String getPara() {
        if ("".equals(this.urlPara)) {
            this.urlPara = null;
        }
        return this.urlPara;
    }

    public String getPara(int index) {
        if (index < 0) {
            return this.getPara();
        }
        if (this.urlParaArray == null) {
            this.urlParaArray = this.urlPara == null || "".equals(this.urlPara) ? NULL_URL_PARA_ARRAY : this.urlPara.split(URL_PARA_SEPARATOR);
            for (int i = 0; i < this.urlParaArray.length; ++i) {
                if (!"".equals(this.urlParaArray[i])) continue;
                this.urlParaArray[i] = null;
            }
        }
        return this.urlParaArray.length > index ? this.urlParaArray[index] : null;
    }

    public String getPara(int index, String defaultValue) {
        String result = this.getPara(index);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public Integer getParaToInt(int index) {
        return this.toInt(this.getPara(index), null);
    }

    public Integer getParaToInt(int index, Integer defaultValue) {
        return this.toInt(this.getPara(index), defaultValue);
    }

    public Long getParaToLong(int index) {
        return this.toLong(this.getPara(index), null);
    }

    public Long getParaToLong(int index, Long defaultValue) {
        return this.toLong(this.getPara(index), defaultValue);
    }

    public Integer getParaToInt() {
        return this.toInt(this.getPara(), null);
    }

    public Long getParaToLong() {
        return this.toLong(this.getPara(), null);
    }

    public <T> T getModel(Class<T> modelClass) {
        return Injector.injectModel(modelClass, this.request, false);
    }

    public <T> T getModel(Class<T> modelClass, boolean skipConvertError) {
        return Injector.injectModel(modelClass, this.request, skipConvertError);
    }

    public <T> T getModel(Class<T> modelClass, String modelName) {
        return Injector.injectModel(modelClass, modelName, this.request, false);
    }

    public <T> T getModel(Class<T> modelClass, String modelName, boolean skipConvertError) {
        return Injector.injectModel(modelClass, modelName, this.request, skipConvertError);
    }

    public <T> T getBean(Class<T> beanClass) {
        return Injector.injectBean(beanClass, this.request, false);
    }

    public <T> T getBean(Class<T> beanClass, boolean skipConvertError) {
        return Injector.injectBean(beanClass, this.request, skipConvertError);
    }

    public <T> T getBean(Class<T> beanClass, String beanName) {
        return Injector.injectBean(beanClass, beanName, this.request, false);
    }

    public <T> T getBean(Class<T> beanClass, String beanName, boolean skipConvertError) {
        return Injector.injectBean(beanClass, beanName, this.request, skipConvertError);
    }

    public List<UploadFile> getFiles(String uploadPath, Integer maxPostSize, String encoding) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, uploadPath, maxPostSize, encoding);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String uploadPath, Integer maxPostSize, String encoding) {
        this.getFiles(uploadPath, maxPostSize, encoding);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles(String uploadPath, int maxPostSize) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, uploadPath, maxPostSize);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String uploadPath, int maxPostSize) {
        this.getFiles(uploadPath, maxPostSize);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles(String uploadPath) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, uploadPath);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String uploadPath) {
        this.getFiles(uploadPath);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles() {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile() {
        List<UploadFile> uploadFiles = this.getFiles();
        return uploadFiles.size() > 0 ? uploadFiles.get(0) : null;
    }

    public UploadFile getFile(String parameterName) {
        List<UploadFile> uploadFiles = this.getFiles();
        for (UploadFile uploadFile : uploadFiles) {
            if (!uploadFile.getParameterName().equals(parameterName)) continue;
            return uploadFile;
        }
        return null;
    }

    public Controller keepPara() {
        Map map = this.request.getParameterMap();
        for (Map.Entry e : map.entrySet()) {
            String[] values = (String[])e.getValue();
            if (values.length == 1) {
                this.request.setAttribute((String)e.getKey(), (Object)values[0]);
                continue;
            }
            this.request.setAttribute((String)e.getKey(), (Object)values);
        }
        return this;
    }

    public Controller keepPara(String ... names) {
        for (String name : names) {
            String[] values = this.request.getParameterValues(name);
            if (values == null) continue;
            if (values.length == 1) {
                this.request.setAttribute(name, (Object)values[0]);
                continue;
            }
            this.request.setAttribute(name, (Object)values);
        }
        return this;
    }

    public Controller keepPara(Class type, String name) {
        String[] values = this.request.getParameterValues(name);
        if (values != null) {
            if (values.length == 1) {
                try {
                    this.request.setAttribute(name, TypeConverter.convert(type, values[0]));
                }
                catch (ParseException e) {
                    LogKit.logNothing(e);
                }
            } else {
                this.request.setAttribute(name, (Object)values);
            }
        }
        return this;
    }

    public Controller keepPara(Class type, String ... names) {
        if (type == String.class) {
            return this.keepPara(names);
        }
        if (names != null) {
            for (String name : names) {
                this.keepPara(type, name);
            }
        }
        return this;
    }

    public Controller keepModel(Class<? extends Model> modelClass, String modelName) {
        if (StrKit.notBlank(modelName)) {
            Model model = Injector.injectModel(modelClass, modelName, this.request, true);
            this.request.setAttribute(modelName, (Object)model);
        } else {
            this.keepPara();
        }
        return this;
    }

    public Controller keepModel(Class<? extends Model> modelClass) {
        String modelName = StrKit.firstCharToLowerCase(modelClass.getSimpleName());
        this.keepModel(modelClass, modelName);
        return this;
    }

    public Controller keepBean(Class<?> beanClass, String beanName) {
        if (StrKit.notBlank(beanName)) {
            Object bean = Injector.injectBean(beanClass, beanName, this.request, true);
            this.request.setAttribute(beanName, bean);
        } else {
            this.keepPara();
        }
        return this;
    }

    public Controller keepBean(Class<?> beanClass) {
        String beanName = StrKit.firstCharToLowerCase(beanClass.getSimpleName());
        this.keepBean(beanClass, beanName);
        return this;
    }

    public void createToken(String tokenName, int secondsOfTimeOut) {
        TokenManager.createToken(this, tokenName, secondsOfTimeOut);
    }

    public void createToken() {
        this.createToken("_jfinal_token", 900);
    }

    public void createToken(String tokenName) {
        this.createToken(tokenName, 900);
    }

    public boolean validateToken(String tokenName) {
        return TokenManager.validateToken(this, tokenName);
    }

    public boolean validateToken() {
        return this.validateToken("_jfinal_token");
    }

    public boolean isParaBlank(String paraName) {
        String value = this.request.getParameter(paraName);
        return value == null || value.trim().length() == 0;
    }

    public boolean isParaBlank(int index) {
        String value = this.getPara(index);
        return value == null || value.trim().length() == 0;
    }

    public boolean isParaExists(String paraName) {
        return this.request.getParameterMap().containsKey(paraName);
    }

    public boolean isParaExists(int index) {
        return this.getPara(index) != null;
    }

    public Render getRender() {
        return this.render;
    }

    public void render(Render render) {
        this.render = render;
    }

    public void render(String view) {
        this.render = renderFactory.getRender(view);
    }

    public void renderJsp(String view) {
        this.render = renderFactory.getJspRender(view);
    }

    public void renderFreeMarker(String view) {
        this.render = renderFactory.getFreeMarkerRender(view);
    }

    public void renderVelocity(String view) {
        this.render = renderFactory.getVelocityRender(view);
    }

    public void renderJson(String key, Object value) {
        this.render = renderFactory.getJsonRender(key, value);
    }

    public void renderJson() {
        this.render = renderFactory.getJsonRender();
    }

    public void renderJson(String[] attrs) {
        this.render = renderFactory.getJsonRender(attrs);
    }

    public void renderJson(String jsonText) {
        this.render = renderFactory.getJsonRender(jsonText);
    }

    public void renderJson(Object object) {
        this.render = object instanceof JsonRender ? (JsonRender)object : renderFactory.getJsonRender(object);
    }

    public void renderText(String text) {
        this.render = renderFactory.getTextRender(text);
    }

    public void renderText(String text, String contentType) {
        this.render = renderFactory.getTextRender(text, contentType);
    }

    public void renderText(String text, ContentType contentType) {
        this.render = renderFactory.getTextRender(text, contentType);
    }

    public void forwardAction(String actionUrl) {
        this.render = new ActionRender(actionUrl);
    }

    public void renderFile(String fileName) {
        this.render = renderFactory.getFileRender(fileName);
    }

    public void renderFile(File file) {
        this.render = renderFactory.getFileRender(file);
    }

    public void redirect(String url) {
        this.render = renderFactory.getRedirectRender(url);
    }

    public void redirect(String url, boolean withQueryString) {
        this.render = renderFactory.getRedirectRender(url, withQueryString);
    }

    public void render(String view, int status) {
        this.render = renderFactory.getRender(view);
        this.response.setStatus(status);
    }

    public void redirect301(String url) {
        this.render = renderFactory.getRedirect301Render(url);
    }

    public void redirect301(String url, boolean withQueryString) {
        this.render = renderFactory.getRedirect301Render(url, withQueryString);
    }

    public void renderError(int errorCode, String view) {
        throw new ActionException(errorCode, renderFactory.getErrorRender(errorCode, view));
    }

    public void renderError(int errorCode, Render render) {
        throw new ActionException(errorCode, render);
    }

    public void renderError(int errorCode) {
        throw new ActionException(errorCode, renderFactory.getErrorRender(errorCode));
    }

    public void renderNull() {
        this.render = renderFactory.getNullRender();
    }

    public void renderJavascript(String javascriptText) {
        this.render = renderFactory.getJavascriptRender(javascriptText);
    }

    public void renderHtml(String htmlText) {
        this.render = renderFactory.getHtmlRender(htmlText);
    }

    public void renderXml(String view) {
        this.render = renderFactory.getXmlRender(view);
    }

    public void renderCaptcha() {
        this.render = renderFactory.getCaptchaRender();
    }

    public boolean validateCaptcha(String paraName) {
        return CaptchaRender.validate(this, this.getPara(paraName));
    }

    public void checkUrlPara(int minLength, int maxLength) {
        this.getPara(0);
        if (this.urlParaArray.length < minLength || this.urlParaArray.length > maxLength) {
            this.renderError(404);
        }
    }

    public void checkUrlPara(int length) {
        this.checkUrlPara(length, length);
    }

    public <T> T enhance(Class<T> targetClass) {
        return Enhancer.enhance(targetClass);
    }

    public <T> T enhance(Class<T> targetClass, Interceptor ... injectInters) {
        return Enhancer.enhance(targetClass, injectInters);
    }

    public <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> ... injectIntersClasses) {
        return Enhancer.enhance(targetClass, injectIntersClasses);
    }

    public <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> injectIntersClass) {
        return Enhancer.enhance(targetClass, injectIntersClass);
    }

    public <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2) {
        return Enhancer.enhance(targetClass, injectIntersClass1, injectIntersClass2);
    }

    public <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2, Class<? extends Interceptor> injectIntersClass3) {
        return Enhancer.enhance(targetClass, injectIntersClass1, injectIntersClass2, injectIntersClass3);
    }

    public <T> T enhance(String singletonKey, Class<T> targetClass) {
        return Enhancer.enhance(singletonKey, targetClass);
    }

    public <T> T enhance(String singletonKey, Class<T> targetClass, Interceptor ... injectInters) {
        return Enhancer.enhance(singletonKey, targetClass, injectInters);
    }

    public <T> T enhance(String singletonKey, Class<T> targetClass, Class<? extends Interceptor> ... injectIntersClasses) {
        return Enhancer.enhance(singletonKey, targetClass, injectIntersClasses);
    }

    public <T> T enhance(Object target) {
        return Enhancer.enhance(target);
    }

    public <T> T enhance(Object target, Interceptor ... injectInters) {
        return Enhancer.enhance(target, injectInters);
    }

    public <T> T enhance(Object target, Class<? extends Interceptor> ... injectIntersClasses) {
        return Enhancer.enhance(target, injectIntersClasses);
    }

    public <T> T enhance(Object target, Class<? extends Interceptor> injectIntersClass) {
        return Enhancer.enhance(target, injectIntersClass);
    }

    public <T> T enhance(Object target, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2) {
        return Enhancer.enhance(target, injectIntersClass1, injectIntersClass2);
    }

    public <T> T enhance(Object target, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2, Class<? extends Interceptor> injectIntersClass3) {
        return Enhancer.enhance(target, injectIntersClass1, injectIntersClass2, injectIntersClass3);
    }

    public <T> T enhance(String singletonKey, Object target) {
        return Enhancer.enhance(singletonKey, target);
    }

    public <T> T enhance(String singletonKey, Object target, Interceptor ... injectInters) {
        return Enhancer.enhance(singletonKey, target, injectInters);
    }

    public <T> T enhance(String singletonKey, Object target, Class<? extends Interceptor> ... injectIntersClasses) {
        return Enhancer.enhance(singletonKey, target, injectIntersClasses);
    }
}

