/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.JFinalFilter;
import com.jfinal.log.Log;
import com.jfinal.log.LogManager;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import java.util.List;

class Config {
    private static final Constants constants = new Constants();
    private static final Routes routes = new Routes(){

        @Override
        public void config() {
        }
    };
    private static final Plugins plugins = new Plugins();
    private static final Interceptors interceptors = new Interceptors();
    private static final Handlers handlers = new Handlers();
    private static Log log;

    private Config() {
    }

    static void configJFinal(JFinalConfig jfinalConfig) {
        jfinalConfig.configConstant(constants);
        Config.initLogFactory();
        jfinalConfig.configRoute(routes);
        jfinalConfig.configPlugin(plugins);
        Config.startPlugins();
        jfinalConfig.configInterceptor(interceptors);
        jfinalConfig.configHandler(handlers);
    }

    public static final Constants getConstants() {
        return constants;
    }

    public static final Routes getRoutes() {
        return routes;
    }

    public static final Plugins getPlugins() {
        return plugins;
    }

    public static final Interceptors getInterceptors() {
        return interceptors;
    }

    public static Handlers getHandlers() {
        return handlers;
    }

    private static void startPlugins() {
        List<IPlugin> pluginList = plugins.getPluginList();
        if (pluginList == null) {
            return;
        }
        for (IPlugin plugin : pluginList) {
            try {
                ActiveRecordPlugin arp;
                if (plugin instanceof ActiveRecordPlugin && (arp = (ActiveRecordPlugin)plugin).getDevMode() == null) {
                    arp.setDevMode(constants.getDevMode());
                }
                if (plugin.start()) continue;
                String message = "Plugin start error: " + plugin.getClass().getName();
                log.error(message);
                throw new RuntimeException(message);
            }
            catch (Exception e) {
                String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                log.error(message, e);
                throw new RuntimeException(message, e);
            }
        }
    }

    private static void initLogFactory() {
        LogManager.me().init();
        log = Log.getLog(Config.class);
        JFinalFilter.initLog();
    }
}

