/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.config.Routes;
import com.jfinal.core.ActionReporter;
import com.jfinal.core.Const;
import com.jfinal.i18n.I18n;
import com.jfinal.json.IJsonFactory;
import com.jfinal.json.JsonManager;
import com.jfinal.kit.StrKit;
import com.jfinal.log.ILogFactory;
import com.jfinal.log.LogManager;
import com.jfinal.render.IErrorRenderFactory;
import com.jfinal.render.IMainRenderFactory;
import com.jfinal.render.IXmlRenderFactory;
import com.jfinal.render.RenderFactory;
import com.jfinal.render.ViewType;
import com.jfinal.token.ITokenCache;
import java.util.HashMap;
import java.util.Map;

public final class Constants {
    private boolean devMode = false;
    private String baseUploadPath = "upload";
    private String baseDownloadPath = "download";
    private String encoding = "UTF-8";
    private String urlParaSeparator = "-";
    private ViewType viewType = Const.DEFAULT_VIEW_TYPE;
    private String jspViewExtension = ".jsp";
    private String freeMarkerViewExtension = ".html";
    private String velocityViewExtension = ".vm";
    private int maxPostSize = 0xA00000;
    private int freeMarkerTemplateUpdateDelay = 3600;
    private ITokenCache tokenCache = null;
    private Map<Integer, String> errorViewMapping = new HashMap<Integer, String>();

    public void setTokenCache(ITokenCache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public ITokenCache getTokenCache() {
        return this.tokenCache;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getDevMode() {
        return this.devMode;
    }

    public String getUrlParaSeparator() {
        return this.urlParaSeparator;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        if (viewType == null) {
            throw new IllegalArgumentException("viewType can not be null");
        }
        if (viewType != ViewType.OTHER) {
            this.viewType = viewType;
        }
    }

    public void setUrlParaSeparator(String urlParaSeparator) {
        if (StrKit.isBlank(urlParaSeparator) || urlParaSeparator.contains("/")) {
            throw new IllegalArgumentException("urlParaSepartor can not be blank and can not contains \"/\"");
        }
        this.urlParaSeparator = urlParaSeparator;
    }

    public String getJspViewExtension() {
        return this.jspViewExtension;
    }

    public void setJspViewExtension(String jspViewExtension) {
        this.jspViewExtension = jspViewExtension.startsWith(".") ? jspViewExtension : "." + jspViewExtension;
    }

    public String getFreeMarkerViewExtension() {
        return this.freeMarkerViewExtension;
    }

    public void setFreeMarkerViewExtension(String freeMarkerViewExtension) {
        this.freeMarkerViewExtension = freeMarkerViewExtension.startsWith(".") ? freeMarkerViewExtension : "." + freeMarkerViewExtension;
    }

    public String getVelocityViewExtension() {
        return this.velocityViewExtension;
    }

    public void setVelocityViewExtension(String velocityViewExtension) {
        this.velocityViewExtension = velocityViewExtension.startsWith(".") ? velocityViewExtension : "." + velocityViewExtension;
    }

    public void setError404View(String error404View) {
        this.errorViewMapping.put(404, error404View);
    }

    public void setError500View(String error500View) {
        this.errorViewMapping.put(500, error500View);
    }

    public void setError401View(String error401View) {
        this.errorViewMapping.put(401, error401View);
    }

    public void setError403View(String error403View) {
        this.errorViewMapping.put(403, error403View);
    }

    public void setErrorView(int errorCode, String errorView) {
        this.errorViewMapping.put(errorCode, errorView);
    }

    public String getErrorView(int errorCode) {
        return this.errorViewMapping.get(errorCode);
    }

    public String getBaseDownloadPath() {
        return this.baseDownloadPath;
    }

    public void setBaseDownloadPath(String baseDownloadPath) {
        if (StrKit.isBlank(baseDownloadPath)) {
            throw new IllegalArgumentException("baseDownloadPath can not be blank.");
        }
        this.baseDownloadPath = baseDownloadPath;
    }

    public void setBaseUploadPath(String baseUploadPath) {
        if (StrKit.isBlank(baseUploadPath)) {
            throw new IllegalArgumentException("baseUploadPath can not be blank.");
        }
        this.baseUploadPath = baseUploadPath;
    }

    public String getBaseUploadPath() {
        return this.baseUploadPath;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public void setI18nDefaultBaseName(String defaultBaseName) {
        I18n.setDefaultBaseName(defaultBaseName);
    }

    public void setI18nDefaultLocale(String defaultLocale) {
        I18n.setDefaultLocale(defaultLocale);
    }

    public void setFreeMarkerTemplateUpdateDelay(int delayInSeconds) {
        if (delayInSeconds < 0) {
            throw new IllegalArgumentException("template_update_delay must more than -1.");
        }
        this.freeMarkerTemplateUpdateDelay = delayInSeconds;
    }

    public int getFreeMarkerTemplateUpdateDelay() {
        return this.freeMarkerTemplateUpdateDelay;
    }

    public void setBaseViewPath(String baseViewPath) {
        Routes.setBaseViewPath(baseViewPath);
    }

    public void setMainRenderFactory(IMainRenderFactory mainRenderFactory) {
        if (mainRenderFactory == null) {
            throw new IllegalArgumentException("mainRenderFactory can not be null.");
        }
        this.viewType = ViewType.OTHER;
        RenderFactory.me().setMainRenderFactory(mainRenderFactory);
    }

    public void setLogFactory(ILogFactory logFactory) {
        if (logFactory == null) {
            throw new IllegalArgumentException("logFactory can not be null.");
        }
        LogManager.me().setDefaultLogFactory(logFactory);
    }

    public void setErrorRenderFactory(IErrorRenderFactory errorRenderFactory) {
        if (errorRenderFactory == null) {
            throw new IllegalArgumentException("errorRenderFactory can not be null.");
        }
        RenderFactory.me().setErrorRenderFactory(errorRenderFactory);
    }

    public void setXmlRenderFactory(IXmlRenderFactory xmlRenderFactory) {
        if (xmlRenderFactory == null) {
            throw new IllegalArgumentException("xmlRenderFactory can not be null.");
        }
        RenderFactory.me().setXmlRenderFactory(xmlRenderFactory);
    }

    public void setJsonFactory(IJsonFactory jsonFactory) {
        if (jsonFactory == null) {
            throw new IllegalArgumentException("jsonFactory can not be null.");
        }
        JsonManager.me().setDefaultJsonFactory(jsonFactory);
    }

    public void setJsonDatePattern(String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            throw new IllegalArgumentException("datePattern can not be blank.");
        }
        JsonManager.me().setDefaultDatePattern(datePattern);
    }

    public void setReportAfterInvocation(boolean reportAfterInvocation) {
        ActionReporter.setReportAfterInvocation(reportAfterInvocation);
    }
}

