/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Formattable;
import java.util.Formatter;

final class ObjectDecor
implements Formattable {
    private final transient Object object;

    ObjectDecor(Object obj) {
        this.object = obj;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.object == null) {
            formatter.format("NULL", new Object[0]);
        } else if (this.object.getClass().isArray()) {
            formatter.format(Arrays.deepToString((Object[])this.object), new Object[0]);
        } else {
            String output = AccessController.doPrivileged(new ObjectContentsFormatAction());
            formatter.format(output, new Object[0]);
        }
    }

    public String toString() {
        return "ObjectDecor(object=" + this.object + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectDecor)) {
            return false;
        }
        ObjectDecor other = (ObjectDecor)o;
        Object this$object = this.object;
        Object other$object = other.object;
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $object = this.object;
        result = result * 59 + ($object == null ? 0 : $object.hashCode());
        return result;
    }

    private final class ObjectContentsFormatAction
    implements PrivilegedAction<String> {
        private ObjectContentsFormatAction() {
        }

        @Override
        public String run() {
            StringBuilder builder = new StringBuilder("{");
            for (Field field : ObjectDecor.this.object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    builder.append(String.format("%s: \"%s\"", field.getName(), field.get(ObjectDecor.this.object)));
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException(ex);
                }
                builder.append(", ");
            }
            builder.replace(builder.length() - 2, builder.length(), "}");
            return builder.toString();
        }
    }
}

