/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class VerboseProcess {
    private static final String UTF_8 = "UTF-8";
    private final transient Process process;
    private final transient Level olevel;
    private final transient Level elevel;

    public VerboseProcess(Process prc) {
        this(prc, Level.INFO, Level.WARNING);
    }

    public VerboseProcess(ProcessBuilder builder) {
        this(VerboseProcess.start(builder));
    }

    public VerboseProcess(Process prc, Level stdout, Level stderr) {
        if (prc == null) {
            throw new IllegalArgumentException("process can't be NULL");
        }
        if (stdout == null) {
            throw new IllegalArgumentException("stdout LEVEL can't be NULL");
        }
        if (stderr == null) {
            throw new IllegalArgumentException("stderr LEVEL can't be NULL");
        }
        this.process = prc;
        this.olevel = stdout;
        this.elevel = stderr;
    }

    public VerboseProcess(ProcessBuilder bdr, Level stdout, Level stderr) {
        this(VerboseProcess.start(bdr), stdout, stderr);
    }

    public String stdout() {
        return this.stdout(true);
    }

    public String stdoutQuietly() {
        return this.stdout(false);
    }

    private static Process start(ProcessBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder can't be NULL");
        }
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            return process;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String stdout(boolean check) {
        String stdout;
        long start = System.currentTimeMillis();
        try {
            stdout = this.waitFor();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        int code = this.process.exitValue();
        Logger.debug(this, "#stdout(): process %s completed (code=%d, size=%d) in %[ms]s", this.process, code, stdout.length(), System.currentTimeMillis() - start);
        if (check && code != 0) {
            throw new IllegalArgumentException(Logger.format("Non-zero exit code %d: %[text]s", code, stdout));
        }
        return stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitFor() throws InterruptedException {
        CountDownLatch done = new CountDownLatch(2);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        Logger.debug(this, "#waitFor(): waiting for stdout of %s in %s...", this.process, VerboseProcess.monitor(this.process.getInputStream(), done, stdout, this.olevel));
        Logger.debug(this, "#waitFor(): waiting for stderr of %s in %s...", this.process, VerboseProcess.monitor(this.process.getErrorStream(), done, new ByteArrayOutputStream(), this.elevel));
        try {
            this.process.waitFor();
        }
        catch (Throwable throwable) {
            Logger.debug(this, "#waitFor(): process finished: %s", this.process);
            if (!done.await(2L, TimeUnit.SECONDS)) {
                Logger.error(this, "#wait() failed");
            }
            throw throwable;
        }
        Logger.debug(this, "#waitFor(): process finished: %s", this.process);
        if (!done.await(2L, TimeUnit.SECONDS)) {
            Logger.error(this, "#wait() failed");
        }
        try {
            return stdout.toString(UTF_8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Thread monitor(InputStream input, CountDownLatch done, OutputStream output, Level level) {
        Thread thread = new Thread(new VerboseRunnable(new Monitor(input, done, output, level), false));
        thread.setName("VerboseProcess");
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static void close(Closeable res) {
        try {
            res.close();
        }
        catch (IOException ex) {
            Logger.error(VerboseProcess.class, "failed to close resource: %[exception]s", ex);
        }
    }

    public String toString() {
        return "VerboseProcess(process=" + this.process + ", olevel=" + this.olevel + ", elevel=" + this.elevel + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseProcess)) {
            return false;
        }
        VerboseProcess other = (VerboseProcess)o;
        Process this$process = this.process;
        Process other$process = other.process;
        return !(this$process == null ? other$process != null : !this$process.equals(other$process));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Process $process = this.process;
        result = result * 59 + ($process == null ? 0 : $process.hashCode());
        return result;
    }

    private static final class Monitor
    implements Callable<Void> {
        private final transient InputStream input;
        private final transient CountDownLatch done;
        private final transient OutputStream output;
        private final transient Level level;

        Monitor(InputStream inp, CountDownLatch latch, OutputStream out, Level lvl) {
            this.input = inp;
            this.done = latch;
            this.output = out;
            this.level = lvl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.input, VerboseProcess.UTF_8));
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.output, VerboseProcess.UTF_8));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Logger.log(this.level, VerboseProcess.class, ">> %s", line);
                        writer.write(line);
                        writer.newLine();
                    }
                }
                finally {
                    this.done.countDown();
                    VerboseProcess.close(writer);
                }
            }
            finally {
                VerboseProcess.close(reader);
            }
            return null;
        }
    }
}

