/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.GridTemplateShorthandResolver;
import java.util.ArrayList;
import java.util.List;

public class GridShorthandResolver
implements IShorthandResolver {
    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (!shorthandExpression.contains("auto-flow")) {
            return new GridTemplateShorthandResolver().resolveShorthand(shorthandExpression);
        }
        String[] values = shorthandExpression.trim().split("/");
        ArrayList<CssDeclaration> result = new ArrayList<CssDeclaration>();
        if (values[0].contains("auto-flow")) {
            String rowsTemplate;
            if (values[0].contains("dense")) {
                result.add(new CssDeclaration("grid-auto-flow", "dense"));
            }
            if (!(rowsTemplate = values[0].substring(Math.max(values[0].indexOf("auto-flow") + "auto-flow".length(), values[0].indexOf("dense") + "dense".length()))).trim().isEmpty()) {
                result.add(new CssDeclaration("grid-auto-rows", rowsTemplate));
            }
            if (values.length == 2) {
                result.add(new CssDeclaration("grid-template-columns", values[1]));
            }
        } else if (values.length == 2) {
            String columnsTemplate;
            result.add(new CssDeclaration("grid-template-rows", values[0]));
            if (values[1].contains("dense")) {
                result.add(new CssDeclaration("grid-auto-flow", "column dense"));
            }
            if (!(columnsTemplate = values[1].substring(Math.max(values[1].indexOf("auto-flow") + "auto-flow".length(), values[1].indexOf("dense") + "dense".length()))).trim().isEmpty()) {
                result.add(new CssDeclaration("grid-auto-columns", columnsTemplate));
            }
        }
        return result;
    }
}

