/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.Map;

public final class PdfUA2EmbeddedFilesChecker {
    private PdfUA2EmbeddedFilesChecker() {
    }

    public static void checkEmbeddedFiles(PdfCatalog catalog) {
        PdfNameTree embeddedFiles = catalog.getNameTree(PdfName.EmbeddedFiles);
        Map embeddedFilesMap = embeddedFiles.getNames();
        for (PdfObject fileSpecObject : embeddedFilesMap.values()) {
            PdfUA2EmbeddedFilesChecker.checkFileSpec(fileSpecObject);
        }
    }

    private static void checkFileSpec(PdfObject obj) {
        PdfDictionary dict;
        PdfName type;
        if (obj.getType() == 3 && PdfName.Filespec.equals((Object)(type = (dict = (PdfDictionary)obj).getAsName(PdfName.Type))) && !dict.containsKey(PdfName.Desc)) {
            throw new PdfUAConformanceException("The Desc entry shall be present on all file specification dictionaries present in the EmbeddedFiles name tree of a conforming file.");
        }
    }
}

