/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.IRandomAccessSource;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ByteBufferRandomAccessSource
implements IRandomAccessSource,
Serializable {
    private static final long serialVersionUID = -1477190062876186034L;
    private transient ByteBuffer byteBuffer;
    private byte[] bufferMirror;
    public static final boolean UNMAP_SUPPORTED;
    private static final BufferCleaner CLEANER;

    public ByteBufferRandomAccessSource(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public int get(long position) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position must be less than Integer.MAX_VALUE");
        }
        try {
            if (position >= (long)this.byteBuffer.limit()) {
                return -1;
            }
            byte b = this.byteBuffer.get((int)position);
            return b & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position must be less than Integer.MAX_VALUE");
        }
        if (position >= (long)this.byteBuffer.limit()) {
            return -1;
        }
        this.byteBuffer.position((int)position);
        int bytesFromThisBuffer = Math.min(len, this.byteBuffer.remaining());
        this.byteBuffer.get(bytes, off, bytesFromThisBuffer);
        return bytesFromThisBuffer;
    }

    @Override
    public long length() {
        return this.byteBuffer.limit();
    }

    @Override
    public void close() throws IOException {
        ByteBufferRandomAccessSource.clean(this.byteBuffer);
    }

    private static boolean clean(final ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean success = Boolean.FALSE;
                try {
                    if (UNMAP_SUPPORTED) {
                        CLEANER.freeBuffer(buffer.toString(), buffer);
                    } else {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, (Object[])null);
                        Method clean = cleaner.getClass().getMethod("clean", null);
                        clean.invoke(cleaner, (Object[])null);
                    }
                    success = Boolean.TRUE;
                }
                catch (Exception e) {
                    Logger logger = LoggerFactory.getLogger(ByteBufferRandomAccessSource.class);
                    logger.debug(e.getMessage());
                }
                return success;
            }
        });
        return b;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.byteBuffer != null && this.byteBuffer.hasArray()) {
            throw new NotSerializableException(this.byteBuffer.getClass().toString());
        }
        if (this.byteBuffer != null) {
            this.bufferMirror = this.byteBuffer.array();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.bufferMirror != null) {
            this.byteBuffer = ByteBuffer.wrap(this.bufferMirror);
            this.bufferMirror = null;
        }
    }

    private static Object unmapHackImpl() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return new BufferCleaner(ByteBuffer.class, unmapper.bindTo(theUnsafe));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    static {
        Object hack = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ByteBufferRandomAccessSource.unmapHackImpl();
            }
        });
        if (hack instanceof BufferCleaner) {
            CLEANER = (BufferCleaner)hack;
            UNMAP_SUPPORTED = true;
        } else {
            CLEANER = null;
            UNMAP_SUPPORTED = false;
        }
    }

    private static class BufferCleaner {
        Class<?> unmappableBufferClass;
        final MethodHandle unmapper;

        BufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
            this.unmappableBufferClass = unmappableBufferClass;
            this.unmapper = unmapper;
        }

        void freeBuffer(String resourceDescription, final ByteBuffer buffer) throws IOException {
            assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), this.unmapper.type()));
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("unmapping only works with direct buffers");
            }
            if (!this.unmappableBufferClass.isInstance(buffer)) {
                throw new IllegalArgumentException("buffer is not an instance of " + this.unmappableBufferClass.getName());
            }
            Throwable error = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

                @Override
                public Throwable run() {
                    try {
                        BufferCleaner.this.unmapper.invokeExact(buffer);
                        return null;
                    }
                    catch (Throwable t) {
                        return t;
                    }
                }
            });
            if (error != null) {
                throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, error);
            }
        }
    }
}

