/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.properties.AlignContentPropertyValue;
import com.itextpdf.layout.properties.AlignmentPropertyValue;
import com.itextpdf.layout.properties.FlexDirectionPropertyValue;
import com.itextpdf.layout.properties.FlexWrapPropertyValue;
import com.itextpdf.layout.properties.JustifyContent;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlexApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexApplierUtil.class);

    private FlexApplierUtil() {
    }

    public static void applyFlexItemProperties(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String flexBasis;
        String flexShrink;
        element.setProperty(89, null);
        FlexApplierUtil.logWarningIfThereAreNotSupportedPropertyValues(FlexApplierUtil.createSupportedFlexItemPropertiesAndValuesMap(), cssProps);
        String flexGrow = cssProps.get("flex-grow");
        if (flexGrow != null) {
            Float flexGrowValue = CssDimensionParsingUtils.parseFloat((String)flexGrow);
            element.setProperty(132, (Object)flexGrowValue);
        }
        if ((flexShrink = cssProps.get("flex-shrink")) != null) {
            Float flexShrinkValue = CssDimensionParsingUtils.parseFloat((String)flexShrink);
            element.setProperty(127, (Object)flexShrinkValue);
        }
        if ((flexBasis = cssProps.get("flex-basis")) != null && !"auto".equals(flexBasis)) {
            if (!"content".equals(flexBasis)) {
                float em = CssDimensionParsingUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
                float rem = context.getCssContext().getRootFontSize();
                UnitValue flexBasisAbsoluteLength = CssDimensionParsingUtils.parseLengthValueToPt((String)flexBasis, (float)em, (float)rem);
                element.setProperty(131, (Object)flexBasisAbsoluteLength);
            } else {
                LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{"flex-basis", "content"}));
            }
        }
    }

    public static void applyFlexContainerProperties(Map<String, String> cssProps, IPropertyContainer element) {
        FlexApplierUtil.logWarningIfThereAreNotSupportedPropertyValues(FlexApplierUtil.createSupportedFlexContainerPropertiesAndValuesMap(), cssProps);
        FlexApplierUtil.applyAlignItems(cssProps, element);
        FlexApplierUtil.applyJustifyContent(cssProps, element);
        FlexApplierUtil.applyAlignContent(cssProps, element);
        FlexApplierUtil.applyWrap(cssProps, element);
        FlexApplierUtil.applyDirection(cssProps, element);
    }

    private static void applyWrap(Map<String, String> cssProps, IPropertyContainer element) {
        String wrapString = cssProps.get("flex-wrap");
        if (wrapString != null) {
            FlexWrapPropertyValue wrap;
            switch (wrapString) {
                case "wrap": {
                    wrap = FlexWrapPropertyValue.WRAP;
                    break;
                }
                case "wrap-reverse": {
                    wrap = FlexWrapPropertyValue.WRAP_REVERSE;
                    break;
                }
                case "nowrap": {
                    wrap = FlexWrapPropertyValue.NOWRAP;
                    break;
                }
                default: {
                    wrap = FlexWrapPropertyValue.NOWRAP;
                }
            }
            element.setProperty(128, (Object)wrap);
        }
    }

    private static void applyDirection(Map<String, String> cssProps, IPropertyContainer element) {
        String directionString = cssProps.get("flex-direction");
        if (directionString != null) {
            FlexDirectionPropertyValue direction;
            switch (directionString) {
                case "row": {
                    direction = FlexDirectionPropertyValue.ROW;
                    break;
                }
                case "row-reverse": {
                    direction = FlexDirectionPropertyValue.ROW_REVERSE;
                    break;
                }
                case "column": {
                    direction = FlexDirectionPropertyValue.COLUMN;
                    break;
                }
                case "column-reverse": {
                    direction = FlexDirectionPropertyValue.COLUMN_REVERSE;
                    break;
                }
                default: {
                    direction = FlexDirectionPropertyValue.ROW;
                }
            }
            element.setProperty(139, (Object)direction);
        }
    }

    private static void applyAlignItems(Map<String, String> cssProps, IPropertyContainer element) {
        String alignItemsString = cssProps.get("align-items");
        if (alignItemsString != null) {
            AlignmentPropertyValue alignItems;
            switch (alignItemsString) {
                case "normal": {
                    alignItems = AlignmentPropertyValue.NORMAL;
                    break;
                }
                case "start": {
                    alignItems = AlignmentPropertyValue.START;
                    break;
                }
                case "end": {
                    alignItems = AlignmentPropertyValue.END;
                    break;
                }
                case "flex-start": {
                    alignItems = AlignmentPropertyValue.FLEX_START;
                    break;
                }
                case "flex-end": {
                    alignItems = AlignmentPropertyValue.FLEX_END;
                    break;
                }
                case "center": {
                    alignItems = AlignmentPropertyValue.CENTER;
                    break;
                }
                case "self-start": {
                    alignItems = AlignmentPropertyValue.SELF_START;
                    break;
                }
                case "self-end": {
                    alignItems = AlignmentPropertyValue.SELF_END;
                    break;
                }
                case "stretch": {
                    alignItems = AlignmentPropertyValue.STRETCH;
                    break;
                }
                default: {
                    LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{"align-items", alignItemsString}));
                    alignItems = AlignmentPropertyValue.STRETCH;
                }
            }
            element.setProperty(134, (Object)alignItems);
        }
    }

    private static void applyJustifyContent(Map<String, String> cssProps, IPropertyContainer element) {
        String justifyContentString = cssProps.get("justify-content");
        if (justifyContentString != null) {
            JustifyContent justifyContent;
            switch (justifyContentString) {
                case "normal": {
                    justifyContent = JustifyContent.NORMAL;
                    break;
                }
                case "start": {
                    justifyContent = JustifyContent.START;
                    break;
                }
                case "end": {
                    justifyContent = JustifyContent.END;
                    break;
                }
                case "flex-end": {
                    justifyContent = JustifyContent.FLEX_END;
                    break;
                }
                case "self-start": {
                    justifyContent = JustifyContent.SELF_START;
                    break;
                }
                case "self-end": {
                    justifyContent = JustifyContent.SELF_END;
                    break;
                }
                case "left": {
                    justifyContent = JustifyContent.LEFT;
                    break;
                }
                case "right": {
                    justifyContent = JustifyContent.RIGHT;
                    break;
                }
                case "center": {
                    justifyContent = JustifyContent.CENTER;
                    break;
                }
                case "stretch": {
                    justifyContent = JustifyContent.STRETCH;
                    break;
                }
                case "flex-start": {
                    justifyContent = JustifyContent.FLEX_START;
                    break;
                }
                default: {
                    LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{"justify-content", justifyContentString}));
                    justifyContent = JustifyContent.FLEX_START;
                }
            }
            element.setProperty(133, (Object)justifyContent);
        }
    }

    private static void applyAlignContent(Map<String, String> cssProps, IPropertyContainer element) {
        String alignContentString = cssProps.get("align-content");
        if (alignContentString != null) {
            AlignContentPropertyValue alignContent;
            switch (alignContentString) {
                case "start": {
                    alignContent = AlignContentPropertyValue.START;
                    break;
                }
                case "flex-start": {
                    alignContent = AlignContentPropertyValue.FLEX_START;
                    break;
                }
                case "end": {
                    alignContent = AlignContentPropertyValue.END;
                    break;
                }
                case "flex-end": {
                    alignContent = AlignContentPropertyValue.FLEX_END;
                    break;
                }
                case "center": {
                    alignContent = AlignContentPropertyValue.CENTER;
                    break;
                }
                case "space-between": {
                    alignContent = AlignContentPropertyValue.SPACE_BETWEEN;
                    break;
                }
                case "space-around": {
                    alignContent = AlignContentPropertyValue.SPACE_AROUND;
                    break;
                }
                case "space-evenly": {
                    alignContent = AlignContentPropertyValue.SPACE_EVENLY;
                    break;
                }
                case "stretch": {
                    alignContent = AlignContentPropertyValue.STRETCH;
                    break;
                }
                default: {
                    alignContent = AlignContentPropertyValue.NORMAL;
                }
            }
            element.setProperty(130, (Object)alignContent);
        }
    }

    private static void logWarningIfThereAreNotSupportedPropertyValues(Map<String, Set<String>> supportedPairs, Map<String, String> cssProps) {
        for (Map.Entry<String, Set<String>> entry : supportedPairs.entrySet()) {
            String supportedPair = entry.getKey();
            Set<String> supportedValues = entry.getValue();
            String propertyValue = cssProps.get(supportedPair);
            if (propertyValue == null || supportedValues.contains(propertyValue)) continue;
            LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{supportedPair, propertyValue}));
        }
    }

    private static Map<String, Set<String>> createSupportedFlexItemPropertiesAndValuesMap() {
        HashMap<String, Set<String>> supportedPairs = new HashMap<String, Set<String>>();
        HashSet<String> supportedAlignSelfValues = new HashSet<String>();
        supportedAlignSelfValues.add("auto");
        supportedPairs.put("align-self", supportedAlignSelfValues);
        HashSet supportedOrderValues = new HashSet();
        supportedPairs.put("order", supportedOrderValues);
        return supportedPairs;
    }

    private static Map<String, Set<String>> createSupportedFlexContainerPropertiesAndValuesMap() {
        HashMap<String, Set<String>> supportedPairs = new HashMap<String, Set<String>>();
        HashSet<String> supportedFlexDirectionValues = new HashSet<String>();
        supportedFlexDirectionValues.add("row");
        supportedFlexDirectionValues.add("row-reverse");
        supportedFlexDirectionValues.add("column");
        supportedFlexDirectionValues.add("column-reverse");
        supportedPairs.put("flex-direction", supportedFlexDirectionValues);
        HashSet<String> supportedAlignContentValues = new HashSet<String>();
        supportedAlignContentValues.add("stretch");
        supportedAlignContentValues.add("normal");
        supportedAlignContentValues.add("flex-start");
        supportedAlignContentValues.add("start");
        supportedAlignContentValues.add("flex-end");
        supportedAlignContentValues.add("end");
        supportedAlignContentValues.add("center");
        supportedAlignContentValues.add("space-around");
        supportedAlignContentValues.add("space-between");
        supportedAlignContentValues.add("space-evenly");
        supportedPairs.put("align-content", supportedAlignContentValues);
        HashSet<String> supportedRowGapValues = new HashSet<String>();
        supportedRowGapValues.add("normal");
        supportedPairs.put("row-gap", supportedRowGapValues);
        HashSet<String> supportedColumnGapValues = new HashSet<String>();
        supportedColumnGapValues.add("normal");
        supportedPairs.put("column-gap", supportedColumnGapValues);
        return supportedPairs;
    }
}

