/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.kernel.colors.gradients.AbstractLinearGradientBuilder;
import com.itextpdf.kernel.colors.gradients.StrategyBasedLinearGradientBuilder;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BackgroundBox;
import com.itextpdf.layout.properties.BackgroundImage;
import com.itextpdf.layout.properties.BackgroundPosition;
import com.itextpdf.layout.properties.BackgroundRepeat;
import com.itextpdf.layout.properties.BlendMode;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.util.CssBackgroundUtils;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssGradientUtil;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.xobject.SvgImageXObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackgroundApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundApplierUtil.class);

    private BackgroundApplierUtil() {
    }

    public static void applyBackground(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String backgroundColorStr = cssProps.get("background-color");
        String backgroundImagesStr = cssProps.get("background-image");
        String backgroundRepeatStr = cssProps.get("background-repeat");
        String backgroundSizeStr = cssProps.get("background-size");
        String backgroundPositionXStr = cssProps.get("background-position-x");
        String backgroundPositionYStr = cssProps.get("background-position-y");
        String backgroundBlendModeStr = cssProps.get("background-blend-mode");
        String backgroundClipStr = cssProps.get("background-clip");
        String backgroundOriginStr = cssProps.get("background-origin");
        List backgroundImagesArray = CssUtils.splitStringWithComma((String)backgroundImagesStr);
        List backgroundRepeatArray = CssUtils.splitStringWithComma((String)backgroundRepeatStr);
        List backgroundSizeArray = backgroundSizeStr == null ? null : CssUtils.extractShorthandProperties((String)backgroundSizeStr);
        List backgroundPositionXArray = CssUtils.splitStringWithComma((String)backgroundPositionXStr);
        List backgroundPositionYArray = CssUtils.splitStringWithComma((String)backgroundPositionYStr);
        List backgroundBlendModeArray = CssUtils.splitStringWithComma((String)backgroundBlendModeStr);
        String fontSize = cssProps.get("font-size");
        float em = fontSize == null ? 0.0f : CssDimensionParsingUtils.parseAbsoluteLength((String)fontSize);
        float rem = context.getCssContext().getRootFontSize();
        List backgroundClipArray = CssUtils.splitStringWithComma((String)backgroundClipStr);
        List backgroundOriginArray = CssUtils.splitStringWithComma((String)backgroundOriginStr);
        BackgroundBox clipForColor = BackgroundApplierUtil.getBackgroundBoxProperty(backgroundClipArray, backgroundImagesArray.isEmpty() ? 0 : backgroundImagesArray.size() - 1, BackgroundBox.BORDER_BOX);
        BackgroundApplierUtil.applyBackgroundColor(backgroundColorStr, element, clipForColor);
        List<BackgroundImage> backgroundImagesList = BackgroundApplierUtil.getBackgroundImagesList(backgroundImagesArray, context, em, rem, backgroundPositionXArray, backgroundPositionYArray, backgroundSizeArray, backgroundBlendModeArray, backgroundRepeatArray, backgroundClipArray, backgroundOriginArray);
        if (!backgroundImagesList.isEmpty()) {
            element.setProperty(90, backgroundImagesList);
        }
    }

    private static List<BackgroundImage> getBackgroundImagesList(List<String> backgroundImagesArray, ProcessorContext context, float em, float rem, List<String> backgroundPositionXArray, List<String> backgroundPositionYArray, List<List<String>> backgroundSizeArray, List<String> backgroundBlendModeArray, List<String> backgroundRepeatArray, List<String> backgroundClipArray, List<String> backgroundOriginArray) {
        ArrayList<BackgroundImage> backgroundImagesList = new ArrayList<BackgroundImage>();
        for (int i = 0; i < backgroundImagesArray.size(); ++i) {
            String backgroundImage = backgroundImagesArray.get(i);
            if (backgroundImage == null || "none".equals(backgroundImage)) continue;
            BackgroundPosition position = BackgroundApplierUtil.applyBackgroundPosition(backgroundPositionXArray, backgroundPositionYArray, i, em, rem);
            BlendMode blendMode = BackgroundApplierUtil.applyBackgroundBlendMode(backgroundBlendModeArray, i);
            boolean imageApplied = false;
            BackgroundRepeat repeat = BackgroundApplierUtil.applyBackgroundRepeat(backgroundRepeatArray, i);
            BackgroundBox clip = BackgroundApplierUtil.getBackgroundBoxProperty(backgroundClipArray, i, BackgroundBox.BORDER_BOX);
            BackgroundBox origin = BackgroundApplierUtil.getBackgroundBoxProperty(backgroundOriginArray, i, BackgroundBox.PADDING_BOX);
            if (CssGradientUtil.isCssLinearGradientValue((String)backgroundImage)) {
                imageApplied = BackgroundApplierUtil.applyLinearGradient(backgroundImage, backgroundImagesList, blendMode, position, em, rem, repeat, clip, origin);
            } else {
                PdfXObject image = context.getResourceResolver().retrieveImage(CssUtils.extractUrl((String)backgroundImage));
                imageApplied = BackgroundApplierUtil.applyBackgroundImage(image, backgroundImagesList, repeat, blendMode, position, clip, origin);
            }
            if (!imageApplied) continue;
            BackgroundApplierUtil.applyBackgroundSize(backgroundSizeArray, em, rem, i, (BackgroundImage)backgroundImagesList.get(backgroundImagesList.size() - 1));
        }
        return backgroundImagesList;
    }

    private static BackgroundBox getBackgroundBoxProperty(List<String> propertyArray, int iteration, BackgroundBox defaultValue) {
        int index = BackgroundApplierUtil.getBackgroundSidePropertyIndex(propertyArray.size(), iteration);
        if (index == -1) {
            return defaultValue;
        }
        return BackgroundApplierUtil.getBackgroundBoxPropertyByString(propertyArray.get(index));
    }

    private static BackgroundBox getBackgroundBoxPropertyByString(String box) {
        if ("padding-box".equals(box)) {
            return BackgroundBox.PADDING_BOX;
        }
        if ("content-box".equals(box)) {
            return BackgroundBox.CONTENT_BOX;
        }
        return BackgroundBox.BORDER_BOX;
    }

    private static BlendMode applyBackgroundBlendMode(List<String> backgroundBlendModeArray, int iteration) {
        String cssValue = null;
        if (backgroundBlendModeArray != null && !backgroundBlendModeArray.isEmpty()) {
            int actualValueIteration = Math.min(iteration, backgroundBlendModeArray.size() - 1);
            cssValue = backgroundBlendModeArray.get(actualValueIteration);
        }
        return CssUtils.parseBlendMode(cssValue);
    }

    private static BackgroundPosition applyBackgroundPosition(List<String> backgroundPositionXArray, List<String> backgroundPositionYArray, int i, float em, float rem) {
        int indexY;
        BackgroundPosition position = new BackgroundPosition();
        int indexX = BackgroundApplierUtil.getBackgroundSidePropertyIndex(backgroundPositionXArray.size(), i);
        if (indexX != -1) {
            BackgroundApplierUtil.applyBackgroundPositionX(position, backgroundPositionXArray.get(indexX), em, rem);
        }
        if ((indexY = BackgroundApplierUtil.getBackgroundSidePropertyIndex(backgroundPositionYArray.size(), i)) != -1) {
            BackgroundApplierUtil.applyBackgroundPositionY(position, backgroundPositionYArray.get(indexY), em, rem);
        }
        return position;
    }

    private static void applyBackgroundPositionX(BackgroundPosition position, String xPosition, float em, float rem) {
        String[] stringArray = xPosition.split(" ");
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String value;
            switch (value = stringArray[i]) {
                case "left": {
                    position.setPositionX(BackgroundPosition.PositionX.LEFT);
                    continue block10;
                }
                case "right": {
                    position.setPositionX(BackgroundPosition.PositionX.RIGHT);
                    continue block10;
                }
                case "center": {
                    position.setPositionX(BackgroundPosition.PositionX.CENTER);
                    continue block10;
                }
                default: {
                    UnitValue unitValue = CssDimensionParsingUtils.parseLengthValueToPt((String)value, (float)em, (float)rem);
                    if (unitValue == null) continue block10;
                    position.setXShift(unitValue);
                }
            }
        }
    }

    private static void applyBackgroundPositionY(BackgroundPosition position, String yPosition, float em, float rem) {
        String[] stringArray = yPosition.split(" ");
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String value;
            switch (value = stringArray[i]) {
                case "top": {
                    position.setPositionY(BackgroundPosition.PositionY.TOP);
                    continue block10;
                }
                case "bottom": {
                    position.setPositionY(BackgroundPosition.PositionY.BOTTOM);
                    continue block10;
                }
                case "center": {
                    position.setPositionY(BackgroundPosition.PositionY.CENTER);
                    continue block10;
                }
                default: {
                    UnitValue unitValue = CssDimensionParsingUtils.parseLengthValueToPt((String)value, (float)em, (float)rem);
                    if (unitValue == null) continue block10;
                    position.setYShift(unitValue);
                }
            }
        }
    }

    private static BackgroundRepeat applyBackgroundRepeat(List<String> backgroundRepeatArray, int iteration) {
        int index = BackgroundApplierUtil.getBackgroundSidePropertyIndex(backgroundRepeatArray.size(), iteration);
        if (index != -1) {
            String[] repeatProps = backgroundRepeatArray.get(index).split(" ");
            if (repeatProps.length == 1) {
                if ("repeat-x".equals(repeatProps[0])) {
                    return new BackgroundRepeat(BackgroundRepeat.BackgroundRepeatValue.REPEAT, BackgroundRepeat.BackgroundRepeatValue.NO_REPEAT);
                }
                if ("repeat-y".equals(repeatProps[0])) {
                    return new BackgroundRepeat(BackgroundRepeat.BackgroundRepeatValue.NO_REPEAT, BackgroundRepeat.BackgroundRepeatValue.REPEAT);
                }
                BackgroundRepeat.BackgroundRepeatValue value = CssBackgroundUtils.parseBackgroundRepeat((String)repeatProps[0]);
                return new BackgroundRepeat(value);
            }
            if (repeatProps.length == 2) {
                return new BackgroundRepeat(CssBackgroundUtils.parseBackgroundRepeat((String)repeatProps[0]), CssBackgroundUtils.parseBackgroundRepeat((String)repeatProps[1]));
            }
        }
        return new BackgroundRepeat();
    }

    private static int getBackgroundSidePropertyIndex(int propertiesNumber, int iteration) {
        if (propertiesNumber > 0) {
            return iteration % propertiesNumber;
        }
        return -1;
    }

    private static void applyBackgroundColor(String backgroundColorStr, IPropertyContainer element, BackgroundBox clip) {
        if (backgroundColorStr != null && !"transparent".equals(backgroundColorStr)) {
            TransparentColor color = CssDimensionParsingUtils.parseColor((String)backgroundColorStr);
            Background backgroundColor = new Background(color.getColor(), color.getOpacity(), clip);
            element.setProperty(6, (Object)backgroundColor);
        }
    }

    private static boolean applyBackgroundImage(PdfXObject image, List<BackgroundImage> backgroundImagesList, BackgroundRepeat repeat, BlendMode backgroundBlendMode, BackgroundPosition position, BackgroundBox clip, BackgroundBox origin) {
        if (image == null) {
            return false;
        }
        if (image instanceof PdfImageXObject) {
            backgroundImagesList.add(new HtmlBackgroundImage((PdfImageXObject)image, repeat, position, backgroundBlendMode, clip, origin));
            return true;
        }
        if (image instanceof SvgImageXObject) {
            SvgImageXObject svgImageXObject = (SvgImageXObject)image;
            UnitValue width = svgImageXObject.getElementWidth();
            boolean isRelativeWidthSvg = width == null || width.isPercentValue();
            UnitValue height = svgImageXObject.getElementHeight();
            boolean isRelativeHeightSvg = height == null || height.isPercentValue();
            backgroundImagesList.add(new HtmlBackgroundImage((PdfFormXObject)image, repeat, position, backgroundBlendMode, clip, origin, isRelativeWidthSvg || isRelativeHeightSvg));
            return true;
        }
        if (image instanceof PdfFormXObject) {
            backgroundImagesList.add(new HtmlBackgroundImage((PdfFormXObject)image, repeat, position, backgroundBlendMode, clip, origin));
            return true;
        }
        throw new IllegalStateException();
    }

    private static boolean applyLinearGradient(String image, List<BackgroundImage> backgroundImagesList, BlendMode blendMode, BackgroundPosition position, float em, float rem, BackgroundRepeat repeat, BackgroundBox clip, BackgroundBox origin) {
        try {
            StrategyBasedLinearGradientBuilder gradientBuilder = CssGradientUtil.parseCssLinearGradient((String)image, (float)em, (float)rem);
            if (gradientBuilder != null) {
                backgroundImagesList.add(new BackgroundImage.Builder().setLinearGradientBuilder((AbstractLinearGradientBuilder)gradientBuilder).setBackgroundBlendMode(blendMode).setBackgroundPosition(position).setBackgroundRepeat(repeat).setBackgroundClip(clip).setBackgroundOrigin(origin).build());
                return true;
            }
        }
        catch (StyledXMLParserException e) {
            LOGGER.warn(MessageFormatUtil.format((String)"Invalid gradient declaration: {0}", (Object[])new Object[]{image}));
        }
        return false;
    }

    private static void applyBackgroundSize(List<List<String>> backgroundProperties, float em, float rem, int imageIndex, BackgroundImage image) {
        if (backgroundProperties == null || backgroundProperties.isEmpty()) {
            return;
        }
        if (!(image.getForm() == null || image.getImageHeight() != 0.0f && image.getImageWidth() != 0.0f || image.getForm() instanceof SvgImageXObject && ((SvgImageXObject)image.getForm()).isRelativeSized())) {
            return;
        }
        List<String> backgroundSizeValues = backgroundProperties.get(BackgroundApplierUtil.getBackgroundSidePropertyIndex(backgroundProperties.size(), imageIndex));
        if (backgroundSizeValues.size() == 2 && "auto".equals(backgroundSizeValues.get(1))) {
            backgroundSizeValues.remove(1);
        }
        if (backgroundSizeValues.size() == 1) {
            String widthValue = backgroundSizeValues.get(0);
            BackgroundApplierUtil.applyBackgroundWidth(widthValue, image, em, rem);
        }
        if (backgroundSizeValues.size() == 2) {
            BackgroundApplierUtil.applyBackgroundWidthHeight(backgroundSizeValues, image, em, rem);
        }
    }

    private static void applyBackgroundWidth(String widthValue, BackgroundImage image, float em, float rem) {
        if (CommonCssConstants.BACKGROUND_SIZE_VALUES.contains(widthValue)) {
            if (widthValue.equals("contain")) {
                image.getBackgroundSize().setBackgroundSizeToContain();
            }
            if (widthValue.equals("cover")) {
                image.getBackgroundSize().setBackgroundSizeToCover();
            }
            return;
        }
        image.getBackgroundSize().setBackgroundSizeToValues(CssDimensionParsingUtils.parseLengthValueToPt((String)widthValue, (float)em, (float)rem), null);
    }

    private static void applyBackgroundWidthHeight(List<String> backgroundSizeValues, BackgroundImage image, float em, float rem) {
        String widthValue = backgroundSizeValues.get(0);
        if (CommonCssConstants.BACKGROUND_SIZE_VALUES.contains(widthValue)) {
            UnitValue height;
            if (widthValue.equals("auto") && (height = CssDimensionParsingUtils.parseLengthValueToPt((String)backgroundSizeValues.get(1), (float)em, (float)rem)) != null) {
                image.getBackgroundSize().setBackgroundSizeToValues(null, height);
            }
            return;
        }
        image.getBackgroundSize().setBackgroundSizeToValues(CssDimensionParsingUtils.parseLengthValueToPt((String)backgroundSizeValues.get(0), (float)em, (float)rem), CssDimensionParsingUtils.parseLengthValueToPt((String)backgroundSizeValues.get(1), (float)em, (float)rem));
    }

    private static class HtmlBackgroundImage
    extends BackgroundImage {
        private static final double PX_TO_PT_MULTIPLIER = 0.75;
        private double dimensionMultiplier = 1.0;
        private boolean isRelativeSizedSvg = false;

        public HtmlBackgroundImage(PdfImageXObject xObject, BackgroundRepeat repeat, BackgroundPosition position, BlendMode blendMode, BackgroundBox clip, BackgroundBox origin) {
            super(new BackgroundImage.Builder().setImage((PdfXObject)xObject).setBackgroundRepeat(repeat).setBackgroundPosition(position).setBackgroundBlendMode(blendMode).setBackgroundClip(clip).setBackgroundOrigin(origin).build());
            this.dimensionMultiplier = 0.75;
        }

        public HtmlBackgroundImage(PdfFormXObject xObject, BackgroundRepeat repeat, BackgroundPosition position, BlendMode blendMode, BackgroundBox clip, BackgroundBox origin) {
            super(new BackgroundImage.Builder().setImage((PdfXObject)xObject).setBackgroundRepeat(repeat).setBackgroundPosition(position).setBackgroundBlendMode(blendMode).setBackgroundClip(clip).setBackgroundOrigin(origin).build());
        }

        public HtmlBackgroundImage(PdfFormXObject xObject, BackgroundRepeat repeat, BackgroundPosition position, BlendMode blendMode, BackgroundBox clip, BackgroundBox origin, boolean isRelativeSizedSvg) {
            super(new BackgroundImage.Builder().setImage((PdfXObject)xObject).setBackgroundRepeat(repeat).setBackgroundPosition(position).setBackgroundBlendMode(blendMode).setBackgroundClip(clip).setBackgroundOrigin(origin).build());
            this.isRelativeSizedSvg = isRelativeSizedSvg;
        }

        protected float[] resolveWidthAndHeight(Float width, Float height, float areaWidth, float areaHeight) {
            if (!this.isRelativeSizedSvg) {
                return super.resolveWidthAndHeight(width, height, areaWidth, areaHeight);
            }
            SvgImageXObject svgImageXObject = (SvgImageXObject)this.image;
            ISvgNodeRenderer svgRootRenderer = svgImageXObject.getResult().getRootRenderer();
            Float aspectRatio = null;
            boolean isAspectRatioNone = false;
            float[] viewBoxValues = SvgCssUtils.parseViewBox((ISvgNodeRenderer)svgRootRenderer);
            String preserveAspectRatio = svgRootRenderer.getAttribute("preserveAspectRatio");
            if ("none".equals(preserveAspectRatio)) {
                isAspectRatioNone = true;
            } else if (viewBoxValues != null && viewBoxValues.length == 4) {
                aspectRatio = Float.valueOf(viewBoxValues[2] / viewBoxValues[3]);
            }
            Float finalWidth = null;
            Float finalHeight = null;
            if (this.getBackgroundSize().isSpecificSize()) {
                if (aspectRatio == null) {
                    finalWidth = Float.valueOf(areaWidth);
                    finalHeight = Float.valueOf(areaHeight);
                } else if (this.getBackgroundSize().isCover()) {
                    if (aspectRatio.floatValue() < areaWidth / areaHeight) {
                        finalWidth = Float.valueOf(areaWidth);
                        finalHeight = Float.valueOf(finalWidth.floatValue() / aspectRatio.floatValue());
                    } else {
                        finalHeight = Float.valueOf(areaHeight);
                        finalWidth = Float.valueOf(finalHeight.floatValue() * aspectRatio.floatValue());
                    }
                } else if (aspectRatio.floatValue() > areaWidth / areaHeight) {
                    finalWidth = Float.valueOf(areaWidth);
                    finalHeight = Float.valueOf(finalWidth.floatValue() / aspectRatio.floatValue());
                } else {
                    finalHeight = Float.valueOf(areaHeight);
                    finalWidth = Float.valueOf(finalHeight.floatValue() * aspectRatio.floatValue());
                }
            } else {
                UnitValue svgWidthUV = svgImageXObject.getElementWidth();
                UnitValue svgHeightUV = svgImageXObject.getElementHeight();
                if (width != null) {
                    finalWidth = width;
                } else if (svgWidthUV != null && svgWidthUV.isPointValue()) {
                    finalWidth = Float.valueOf(svgWidthUV.getValue());
                }
                if (height != null) {
                    finalHeight = height;
                } else if (svgHeightUV != null && svgHeightUV.isPointValue()) {
                    finalHeight = Float.valueOf(svgHeightUV.getValue());
                }
                if (isAspectRatioNone) {
                    if (width == null && finalWidth != null) {
                        finalWidth = Float.valueOf(areaWidth);
                    }
                    if (height == null && finalHeight != null) {
                        finalHeight = Float.valueOf(areaHeight);
                    }
                } else if (aspectRatio != null && (width == null || height == null)) {
                    if (finalWidth == null && finalHeight == null) {
                        if (aspectRatio.floatValue() < areaWidth / areaHeight) {
                            finalHeight = Float.valueOf(areaHeight);
                            finalWidth = Float.valueOf(finalHeight.floatValue() * aspectRatio.floatValue());
                        } else {
                            finalWidth = Float.valueOf(areaWidth);
                            finalHeight = Float.valueOf(finalWidth.floatValue() / aspectRatio.floatValue());
                        }
                    } else if (finalWidth != null && finalHeight != null) {
                        if (aspectRatio.floatValue() < finalWidth.floatValue() / finalHeight.floatValue()) {
                            finalHeight = Float.valueOf(finalWidth.floatValue() / aspectRatio.floatValue());
                        } else {
                            finalWidth = Float.valueOf(finalHeight.floatValue() / aspectRatio.floatValue());
                        }
                    } else if (finalWidth == null) {
                        finalWidth = Float.valueOf(finalHeight.floatValue() * aspectRatio.floatValue());
                    } else {
                        finalHeight = Float.valueOf(finalWidth.floatValue() / aspectRatio.floatValue());
                    }
                }
                if (finalWidth == null) {
                    finalWidth = Float.valueOf(areaWidth);
                }
                if (finalHeight == null) {
                    finalHeight = Float.valueOf(areaHeight);
                }
            }
            if (aspectRatio != null) {
                svgRootRenderer.setAttribute("width", null);
                svgRootRenderer.setAttribute("height", null);
            }
            svgImageXObject.updateBBox(finalWidth.floatValue(), finalHeight.floatValue());
            svgImageXObject.generate(null);
            return new float[]{finalWidth.floatValue(), finalHeight.floatValue()};
        }

        public float getImageWidth() {
            return (float)((double)this.image.getWidth() * this.dimensionMultiplier);
        }

        public float getImageHeight() {
            return (float)((double)this.image.getHeight() * this.dimensionMultiplier);
        }
    }
}

