/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.IStylesContainer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.numbering.AlphabetNumbering;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.List;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.property.IListSymbolFactory;
import com.itextpdf.layout.property.ListNumberingType;
import com.itextpdf.layout.property.ListSymbolPosition;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListStyleApplierUtil {
    private static final int GREEK_ALPHABET_LENGTH = 24;
    private static final char[] GREEK_LOWERCASE = new char[24];
    private static final String DISC_SYMBOL = "\u2022";
    private static final String CIRCLE_SYMBOL = "\u25cb";
    private static final String SQUARE_SYMBOL = "\u25a0";

    private ListStyleApplierUtil() {
    }

    public static void applyListStyleImageProperty(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String listStyleImage = cssProps.get("list-style-image");
        if (listStyleImage != null && !"none".equals(listStyleImage)) {
            String url = CssUtils.extractUrl(listStyleImage);
            PdfImageXObject imageXObject = context.getResourceResolver().retrieveImage(url);
            if (imageXObject != null) {
                element.setProperty(37, (Object)new Image(imageXObject));
                element.setProperty(39, (Object)5);
            }
        }
    }

    public static void applyListStyleTypeProperty(IStylesContainer stylesContainer, Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        float em = CssUtils.parseAbsoluteLength(cssProps.get("font-size"));
        String style = cssProps.get("list-style-type");
        if ("disc".equals(style)) {
            ListStyleApplierUtil.setDiscStyle(element, em);
        } else if ("circle".equals(style)) {
            ListStyleApplierUtil.setCircleStyle(element, em);
        } else if ("square".equals(style)) {
            ListStyleApplierUtil.setSquareStyle(element, em);
        } else if ("decimal".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, ListNumberingType.DECIMAL);
        } else if ("decimal-leading-zero".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, ListNumberingType.DECIMAL_LEADING_ZERO);
        } else if ("upper-alpha".equals(style) || "upper-latin".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, ListNumberingType.ENGLISH_UPPER);
        } else if ("lower-alpha".equals(style) || "lower-latin".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, ListNumberingType.ENGLISH_LOWER);
        } else if ("upper-roman".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, ListNumberingType.ROMAN_UPPER);
        } else if ("lower-roman".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, ListNumberingType.ROMAN_LOWER);
        } else if ("lower-greek".equals(style)) {
            element.setProperty(37, (Object)new HtmlAlphabetSymbolFactory(GREEK_LOWERCASE));
        } else if ("none".equals(style)) {
            ListStyleApplierUtil.setListSymbol(element, new Text(""));
        } else {
            if (style != null) {
                Logger logger = LoggerFactory.getLogger(ListStyleApplierUtil.class);
                logger.error(MessageFormatUtil.format((String)"Not supported list style type: {0}", (Object[])new Object[]{style}));
            }
            if (stylesContainer instanceof IElementNode) {
                String elementName = ((IElementNode)stylesContainer).name();
                if ("ul".equals(elementName)) {
                    ListStyleApplierUtil.setDiscStyle(element, em);
                } else if ("ol".equals(elementName)) {
                    ListStyleApplierUtil.setListSymbol(element, ListNumberingType.DECIMAL);
                }
            }
        }
    }

    public static void setDiscStyle(IPropertyContainer element, float em) {
        Text symbol = new Text(DISC_SYMBOL);
        element.setProperty(37, (Object)symbol);
        ListStyleApplierUtil.setListSymbolIndent(element, em);
    }

    private static void setListSymbol(IPropertyContainer container, Text text) {
        if (container instanceof List) {
            ((List)container).setListSymbol(text);
        } else if (container instanceof ListItem) {
            ((ListItem)container).setListSymbol(text);
        }
    }

    private static void setListSymbol(IPropertyContainer container, ListNumberingType listNumberingType) {
        if (container instanceof List) {
            ((List)container).setListSymbol(listNumberingType);
        } else if (container instanceof ListItem) {
            ((ListItem)container).setListSymbol(listNumberingType);
        }
    }

    private static void setSquareStyle(IPropertyContainer element, float em) {
        Text symbol = new Text(SQUARE_SYMBOL);
        symbol.setTextRise(1.5f * em / 12.0f);
        symbol.setFontSize(4.5f * em / 12.0f);
        element.setProperty(37, (Object)symbol);
        ListStyleApplierUtil.setListSymbolIndent(element, em);
    }

    private static void setCircleStyle(IPropertyContainer element, float em) {
        Text symbol = new Text(CIRCLE_SYMBOL);
        symbol.setTextRise(1.5f * em / 12.0f);
        symbol.setFontSize(4.5f * em / 12.0f);
        element.setProperty(37, (Object)symbol);
        ListStyleApplierUtil.setListSymbolIndent(element, em);
    }

    private static void setListSymbolIndent(IPropertyContainer element, float em) {
        if (ListSymbolPosition.INSIDE == element.getProperty(83)) {
            element.setProperty(39, (Object)Float.valueOf(1.5f * em));
        } else {
            element.setProperty(39, (Object)Float.valueOf(7.75f));
        }
    }

    static {
        for (int i = 0; i < 24; ++i) {
            ListStyleApplierUtil.GREEK_LOWERCASE[i] = (char)(945 + i + (i > 16 ? 1 : 0));
        }
    }

    private static class HtmlAlphabetSymbolFactory
    implements IListSymbolFactory {
        private final char[] alphabet;

        public HtmlAlphabetSymbolFactory(char[] alphabet) {
            this.alphabet = alphabet;
        }

        public IElement createSymbol(int index, IPropertyContainer list, IPropertyContainer listItem) {
            Object preValue = HtmlAlphabetSymbolFactory.getListItemOrListProperty(listItem, list, 41);
            Object postValue = HtmlAlphabetSymbolFactory.getListItemOrListProperty(listItem, list, 42);
            Text result = new Text(preValue + AlphabetNumbering.toAlphabetNumber((int)index, (char[])this.alphabet) + postValue);
            return result;
        }

        private static Object getListItemOrListProperty(IPropertyContainer listItem, IPropertyContainer list, int propertyId) {
            return listItem.hasProperty(propertyId) ? listItem.getProperty(propertyId) : list.getProperty(propertyId);
        }
    }
}

