/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.css.resolve.CssContext;
import com.itextpdf.html2pdf.css.resolve.func.counter.CssCounterManager;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.INode;
import java.util.Map;

public class CounterProcessorUtil {
    public static void processCounters(Map<String, String> cssProps, CssContext context, INode scope) {
        String counterIncrement;
        String counterReset = cssProps.get("counter-reset");
        if (counterReset != null) {
            CssCounterManager counterManager = context.getCounterManager();
            String[] params = counterReset.split(" ");
            for (int i = 0; i < params.length; ++i) {
                Integer possibleCounterValue;
                String counterName = params[i];
                if (i + 1 < params.length && (possibleCounterValue = CssUtils.parseInteger(params[i + 1])) != null) {
                    counterManager.resetCounter(counterName, possibleCounterValue, scope);
                    ++i;
                    continue;
                }
                counterManager.resetCounter(counterName, scope);
            }
        }
        if ((counterIncrement = cssProps.get("counter-increment")) != null) {
            CssCounterManager counterManager = context.getCounterManager();
            String[] params = counterIncrement.split(" ");
            for (int i = 0; i < params.length; ++i) {
                Integer possibleIncrementValue;
                String counterName = params[i];
                if (i + 1 < params.length && (possibleIncrementValue = CssUtils.parseInteger(params[i + 1])) != null) {
                    counterManager.incrementCounter(counterName, possibleIncrementValue, scope);
                    ++i;
                    continue;
                }
                counterManager.incrementCounter(counterName, scope);
            }
        }
    }
}

