/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class PageKit {
    protected Map<String, String> cache = null;

    public PageKit() {
        WeakHashMap tempMap = new WeakHashMap();
        this.cache = Collections.synchronizedMap(tempMap);
    }

    public String getCountSql(String dbName, String selectSql) {
        String countSql = null;
        try {
            PlainSelect plain;
            countSql = this.cache.get(selectSql);
            if (countSql != null) {
                return countSql;
            }
            Select select = (Select)CCJSqlParserUtil.parse((String)selectSql, parser -> {
                CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(true);
            });
            if (select.getSelectBody() instanceof PlainSelect && (plain = (PlainSelect)select.getSelectBody()).getFromItem() != null && plain.getSelectItems().stream().allMatch(item -> item instanceof SelectExpressionItem && ((SelectExpressionItem)item).getExpression() instanceof Column) && plain.getDistinct() == null && plain.getGroupBy() == null && plain.getLimit() == null) {
                plain.setSelectItems(Arrays.asList(new SelectItem[]{new CountAll()}));
                plain.setOrderByElements(null);
                countSql = plain.toString();
                this.cache.put(selectSql, countSql);
                return countSql;
            }
        }
        catch (JSQLParserException jSQLParserException) {
            // empty catch block
        }
        countSql = this.buildDefaultSql(selectSql);
        return countSql;
    }

    protected String buildDefaultSql(String selectSql) {
        String defaultCountSql = "SELECT COUNT(*) FROM ( " + selectSql + " ) a";
        this.cache.put(selectSql, defaultCountSql);
        return defaultCountSql;
    }

    public static void main(String[] args) throws JSQLParserException {
        String sql = "SELECT CONVERT(1 USING gbk)";
        PageKit pageKit = new PageKit();
        long start = System.currentTimeMillis();
        String countSql = null;
        for (int i = 0; i < 1; ++i) {
            countSql = pageKit.getCountSql("xxx", sql);
        }
        System.out.println(System.currentTimeMillis() - start);
        System.out.println(countSql);
    }

    public static class CountAll
    extends AllColumns {
        public String toString() {
            return "count(*)";
        }
    }
}

