/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.GroupTemplate;
import org.beetl.core.fun.MethodInvoker;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.Cache;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.DefaultCache;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.clazz.kit.NumberKit;
import org.beetl.sql.clazz.kit.StringKit;

public class BeanKit {
    public static boolean queryLambdasSupport = JavaType.isJdk8();
    private static final Map<Class, Method> tailBeans = new ConcurrentHashMap<Class, Method>();
    private static Method NULL = null;
    public static String[] EMP_STRING_ARRAY = new String[0];
    public static Object[] EMP_OBJECT_ARRAY = new Object[0];
    static ClassLoader classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : GroupTemplate.class.getClassLoader();
    public static Cache classInsCache;

    public static PropertyDescriptor[] propertyDescriptors(Class<?> c) throws IntrospectionException {
        BeanInfo beanInfo = null;
        beanInfo = Introspector.getBeanInfo(c);
        return beanInfo.getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class c, String attr) {
        try {
            PropertyDescriptor[] ps;
            for (PropertyDescriptor p : ps = BeanKit.propertyDescriptors(c)) {
                if (!p.getName().equals(attr)) continue;
                return p;
            }
            return null;
        }
        catch (IntrospectionException ex) {
            throw new IllegalStateException("\u671f\u671b " + c + "\u9075\u5faaBean\u89c4\u8303\uff0c\u4e0d\u80fd\u83b7\u53d6\u5c5e\u6027 " + attr + " \u5b9a\u4e49");
        }
    }

    public static Map getMapIns(Class cls) {
        if (cls == Map.class) {
            return new CaseInsensitiveHashMap();
        }
        try {
            return (Map)cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List getListIns(Class list) {
        if (list == List.class) {
            return new ArrayList();
        }
        try {
            return (List)list.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getBeanProperty(Object o, String attrName) {
        try {
            MethodInvoker inv = ObjectUtil.getInvokder(o.getClass(), (String)attrName);
            return inv.get(o);
        }
        catch (Exception ex) {
            throw new RuntimeException("POJO\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519:" + attrName, ex);
        }
    }

    public static void setBeanProperty(Object o, Object value, String attrName) {
        MethodInvoker inv = ObjectUtil.getInvokder(o.getClass(), (String)attrName);
        if (inv == null) {
            throw new IllegalArgumentException("\u672a\u80fd\u627e\u5230\u5bf9\u8c61" + o.getClass() + "\u7684\u5c5e\u6027");
        }
        inv.set(o, value);
    }

    public static void setBeanPropertyWithCast(Object o, Object value, String attrName) {
        if (value == null) {
            return;
        }
        MethodInvoker inv = ObjectUtil.getInvokder(o.getClass(), (String)attrName);
        Class type = inv.getReturnType();
        Class<?> valueType = value.getClass();
        Object requiredValue = BeanKit.convertValueToRequiredType(value, type);
        inv.set(o, requiredValue);
    }

    public static Object convertValueToRequiredType(Object result, Class<?> requiredType) {
        if (result == null) {
            return null;
        }
        Class<?> type = result.getClass();
        if (type == result) {
            return result;
        }
        if (String.class == requiredType) {
            return result.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (result instanceof Number) {
                return NumberKit.convertNumberToTargetClass((Number)result, requiredType);
            }
            return NumberKit.parseNumber(result.toString(), requiredType);
        }
        if (requiredType.isPrimitive() && result instanceof Number) {
            return NumberKit.convertNumberToTargetClass((Number)result, requiredType);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u5316\u6210\u671f\u671b\u7c7b\u578b:" + requiredType);
    }

    public static <T extends Annotation> T getAnnotation(Class c, Class<T> expect) {
        do {
            T an;
            if ((an = c.getAnnotation(expect)) == null) continue;
            return an;
        } while ((c = c.getSuperclass()) != null && c != Object.class);
        return null;
    }

    public static <T> T newInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new BeetlSQLException(9, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BeetlSQLException(9, (Throwable)e);
        }
    }

    public static Collection newCollectionInstance(Class c) {
        if (c.isInterface()) {
            if (c.isAssignableFrom(List.class)) {
                return new ArrayList();
            }
            if (c.isAssignableFrom(Set.class)) {
                return new HashSet();
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b " + c);
        }
        return (Collection)BeanKit.newInstance(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newSingleInstance(Class<T> c) {
        Class<T> clazz = c;
        synchronized (clazz) {
            Object ins = classInsCache.get(c);
            if (ins != null) {
                return (T)ins;
            }
            ins = BeanKit.newInstance(c);
            classInsCache.put(c, ins);
            return (T)ins;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class c, String property, Method getter, Class<T> annotationClass) {
        if (getter == null) {
            throw new NullPointerException("\u671f\u671bPOJO\u7c7b\u7b26\u5408javabean\u89c4\u8303\uff0c" + c + " \u6ca1\u6709getter\u65b9\u6cd5");
        }
        T t = getter.getAnnotation(annotationClass);
        if (t != null) {
            return t;
        }
        try {
            while (c != null) {
                Field[] fs;
                for (Field f : fs = c.getDeclaredFields()) {
                    if (!f.getName().equals(property)) continue;
                    t = f.getAnnotation(annotationClass);
                    return t;
                }
                c = c.getSuperclass();
            }
            return t;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class c, String property, Class<T> annotationClass) {
        MethodInvoker invoker = ObjectUtil.getInvokder((Class)c, (String)property);
        if (invoker == null) {
            return null;
        }
        Method getter = invoker.getMethod();
        return BeanKit.getAnnotation(c, property, getter, annotationClass);
    }

    public static List<Annotation> getAllAnnotation(Class c, String property) {
        MethodInvoker invoker = ObjectUtil.getInvokder((Class)c, (String)property);
        if (invoker == null) {
            return null;
        }
        Method getter = invoker.getMethod();
        Annotation[] array1 = getter.getAnnotations();
        Annotation[] array2 = null;
        Field f = BeanKit.getField(c, property);
        if (f != null) {
            array2 = f.getAnnotations();
        }
        return BeanKit.addAnnotation(array1, array2);
    }

    public static Field getField(Class c, String property) {
        Field field = null;
        if (c != null) {
            try {
                field = c.getDeclaredField(property);
            }
            catch (Exception e) {
                field = BeanKit.getField(c.getSuperclass(), property);
            }
        }
        return field;
    }

    public static Method getWriteMethod(PropertyDescriptor prop, Class<?> type) {
        Method writeMethod = prop.getWriteMethod();
        if (writeMethod == null && !"class".equals(prop.getName())) {
            String propName = prop.getName();
            String setMethodName = "set" + (propName.length() > 1 && propName.charAt(1) >= 'A' && propName.charAt(1) <= 'Z' ? propName : StringKit.toUpperCaseFirstOne(propName));
            try {
                writeMethod = type.getMethod(setMethodName, prop.getPropertyType());
            }
            catch (Exception e) {
                return null;
            }
        }
        return writeMethod;
    }

    public static boolean isJavaClass(Class entityClass) {
        Package pck = entityClass.getPackage();
        if (pck == null) {
            return false;
        }
        String pkgName = entityClass.getPackage().getName();
        return pkgName.startsWith("java");
    }

    public static boolean isBaseDataType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java")) {
            return clazz == String.class || clazz == Integer.class || clazz == Byte.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Boolean.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == LocalDateTime.class || clazz == LocalDate.class;
        }
        return false;
    }

    private static List<Annotation> addAnnotation(Annotation[] array1, Annotation[] array2) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        if (array1 != null) {
            list.addAll(Arrays.asList(array1));
        }
        if (array2 != null) {
            list.addAll(Arrays.asList(array2));
        }
        return list;
    }

    public static boolean containViewType(Class[] cls, Class viewType) {
        if (cls.length == 1) {
            return cls[0] == viewType;
        }
        if (cls.length == 2) {
            return cls[0] == viewType || cls[1] == viewType;
        }
        for (Class z : cls) {
            if (z != viewType) continue;
            return true;
        }
        return false;
    }

    public static Class getCollectionType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Class paraType = BeanKit.getParameterTypeClass(type);
        return paraType;
    }

    public static Class[] getMapType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Class[] paraType = BeanKit.getMapParameterTypeClass(type);
        return paraType;
    }

    public static Class getParameterTypeClass(Type t) {
        if (t instanceof WildcardType || t instanceof TypeVariable) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)t).getActualTypeArguments();
            if (types.length == 0) {
                return null;
            }
            Type type = types[0];
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)types[0];
            }
            throw new UnsupportedOperationException(type.toString());
        }
        throw new UnsupportedOperationException(t.toString());
    }

    public static Class[] getMapParameterTypeClass(Type t) {
        if (t instanceof WildcardType || t instanceof TypeVariable) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)t).getActualTypeArguments();
            if (types.length == 0) {
                return null;
            }
            Class[] classTypes = new Class[2];
            Type type = types[0];
            if (type instanceof ParameterizedType) {
                classTypes[0] = (Class)((ParameterizedType)type).getRawType();
            } else if (type instanceof Class) {
                classTypes[0] = (Class)types[0];
            } else {
                throw new UnsupportedOperationException(type.toString());
            }
            Type type1 = types[1];
            if (type1 instanceof ParameterizedType) {
                classTypes[1] = (Class)((ParameterizedType)type1).getRawType();
            } else if (type1 instanceof Class) {
                classTypes[1] = (Class)types[1];
            } else {
                throw new UnsupportedOperationException(type.toString());
            }
            return classTypes;
        }
        throw new UnsupportedOperationException(t.toString());
    }

    public static Class getMapperEntity(Class mapperInterface) {
        ParameterizedType pt;
        Type[] faces;
        if (mapperInterface.isInterface() && (faces = mapperInterface.getGenericInterfaces()).length > 0 && faces[0] instanceof ParameterizedType && (pt = (ParameterizedType)faces[0]).getActualTypeArguments().length > 0) {
            Class entityClass = (Class)pt.getActualTypeArguments()[0];
            return entityClass;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        Class<User> c = User.class;
        Method m = c.getMethod("getMaps", new Class[0]);
        Type type = m.getGenericReturnType();
        Class[] tt = BeanKit.getMapParameterTypeClass(type);
        System.out.println(tt);
    }

    static {
        try {
            NULL = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        classInsCache = new DefaultCache();
    }

    public static class User {
        Map<String, Integer> maps = null;

        public Map<String, Integer> getMaps() {
            return this.maps;
        }

        public void setMaps(Map<String, Integer> maps) {
            this.maps = maps;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Integer> this$maps = this.getMaps();
            Map<String, Integer> other$maps = other.getMaps();
            return !(this$maps == null ? other$maps != null : !((Object)this$maps).equals(other$maps));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Integer> $maps = this.getMaps();
            result = result * 59 + ($maps == null ? 43 : ((Object)$maps).hashCode());
            return result;
        }

        public String toString() {
            return "BeanKit.User(maps=" + this.getMaps() + ")";
        }
    }
}

