/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.Cache;
import org.beetl.sql.clazz.kit.DefaultCache;

public class EnumKit {
    private static Cache<Class, EnumConfig> cache = new DefaultCache<Class, EnumConfig>();

    public static Enum getEnumByValue(Class c, Object value) {
        if (value == null) {
            return null;
        }
        if (!c.isEnum()) {
            throw new IllegalArgumentException(c.getName());
        }
        EnumConfig config = cache.get(c);
        if (config == null) {
            throw new IllegalStateException("\u679a\u4e3e\u6ca1\u6709\u521d\u59cb\u5316");
        }
        if (Short.class == value.getClass()) {
            value = ((Short)value).intValue();
        }
        return config.map.get(value);
    }

    public static Object getValueByEnum(Object en) {
        if (en == null) {
            return null;
        }
        Class<?> c = en.getClass();
        EnumConfig config = cache.get(c);
        if (config == null) {
            throw new IllegalStateException("\u679a\u4e3e\u6ca1\u6709\u521d\u59cb\u5316");
        }
        return config.dbMap.get(en);
    }

    public static void initNoAnotation(Class c) {
        Enum[] temporaryConstants;
        if (cache.get(c) != null) {
            return;
        }
        HashMap<Object, Enum> map = new HashMap<Object, Enum>();
        HashMap<Enum, Object> map2 = new HashMap<Enum, Object>();
        for (Enum e : temporaryConstants = EnumKit.getEnumValues(c)) {
            String key = e.name();
            map.put(key, e);
            map2.put(e, key);
        }
        EnumConfig config = new EnumConfig(map, map2);
        cache.put(c, config);
    }

    public static void init(Class entityClass, PropertyDescriptor p) {
        try {
            Enum[] temporaryConstants;
            Method m = p.getReadMethod();
            HashMap<Object, Enum> map = new HashMap<Object, Enum>();
            HashMap<Enum, Object> map2 = new HashMap<Enum, Object>();
            for (Enum e : temporaryConstants = EnumKit.getEnumValues(entityClass)) {
                Object key = m.invoke((Object)e, new Object[0]);
                map.put(key, e);
                map2.put(e, key);
            }
            EnumConfig config = new EnumConfig(map, map2);
            cache.put(entityClass, config);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void init(Class entityClass, String attr) {
        if (cache.get(entityClass) != null) {
            return;
        }
        try {
            PropertyDescriptor[] ps;
            for (PropertyDescriptor p : ps = BeanKit.propertyDescriptors(entityClass)) {
                if (!p.getName().equals(attr)) continue;
                EnumKit.init(entityClass, p);
                break;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Enum[] getEnumValues(Class c) {
        try {
            final Method values = c.getMethod("values", new Class[0]);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    values.setAccessible(true);
                    return null;
                }
            });
            Enum[] temporaryConstants = (Enum[])values.invoke(null, new Object[0]);
            return temporaryConstants;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Color c = Color.RED;
        Object value = EnumKit.getValueByEnum((Object)c);
        System.out.println(value);
        String a = "BLUE";
        Color e = (Color)EnumKit.getEnumByValue(Color.class, 1);
        System.out.println((Object)e);
    }

    public static enum Color {
        RED("RED", 1),
        BLUE("BLUE", 2);

        private String name;
        private int value;

        private Color(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class EnumConfig {
        Map<Object, Enum> map = new HashMap<Object, Enum>();
        Map<Enum, Object> dbMap = new HashMap<Enum, Object>();

        public EnumConfig(Map<Object, Enum> map, Map<Enum, Object> dbMap) {
            this.map = map;
            this.dbMap = dbMap;
        }
    }
}

