/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class StringKit {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    static String lineSeparator = System.getProperty("line.separator", "\n");

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String enCodeUnderlined(String s) {
        char[] chars = StringKit.toLowerCaseFirstOne(s).toCharArray();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isUpperCase(chars[i])) {
                temp.append("_");
            }
            temp.append(Character.toLowerCase(chars[i]));
        }
        return temp.toString();
    }

    public static String deCodeUnderlined(String str) {
        String[] splitArr = str.split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splitArr.length; ++i) {
            if (i == 0) {
                sb.append(splitArr[0].toLowerCase());
                continue;
            }
            sb.append(StringKit.toUpperCaseFirstOne(splitArr[i].toLowerCase()));
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringKit.isEmpty(str) || StringKit.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static boolean isNotBlank(String str) {
        return !StringKit.isBlank(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static String substringAfter(String str, String separator) {
        if (StringKit.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        return false;
    }

    public static boolean isNullOrEmptyObject(Object obj) {
        Object[] object;
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return obj instanceof Object[] && (object = (Object[])obj).length == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static CharSequence trim(CharSequence cs) {
        int st;
        int len = cs.length();
        for (st = 0; st < len && cs.charAt(st) <= ' '; ++st) {
        }
        while (st < len && cs.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < cs.length() ? cs.subSequence(st, len) : cs;
    }

    public static String[] split(String str, char separatorChar) {
        return StringKit.splitWorker(str, separatorChar, false);
    }

    public static String beforeLast(String str, char separatorChar) {
        int pos = str.lastIndexOf(separatorChar);
        return pos == -1 ? EMPTY : str.substring(0, pos);
    }

    public static String join(String[] strs, int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i <= end; ++i) {
            sb.append(strs[i]).append(".");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String addEscape(String name, char escape) {
        return StringKit.addEscape(name, escape, escape);
    }

    public static String addEscape(String name, char leftEscape, char rightEscape) {
        int index = name.indexOf(46);
        if (index == -1) {
            return new StringBuilder(name.length() + 2).append(leftEscape).append(name).append(rightEscape).toString();
        }
        String schema = name.substring(0, index);
        String table = name.substring(index + 1);
        StringBuilder sb = new StringBuilder(name.length() + 4);
        sb.append(leftEscape).append(schema).append(rightEscape).append('.').append(leftEscape).append(table).append(rightEscape);
        return sb.toString();
    }

    public static String toAttributeNameLowCase(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                sb.append((char)(c - 26));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(StringKit.addEscape("abc", '[', ']'));
        System.out.println(StringKit.addEscape("abc.eft", '[', ']'));
    }
}

