/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz.kit;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;

public class ThreadSafeCaseInsensitiveHashMap
extends CaseInsensitiveHashMap {
    private static final long serialVersionUID = 9178606903603606032L;
    final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Object get(Object key) {
        this.r.lock();
        try {
            Object object = super.get(key);
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value) {
        this.w.lock();
        try {
            Object object = super.put(key, value);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void putAll(Map m) {
        this.w.lock();
        try {
            super.putAll(m);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public Object remove(Object key) {
        this.w.lock();
        try {
            Object object = super.remove(key);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }
}

