/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.starter;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.starter.BeetlSqlBeanRegister;
import org.beetl.sql.starter.BeetlSqlConfig;
import org.beetl.sql.starter.SQLManagerCustomize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@Import(value={BeetlSqlBeanRegister.class})
public class BeetlSqlStater {
    @Autowired(required=false)
    SQLManagerCustomize cust;
    @Autowired
    ApplicationContext context;
    @Autowired
    Environment env;

    @PostConstruct
    public void init() {
        if (this.cust == null) {
            return;
        }
        BeetlSqlConfig beetlSqlConfig = new BeetlSqlConfig(this.env);
        beetlSqlConfig.configs.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            SQLManager sqlManager = (SQLManager)this.context.getBean(name, SQLManager.class);
            this.cust.customize(name, sqlManager);
        });
    }
}

