/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.starter;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.loader.MarkdownClasspathLoader;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.ext.spring.BeetlSqlClassPathScanner;
import org.beetl.sql.ext.spring.SqlManagerFactoryBean;
import org.beetl.sql.starter.BeetlSqlConfig;
import org.beetl.sql.starter.ConnectionSourceFactory;
import org.beetl.sql.starter.DynamicSqlManagerFactoryBean4Sb;
import org.beetl.sql.starter.ThreadLocalSqlManagerFactoryBean4Sb;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

public class BeetlSqlBeanRegister
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    Environment env;
    BeetlSqlConfig beetlSqlConfig;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.beetlSqlConfig = new BeetlSqlConfig(this.env);
        this.readySqlManager(registry);
    }

    protected BeanDefinitionBuilder registerBeetlSqlSource(String name, BeetlSqlConfig.SQLManagerConfig config) {
        String sourceConfig = config.getDs();
        String[] sources = sourceConfig.split(",");
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition(ConnectionSourceFactory.class);
        bdb.addPropertyValue("masterSource", (Object)sources[0]);
        if (sources.length == 1) {
            return bdb;
        }
        String[] slaves = new String[sources.length - 1];
        for (int i = 1; i < sources.length; ++i) {
            slaves[i - 1] = sources[i];
        }
        bdb.addPropertyValue("slaveSource", (Object)slaves);
        return bdb;
    }

    protected void readySqlManager(BeanDefinitionRegistry registry) {
        ClassLoader classLoader = this.getClassLoader();
        Map<String, BeetlSqlConfig.SQLManagerConfig> configs = this.beetlSqlConfig.getConfigs();
        configs.entrySet().forEach(entry -> {
            String sqlManagerName = (String)entry.getKey();
            BeetlSqlConfig.SQLManagerConfig config = (BeetlSqlConfig.SQLManagerConfig)entry.getValue();
            if (config.dynamicCondition != null) {
                this.registerDynamicSQLManager(registry, sqlManagerName, config, classLoader);
            } else if (config.threadlocal != null) {
                this.registerThreadLocalSQLManager(registry, sqlManagerName, config, classLoader);
            } else {
                this.registerSQLManager(registry, sqlManagerName, config, classLoader, true);
            }
        });
    }

    protected void registerDynamicSQLManager(BeanDefinitionRegistry registry, String name, BeetlSqlConfig.SQLManagerConfig config, ClassLoader classLoader) {
        String[] sqlManagers = config.dynamicSqlManager.split(",");
        BeetlSqlConfig.SQLManagerConfig defaultSQLManagerConfig = BeetlSqlConfig.SQLManagerConfig.initDefault(this.env);
        ArrayList<String> managersList = new ArrayList<String>();
        for (String sqlManager : sqlManagers) {
            BeetlSqlConfig.SQLManagerConfig sqlManagerConfig = new BeetlSqlConfig.SQLManagerConfig(this.env, sqlManager, defaultSQLManagerConfig);
            this.registerSQLManager(registry, sqlManager, sqlManagerConfig, classLoader, false);
            managersList.add(sqlManager);
        }
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition(DynamicSqlManagerFactoryBean4Sb.class);
        bdb.addPropertyValue("all", managersList);
        bdb.addPropertyValue("defaultSQLManager", managersList.get(0));
        bdb.addPropertyValue("conditional", (Object)config.dynamicCondition);
        bdb.addPropertyValue("name", (Object)name);
        registry.registerBeanDefinition(name, (BeanDefinition)bdb.getBeanDefinition());
        BeetlSqlClassPathScanner scanner = new BeetlSqlClassPathScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        scanner.setSqlManagerFactoryBeanName(name);
        scanner.setSuffix(config.getDaoSuffix());
        scanner.registerFilters();
        scanner.scan(config.getBasePackage().split(","));
    }

    protected void registerThreadLocalSQLManager(BeanDefinitionRegistry registry, String name, BeetlSqlConfig.SQLManagerConfig config, ClassLoader classLoader) {
        String[] sqlManagers = config.threadlocal.split(",");
        BeetlSqlConfig.SQLManagerConfig defaultSQLManagerConfig = BeetlSqlConfig.SQLManagerConfig.initDefault(this.env);
        ArrayList<String> managersList = new ArrayList<String>();
        for (String sqlManager : sqlManagers) {
            BeetlSqlConfig.SQLManagerConfig sqlManagerConfig = new BeetlSqlConfig.SQLManagerConfig(this.env, sqlManager, defaultSQLManagerConfig);
            this.registerSQLManager(registry, sqlManager, sqlManagerConfig, classLoader, false);
            managersList.add(sqlManager);
        }
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition(ThreadLocalSqlManagerFactoryBean4Sb.class);
        bdb.addPropertyValue("all", managersList);
        bdb.addPropertyValue("name", (Object)name);
        registry.registerBeanDefinition(name, (BeanDefinition)bdb.getBeanDefinition());
        BeetlSqlClassPathScanner scanner = new BeetlSqlClassPathScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        scanner.setSqlManagerFactoryBeanName(name);
        scanner.setSuffix(config.getDaoSuffix());
        scanner.registerFilters();
        scanner.scan(config.getBasePackage().split(","));
    }

    protected ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    protected BeanDefinitionBuilder registerSQLManager(BeanDefinitionRegistry registry, String name, BeetlSqlConfig.SQLManagerConfig config, ClassLoader classLoader, boolean scan) {
        MarkdownClasspathLoader loader = new MarkdownClasspathLoader(config.getSqlPath(), config.getSqlFileCharset());
        BeanDefinitionBuilder sqlSourceBuilder = this.registerBeetlSqlSource(name, config);
        registry.registerBeanDefinition(name + "BeetlSqlDataSourceBean", (BeanDefinition)sqlSourceBuilder.getBeanDefinition());
        Properties ps = new Properties();
        ps.put("PRODUCT_MODE", config.dev ? "false" : "true");
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition(SqlManagerFactoryBean.class);
        bdb.addPropertyValue("cs", (Object)new RuntimeBeanReference(name + "BeetlSqlDataSourceBean"));
        bdb.addPropertyValue("dbStyle", (Object)((DBStyle)ObjectUtil.tryInstance((String)config.getDbStyle(), (ClassLoader)classLoader)));
        if (config.getInterceptor() != null) {
            Interceptor interceptor = (Interceptor)ObjectUtil.tryInstance((String)config.getInterceptor(), (ClassLoader)classLoader);
            bdb.addPropertyValue("interceptors", (Object)new Interceptor[]{interceptor});
        } else {
            Interceptor[] interceptorArray;
            if (config.dev) {
                Interceptor[] interceptorArray2 = new Interceptor[1];
                interceptorArray = interceptorArray2;
                interceptorArray2[0] = new DebugInterceptor();
            } else {
                interceptorArray = new Interceptor[]{};
            }
            bdb.addPropertyValue("interceptors", (Object)interceptorArray);
        }
        bdb.addPropertyValue("dev", (Object)config.dev);
        bdb.addPropertyValue("sqlLoader", (Object)loader);
        bdb.addPropertyValue("nc", (Object)((NameConversion)ObjectUtil.tryInstance((String)config.getNameConversion(), (ClassLoader)classLoader)));
        bdb.addPropertyValue("extProperties", (Object)ps);
        bdb.addPropertyValue("name", (Object)name);
        registry.registerBeanDefinition(name, (BeanDefinition)bdb.getBeanDefinition());
        if (!scan) {
            return bdb;
        }
        BeetlSqlClassPathScanner scanner = new BeetlSqlClassPathScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        scanner.setSqlManagerFactoryBeanName(name);
        scanner.setSuffix(config.getDaoSuffix());
        scanner.registerFilters();
        scanner.scan(config.getBasePackage().split(","));
        return bdb;
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }
}

