/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.beetl.core.Function;
import org.beetl.core.tag.TagFactory;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.engine.template.BeetlTemplateEngine;
import org.beetl.sql.core.loader.MarkdownClasspathLoader;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.ext.spring.SQLManagerLifeCycle;
import org.beetl.sql.ext.spring.SpringConnectionSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SqlManagerFactoryBean
implements FactoryBean<SQLManager>,
InitializingBean,
ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    protected Resource configLocation = null;
    protected String defaultSchema = null;
    protected SpringConnectionSource cs;
    protected DBStyle dbStyle;
    protected NameConversion nc;
    protected Interceptor[] interceptors;
    protected String name;
    protected boolean dev;
    protected SQLManager sqlManager;
    protected SQLLoader sqlLoader;
    protected Properties extProperties = new Properties();
    protected Map<String, Function> functions = Collections.emptyMap();
    protected Map<String, TagFactory> tagFactorys = Collections.emptyMap();
    protected Map<String, IDAutoGen> idAutoGens = Collections.emptyMap();
    ApplicationContext applicationContext;
    SQLManagerLifeCycle sqlManagerLifeCycle;

    public void onApplicationEvent(ApplicationEvent event) {
    }

    public SQLManager getObject() throws Exception {
        if (this.sqlManager != null) {
            return this.sqlManager;
        }
        try {
            this.sqlManagerLifeCycle = (SQLManagerLifeCycle)this.applicationContext.getBean(SQLManagerLifeCycle.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.interceptors == null) {
            this.interceptors = new Interceptor[0];
        }
        Properties properties = new Properties();
        if (this.configLocation != null) {
            InputStream in = null;
            try {
                in = this.configLocation.getInputStream();
                properties.load(in);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    in = null;
                }
            }
        }
        properties.putAll((Map<?, ?>)this.extProperties);
        if (this.sqlLoader == null) {
            this.sqlLoader = new MarkdownClasspathLoader("sql");
        }
        SQLManagerBuilder builder = new SQLManagerBuilder((ConnectionSource)this.cs);
        builder.setBeetlPs(properties);
        builder.setNc(this.nc);
        builder.setInters(this.interceptors);
        builder.setDbStyle(this.dbStyle);
        builder.setSqlLoader(this.sqlLoader);
        builder.setProduct(!this.dev);
        if (this.name != null) {
            builder.setName(this.name);
        }
        if (this.sqlManagerLifeCycle != null) {
            this.sqlManagerLifeCycle.customizeBuild(this.name, builder);
        }
        SQLManager tempSQLManager = builder.build();
        BeetlTemplateEngine beetlTemplateEngine = (BeetlTemplateEngine)tempSQLManager.getSqlTemplateEngine();
        for (Map.Entry<String, Function> entry : this.functions.entrySet()) {
            beetlTemplateEngine.getBeetl().getGroupTemplate().registerFunction(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Function> entry : this.tagFactorys.entrySet()) {
            beetlTemplateEngine.getBeetl().getGroupTemplate().registerTagFactory(entry.getKey(), (TagFactory)entry.getValue());
        }
        for (Map.Entry<String, Function> entry : this.idAutoGens.entrySet()) {
            tempSQLManager.addIdAutoGen(entry.getKey(), (IDAutoGen)entry.getValue());
        }
        if (this.sqlManagerLifeCycle != null) {
            this.sqlManagerLifeCycle.customize(this.name, tempSQLManager);
        }
        this.sqlManager = tempSQLManager;
        return this.sqlManager;
    }

    public Class<?> getObjectType() {
        return SQLManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.cs), (String)"'beetlSqlDataSource'\u6570\u636e\u6e90\u662f\u5fc5\u987b\u914d\u7f6e\u7684");
    }

    public void setCs(SpringConnectionSource beetlSqlDataSource) {
        this.cs = beetlSqlDataSource;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
    }

    public void setNc(NameConversion nameConversion) {
        this.nc = nameConversion;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public boolean isDev() {
        return this.dev;
    }

    public void setDev(boolean dev) {
        this.dev = dev;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Resource getConfigLocation() {
        return this.configLocation;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public SpringConnectionSource getCs() {
        return this.cs;
    }

    public DBStyle getDbStyle() {
        return this.dbStyle;
    }

    public NameConversion getNc() {
        return this.nc;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public String getName() {
        return this.name;
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    public SQLLoader getSqlLoader() {
        return this.sqlLoader;
    }

    public Properties getExtProperties() {
        return this.extProperties;
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public Map<String, TagFactory> getTagFactorys() {
        return this.tagFactorys;
    }

    public Map<String, IDAutoGen> getIdAutoGens() {
        return this.idAutoGens;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public SQLManagerLifeCycle getSqlManagerLifeCycle() {
        return this.sqlManagerLifeCycle;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSqlManager(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public void setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
    }

    public void setExtProperties(Properties extProperties) {
        this.extProperties = extProperties;
    }

    public void setFunctions(Map<String, Function> functions) {
        this.functions = functions;
    }

    public void setTagFactorys(Map<String, TagFactory> tagFactorys) {
        this.tagFactorys = tagFactorys;
    }

    public void setIdAutoGens(Map<String, IDAutoGen> idAutoGens) {
        this.idAutoGens = idAutoGens;
    }

    public void setSqlManagerLifeCycle(SQLManagerLifeCycle sqlManagerLifeCycle) {
        this.sqlManagerLifeCycle = sqlManagerLifeCycle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlManagerFactoryBean)) {
            return false;
        }
        SqlManagerFactoryBean other = (SqlManagerFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDev() != other.isDev()) {
            return false;
        }
        Resource this$configLocation = this.getConfigLocation();
        Resource other$configLocation = other.getConfigLocation();
        if (this$configLocation == null ? other$configLocation != null : !this$configLocation.equals(other$configLocation)) {
            return false;
        }
        String this$defaultSchema = this.getDefaultSchema();
        String other$defaultSchema = other.getDefaultSchema();
        if (this$defaultSchema == null ? other$defaultSchema != null : !this$defaultSchema.equals(other$defaultSchema)) {
            return false;
        }
        SpringConnectionSource this$cs = this.getCs();
        SpringConnectionSource other$cs = other.getCs();
        if (this$cs == null ? other$cs != null : !((Object)((Object)this$cs)).equals((Object)other$cs)) {
            return false;
        }
        DBStyle this$dbStyle = this.getDbStyle();
        DBStyle other$dbStyle = other.getDbStyle();
        if (this$dbStyle == null ? other$dbStyle != null : !this$dbStyle.equals(other$dbStyle)) {
            return false;
        }
        NameConversion this$nc = this.getNc();
        NameConversion other$nc = other.getNc();
        if (this$nc == null ? other$nc != null : !this$nc.equals(other$nc)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInterceptors(), other.getInterceptors())) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SQLManager this$sqlManager = this.getSqlManager();
        SQLManager other$sqlManager = other.getSqlManager();
        if (this$sqlManager == null ? other$sqlManager != null : !this$sqlManager.equals(other$sqlManager)) {
            return false;
        }
        SQLLoader this$sqlLoader = this.getSqlLoader();
        SQLLoader other$sqlLoader = other.getSqlLoader();
        if (this$sqlLoader == null ? other$sqlLoader != null : !this$sqlLoader.equals(other$sqlLoader)) {
            return false;
        }
        Properties this$extProperties = this.getExtProperties();
        Properties other$extProperties = other.getExtProperties();
        if (this$extProperties == null ? other$extProperties != null : !((Object)this$extProperties).equals(other$extProperties)) {
            return false;
        }
        Map<String, Function> this$functions = this.getFunctions();
        Map<String, Function> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        Map<String, TagFactory> this$tagFactorys = this.getTagFactorys();
        Map<String, TagFactory> other$tagFactorys = other.getTagFactorys();
        if (this$tagFactorys == null ? other$tagFactorys != null : !((Object)this$tagFactorys).equals(other$tagFactorys)) {
            return false;
        }
        Map<String, IDAutoGen> this$idAutoGens = this.getIdAutoGens();
        Map<String, IDAutoGen> other$idAutoGens = other.getIdAutoGens();
        if (this$idAutoGens == null ? other$idAutoGens != null : !((Object)this$idAutoGens).equals(other$idAutoGens)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        SQLManagerLifeCycle this$sqlManagerLifeCycle = this.getSqlManagerLifeCycle();
        SQLManagerLifeCycle other$sqlManagerLifeCycle = other.getSqlManagerLifeCycle();
        return !(this$sqlManagerLifeCycle == null ? other$sqlManagerLifeCycle != null : !this$sqlManagerLifeCycle.equals(other$sqlManagerLifeCycle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlManagerFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDev() ? 79 : 97);
        Resource $configLocation = this.getConfigLocation();
        result = result * 59 + ($configLocation == null ? 43 : $configLocation.hashCode());
        String $defaultSchema = this.getDefaultSchema();
        result = result * 59 + ($defaultSchema == null ? 43 : $defaultSchema.hashCode());
        SpringConnectionSource $cs = this.getCs();
        result = result * 59 + ($cs == null ? 43 : ((Object)((Object)$cs)).hashCode());
        DBStyle $dbStyle = this.getDbStyle();
        result = result * 59 + ($dbStyle == null ? 43 : $dbStyle.hashCode());
        NameConversion $nc = this.getNc();
        result = result * 59 + ($nc == null ? 43 : $nc.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInterceptors());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SQLManager $sqlManager = this.getSqlManager();
        result = result * 59 + ($sqlManager == null ? 43 : $sqlManager.hashCode());
        SQLLoader $sqlLoader = this.getSqlLoader();
        result = result * 59 + ($sqlLoader == null ? 43 : $sqlLoader.hashCode());
        Properties $extProperties = this.getExtProperties();
        result = result * 59 + ($extProperties == null ? 43 : ((Object)$extProperties).hashCode());
        Map<String, Function> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        Map<String, TagFactory> $tagFactorys = this.getTagFactorys();
        result = result * 59 + ($tagFactorys == null ? 43 : ((Object)$tagFactorys).hashCode());
        Map<String, IDAutoGen> $idAutoGens = this.getIdAutoGens();
        result = result * 59 + ($idAutoGens == null ? 43 : ((Object)$idAutoGens).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        SQLManagerLifeCycle $sqlManagerLifeCycle = this.getSqlManagerLifeCycle();
        result = result * 59 + ($sqlManagerLifeCycle == null ? 43 : $sqlManagerLifeCycle.hashCode());
        return result;
    }

    public String toString() {
        return "SqlManagerFactoryBean(configLocation=" + this.getConfigLocation() + ", defaultSchema=" + this.getDefaultSchema() + ", cs=" + (Object)((Object)this.getCs()) + ", dbStyle=" + this.getDbStyle() + ", nc=" + this.getNc() + ", interceptors=" + Arrays.deepToString(this.getInterceptors()) + ", name=" + this.getName() + ", dev=" + this.isDev() + ", sqlManager=" + this.getSqlManager() + ", sqlLoader=" + this.getSqlLoader() + ", extProperties=" + this.getExtProperties() + ", functions=" + this.getFunctions() + ", tagFactorys=" + this.getTagFactorys() + ", idAutoGens=" + this.getIdAutoGens() + ", applicationContext=" + this.getApplicationContext() + ", sqlManagerLifeCycle=" + this.getSqlManagerLifeCycle() + ")";
    }
}

