/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring;

import org.beetl.sql.core.SQLManager;
import org.beetl.sql.ext.spring.SQLManagerLifeCycle;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.Assert;

public class BeetlSqlMapperFactoryBean<T>
extends DaoSupport
implements FactoryBean<T>,
ApplicationContextAware {
    private Class<T> mapperInterface;
    SQLManager sqlManager;
    String sqlManagerName;
    ApplicationContext applicationContext;

    public BeetlSqlMapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public BeetlSqlMapperFactoryBean() {
    }

    protected void checkDaoConfig() throws IllegalArgumentException {
        Assert.notNull(this.mapperInterface, (String)" 'mapperInterface' \u5c5e\u6027\u662f\u5fc5\u987b\u7684");
    }

    public T getObject() throws Exception {
        SQLManagerLifeCycle sqlManagerLifeCycle = null;
        try {
            sqlManagerLifeCycle = (SQLManagerLifeCycle)this.applicationContext.getBean(SQLManagerLifeCycle.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sqlManagerLifeCycle != null) {
            this.mapperInterface = sqlManagerLifeCycle.beforeMapper(this.sqlManagerName, this.sqlManager, this.mapperInterface);
        }
        return (T)this.sqlManager.getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    public void setSqlManager(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public String getSqlManagerName() {
        return this.sqlManagerName;
    }

    public void setSqlManagerName(String sqlManagerName) {
        this.sqlManagerName = sqlManagerName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

