/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.beetl.sql.annotation.builder.Builder;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.PropertiesKit;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.mapping.StreamData;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.annotation.AutoMapper;
import org.beetl.sql.mapper.annotation.BatchUpdate;
import org.beetl.sql.mapper.annotation.Select;
import org.beetl.sql.mapper.annotation.Sql;
import org.beetl.sql.mapper.annotation.SqlResource;
import org.beetl.sql.mapper.annotation.Template;
import org.beetl.sql.mapper.annotation.Update;
import org.beetl.sql.mapper.builder.MapperExtBuilder;
import org.beetl.sql.mapper.builder.MethodParamsHolder;
import org.beetl.sql.mapper.builder.ParameterParser;
import org.beetl.sql.mapper.builder.ReturnTypeParser;
import org.beetl.sql.mapper.identity.BatchUpdateRMI;
import org.beetl.sql.mapper.identity.PageRMI;
import org.beetl.sql.mapper.identity.SelectRMI;
import org.beetl.sql.mapper.identity.UpdateRMI;
import org.beetl.sql.mapper.ready.BatchSqlReadyMI;
import org.beetl.sql.mapper.ready.PageSqlReadyMI;
import org.beetl.sql.mapper.ready.SelectSqlReadyMI;
import org.beetl.sql.mapper.ready.UpdateSqlReadyMI;
import org.beetl.sql.mapper.stream.StreamSqlIdMI;
import org.beetl.sql.mapper.stream.StreamSqlReadyMI;
import org.beetl.sql.mapper.stream.StreamTemplateSqlMI;
import org.beetl.sql.mapper.template.BatchUpdateTemplateMI;
import org.beetl.sql.mapper.template.PageTemplateMI;
import org.beetl.sql.mapper.template.SelectTemplateMI;
import org.beetl.sql.mapper.template.UpdateTemplateMI;

public class MapperMethodParser {
    protected Class defaultRetType;
    protected Method method = null;
    protected Class mapperClass = null;
    protected int preferredSqlLen = -1;

    public MapperMethodParser(Class defaultRetType, Class mapperClass, Method method) {
        this.defaultRetType = defaultRetType;
        this.mapperClass = mapperClass;
        this.method = method;
        this.preferredSqlLen = PropertiesKit.getInstance().getIntValue("MAPPER_SQL_MAX_LENGTH", "-1");
    }

    public MapperInvoke parse() {
        AutoMapper autoMapper = this.method.getAnnotation(AutoMapper.class);
        if (autoMapper != null) {
            MapperInvoke invoke = (MapperInvoke)BeanKit.newSingleInstance(autoMapper.value());
            return invoke;
        }
        if (StreamData.class.isAssignableFrom(this.method.getReturnType())) {
            MapperInvoke invoke = this.parseStreamMethod();
            return invoke;
        }
        Sql sqlAnnotation = this.method.getAnnotation(Sql.class);
        if (sqlAnnotation != null) {
            MapperInvoke invoke = this.parseSqlMethod(sqlAnnotation);
            return invoke;
        }
        Template templateAnnotation = this.method.getAnnotation(Template.class);
        if (templateAnnotation != null) {
            MapperInvoke invoke = this.parseSqlTemplateMethod(templateAnnotation);
            return invoke;
        }
        MapperExtBuilder mapperBuilder = this.findExtBuilder();
        if (mapperBuilder != null) {
            MapperInvoke invoke = mapperBuilder.parse(this.defaultRetType, this.method);
            return invoke;
        }
        MapperInvoke invoke = this.parseSqlId();
        return invoke;
    }

    protected String getNamespace() {
        SqlResource methodSqlResoruce = this.method.getAnnotation(SqlResource.class);
        if (methodSqlResoruce != null) {
            return methodSqlResoruce.value();
        }
        SqlResource sqlResource = this.mapperClass.getAnnotation(SqlResource.class);
        if (sqlResource != null) {
            return sqlResource.value();
        }
        if (this.defaultRetType != null) {
            String namespace = StringKit.toLowerCaseFirstOne((String)this.defaultRetType.getSimpleName());
            return namespace;
        }
        throw new BeetlSQLException(25, "\u9700\u8981\u4f7f\u7528@SqlResource");
    }

    protected MapperInvoke parseSqlId() {
        String namespace = this.getNamespace();
        String id = this.method.getName();
        SqlId sqlId = SqlId.of((String)namespace, (String)id);
        Annotation action = MapperMethodParser.getSqlType(this.method);
        ReturnTypeParser returnTypeParser = new ReturnTypeParser(this.method, this.defaultRetType);
        ParameterParser parameterParser = new ParameterParser(this.method);
        MethodParamsHolder paramsHolder = parameterParser.getHolder();
        if (action == null || action instanceof Select) {
            if (paramsHolder.hasPageRequest()) {
                Class targetRetType = returnTypeParser.getPageResultType();
                if (returnTypeParser.isPageResult()) {
                    return new PageRMI(sqlId, targetRetType, true, paramsHolder);
                }
                return new PageRMI(sqlId, targetRetType, false, paramsHolder);
            }
            if (returnTypeParser.isCollection()) {
                Class targetRetType = returnTypeParser.getCollectionType();
                return new SelectRMI(sqlId, targetRetType, paramsHolder, false);
            }
            Class targetRetType = returnTypeParser.getType();
            return new SelectRMI(sqlId, targetRetType, paramsHolder, true);
        }
        if (action instanceof Update) {
            return new UpdateRMI(sqlId, paramsHolder);
        }
        if (action instanceof BatchUpdate) {
            return new BatchUpdateRMI(sqlId, paramsHolder);
        }
        throw new UnsupportedOperationException();
    }

    protected MapperExtBuilder findExtBuilder() {
        Annotation[] ans;
        for (Annotation an : ans = this.method.getAnnotations()) {
            Builder builder = an.annotationType().getAnnotation(Builder.class);
            if (builder == null) continue;
            Class c = builder.value();
            Object o = BeanKit.newSingleInstance((Class)c);
            if (!(o instanceof MapperExtBuilder)) {
                throw new IllegalStateException("\u671f\u671b " + MapperExtBuilder.class + " \u4f46\u662f " + c);
            }
            return (MapperExtBuilder)o;
        }
        return null;
    }

    protected MapperInvoke parseSqlTemplateMethod(Template sqlAnnotation) {
        String sqlTemplate = sqlAnnotation.value();
        this.checkSqlLength(sqlTemplate);
        Annotation action = MapperMethodParser.getSqlType(this.method);
        ReturnTypeParser returnTypeParser = new ReturnTypeParser(this.method, this.defaultRetType);
        ParameterParser parameterParser = new ParameterParser(this.method);
        MethodParamsHolder paramsHolder = parameterParser.getHolder();
        if (action == null || action instanceof Select) {
            if (paramsHolder.hasPageRequest()) {
                Class targetRetType = returnTypeParser.getPageResultType();
                if (returnTypeParser.isPageResult()) {
                    return new PageTemplateMI(sqlTemplate, targetRetType, true, paramsHolder);
                }
                return new PageTemplateMI(sqlTemplate, targetRetType, false, paramsHolder);
            }
            if (returnTypeParser.isCollection()) {
                Class targetRetType = returnTypeParser.getCollectionType();
                return new SelectTemplateMI(sqlTemplate, targetRetType, paramsHolder, false);
            }
            Class targetRetType = returnTypeParser.getType();
            return new SelectTemplateMI(sqlTemplate, targetRetType, paramsHolder, true);
        }
        if (action instanceof Update) {
            return new UpdateTemplateMI(sqlTemplate, paramsHolder);
        }
        if (action instanceof BatchUpdate) {
            return new BatchUpdateTemplateMI(sqlTemplate, paramsHolder);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301 " + action);
    }

    protected MapperInvoke parseStreamMethod() {
        Sql sqlAnnotation = this.method.getAnnotation(Sql.class);
        Class targetType = this.getStreamType();
        ParameterParser parameterParser = new ParameterParser(this.method);
        MethodParamsHolder paramsHolder = parameterParser.getHolder();
        if (sqlAnnotation != null) {
            StreamSqlReadyMI sqlReadyMI = new StreamSqlReadyMI(sqlAnnotation.value(), targetType);
            return sqlReadyMI;
        }
        Template templateAnnotation = this.method.getAnnotation(Template.class);
        if (templateAnnotation != null) {
            String sqlTemplate = templateAnnotation.value();
            StreamTemplateSqlMI streamTemplateSqlMI = new StreamTemplateSqlMI(sqlTemplate, targetType, paramsHolder);
            return streamTemplateSqlMI;
        }
        String namespace = this.getNamespace();
        String id = this.method.getName();
        SqlId sqlId = SqlId.of((String)namespace, (String)id);
        StreamSqlIdMI sqlIdMI = new StreamSqlIdMI(sqlId, targetType, paramsHolder);
        return sqlIdMI;
    }

    protected Class getStreamType() {
        Type t = this.method.getGenericReturnType();
        if (!(t instanceof ParameterizedType)) {
            return this.defaultRetType;
        }
        Class type = BeanKit.getParameterTypeClass((Type)this.method.getGenericReturnType());
        return type != null ? type : this.defaultRetType;
    }

    protected MapperInvoke parseSqlMethod(Sql sqlAnnotation) {
        String jdbcSql = sqlAnnotation.value();
        this.checkSqlLength(jdbcSql);
        Annotation action = MapperMethodParser.getSqlType(this.method);
        ReturnTypeParser returnTypeParser = new ReturnTypeParser(this.method, this.defaultRetType);
        ParameterParser parameterParser = new ParameterParser(this.method);
        MethodParamsHolder paramsHolder = parameterParser.getHolder();
        if (action == null || action instanceof Select) {
            if (paramsHolder.hasPageRequest()) {
                if (returnTypeParser.isPageResult()) {
                    Class targetRetType = returnTypeParser.getPageResultType();
                    return new PageSqlReadyMI(jdbcSql, targetRetType, true, paramsHolder);
                }
                Class targetRetType = returnTypeParser.getPageResultType();
                return new PageSqlReadyMI(jdbcSql, targetRetType, false, paramsHolder);
            }
            if (returnTypeParser.isCollection()) {
                Class targetRetType = returnTypeParser.getCollectionType();
                return new SelectSqlReadyMI(jdbcSql, targetRetType, false);
            }
            return new SelectSqlReadyMI(jdbcSql, returnTypeParser.target, true);
        }
        if (action instanceof Update) {
            return new UpdateSqlReadyMI(jdbcSql);
        }
        if (action instanceof BatchUpdate) {
            return new BatchSqlReadyMI(jdbcSql);
        }
        throw new UnsupportedOperationException();
    }

    public static Annotation getSqlType(Method method) {
        Select select = method.getAnnotation(Select.class);
        if (select != null) {
            return select;
        }
        Update update = method.getAnnotation(Update.class);
        if (update != null) {
            return update;
        }
        BatchUpdate batchUpdate = method.getAnnotation(BatchUpdate.class);
        return batchUpdate;
    }

    protected Class getMappingEntity() {
        return this.method.getReturnType();
    }

    protected void checkSqlLength(String sql) {
        if (this.preferredSqlLen == -1) {
            return;
        }
        if (sql.length() > this.preferredSqlLen) {
            throw new BeetlSQLException(27, "\u671f\u671bMapper\u65b9\u6cd5 " + this.method + " \u7684SQL\u6700\u5927\u957f\u5ea6\u662f " + this.preferredSqlLen + " \u5b9e\u9645\u662f " + sql.length());
        }
    }
}

