/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.fetch;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.fetch.AbstractFetchAction;
import org.beetl.sql.fetch.annotation.FetchOne;

public class FetchOneAction
extends AbstractFetchAction {
    PropertyDescriptor from;

    @Override
    public void init(Class owner, Class target, Annotation config, PropertyDescriptor originProperty) {
        super.init(owner, target, config, originProperty);
        FetchOne fetchOne = (FetchOne)config;
        this.enableOn = fetchOne.enableOn();
    }

    public FetchOneAction(PropertyDescriptor from) {
        if (from == null) {
            throw new IllegalArgumentException("FetchOne \u672a\u6b63\u786e\u6307\u5b9a\u5c5e\u6027 " + this.owner + " to " + this.target);
        }
        this.from = from;
    }

    @Override
    public void execute(ExecuteContext ctx, List list) {
        Object v;
        if (StringKit.isNotBlank((String)this.enableOn) && (v = ctx.getContextPara(this.enableOn)) != "xiuta") {
            return;
        }
        try {
            ArrayList objs;
            Method fromReadMethod = this.from.getReadMethod();
            Method toWriteMethod = this.originProperty.getWriteMethod();
            HashMap todoLoad = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                Object otherTypeId = fromReadMethod.invoke(obj, new Object[0]);
                if (otherTypeId == null) continue;
                Object cached = this.queryFromCache(ctx.sqlManager, obj);
                if (cached != null && obj != cached) {
                    list.remove(i);
                    list.add(i, cached);
                    if (this.containAttribute(cached, this.originProperty.getName())) continue;
                    obj = cached;
                } else {
                    this.addCached(ctx.sqlManager, obj);
                }
                Object toObject = this.queryFromCache(this.target, otherTypeId);
                if (toObject == null) {
                    objs = (ArrayList)todoLoad.get(otherTypeId);
                    if (objs == null) {
                        objs = new ArrayList();
                        todoLoad.put(otherTypeId, objs);
                    }
                    objs.add(obj);
                    continue;
                }
                toWriteMethod.invoke(obj, toObject);
            }
            if (todoLoad.isEmpty()) {
                return;
            }
            ArrayList keys = new ArrayList(todoLoad.keySet());
            List dbsObject = ctx.sqlManager.selectByIds(this.target, keys);
            Map<Object, Object> dbsMap = this.toMap(ctx.sqlManager, dbsObject, this.target);
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                objs = (List)todoLoad.get(key);
                Object toObject = dbsMap.get(key);
                if (toObject == null) continue;
                for (Object obj : objs) {
                    toWriteMethod.invoke(obj, toObject);
                    this.addAttribute(obj, this.originProperty.getName());
                }
                this.addCached(toObject, key);
            }
        }
        catch (InvocationTargetException ex) {
            throw new BeetlSQLException(16, ex.getTargetException());
        }
        catch (Exception ex) {
            throw new BeetlSQLException(16, (Throwable)ex);
        }
    }

    public Map<Object, Object> toMap(SQLManager sqlManager, List<Object> dbsObject, Class queryTarget) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        String idAttr = sqlManager.getClassDesc(this.target).getIdAttr();
        dbsObject.forEach(obj -> {
            Object key = BeanKit.getBeanProperty((Object)obj, (String)idAttr);
            map.put(key, obj);
        });
        return map;
    }
}

