/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.fetch;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.fetch.AbstractFetchAction;

public class FetchManyAction
extends AbstractFetchAction {
    Class owner;
    Class target;
    PropertyDescriptor idProperty;
    PropertyDescriptor otherTypeFrom;
    PropertyDescriptor to;

    public FetchManyAction(Class owner, Class target, PropertyDescriptor idProperty, PropertyDescriptor otherTypeFrom, PropertyDescriptor to) {
        this.owner = owner;
        this.target = target;
        this.otherTypeFrom = otherTypeFrom;
        if (otherTypeFrom == null) {
            throw new IllegalArgumentException("\u672a\u6b63\u786e\u6307\u5b9aFetchMany\u7684\u5c5e\u6027 " + owner + " to " + target);
        }
        this.to = to;
        this.idProperty = idProperty;
    }

    @Override
    public void execute(ExecuteContext ctx, List list) {
        try {
            Method idReadMethod = this.idProperty.getReadMethod();
            Method fromWriteMethod = this.otherTypeFrom.getWriteMethod();
            Method toWriteMethod = this.to.getWriteMethod();
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                Object id = idReadMethod.invoke(obj, new Object[0]);
                Object cached = this.queryFromCache(this.owner, id);
                if (cached != null && obj != cached) {
                    list.remove(i);
                    list.add(i, cached);
                    continue;
                }
                this.addCached(ctx.sqlManager, obj);
                Object template = BeanKit.newInstance((Class)this.target);
                fromWriteMethod.invoke(template, id);
                List values = ctx.sqlManager.template(template);
                for (int j = 0; j < values.size(); ++j) {
                    Object otherObj = values.get(j);
                    Object otherCached = this.queryFromCache(ctx.sqlManager, otherObj);
                    if (otherCached != null && otherObj != otherCached) {
                        values.remove(j);
                        values.add(j, otherCached);
                        continue;
                    }
                    this.addCached(ctx.sqlManager, otherObj);
                }
                toWriteMethod.invoke(obj, values);
            }
        }
        catch (InvocationTargetException ex) {
            throw new BeetlSQLException(16, ex.getTargetException());
        }
        catch (Exception ex) {
            throw new BeetlSQLException(16, (Throwable)ex);
        }
    }
}

