/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.fetch;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.mapping.BeanFetch;
import org.beetl.sql.fetch.FetchAction;
import org.beetl.sql.fetch.FetchContext;
import org.beetl.sql.fetch.FetchManyAction;
import org.beetl.sql.fetch.FetchOneAction;
import org.beetl.sql.fetch.annotation.Fetch;
import org.beetl.sql.fetch.annotation.FetchMany;
import org.beetl.sql.fetch.annotation.FetchOne;

public class DefaultBeanFetch
implements BeanFetch {
    static ThreadLocal<FetchContext> local = new ThreadLocal();
    ConcurrentHashMap<Class, List<FetchAction>> fetchConfig = new ConcurrentHashMap();

    public void fetchMore(ExecuteContext ctx, List beans, Annotation annotation) {
        Class target = ctx.target;
        boolean isInit = false;
        try {
            FetchContext fetchContext = local.get();
            if (fetchContext == null) {
                isInit = true;
                fetchContext = new FetchContext();
                int level = ((Fetch)annotation).level();
                fetchContext.setLevel(level);
                local.set(fetchContext);
            }
            if (fetchContext.getLevel() == 0) {
                return;
            }
            List<FetchAction> listAction = this.parse(ctx.sqlManager, target);
            for (FetchAction action : listAction) {
                int keepLevel = fetchContext.level;
                fetchContext.setLevel(keepLevel - 1);
                action.execute(ctx, beans);
                fetchContext.setLevel(keepLevel);
            }
        }
        catch (Exception ex) {
            throw new BeetlSQLException(16, (Throwable)ex);
        }
        finally {
            if (isInit) {
                local.remove();
            }
        }
    }

    protected List<FetchAction> parse(SQLManager sqlManager, Class target) {
        if (this.fetchConfig.containsKey(target)) {
            return this.fetchConfig.get(target);
        }
        ArrayList<FetchAction> actions = new ArrayList<FetchAction>();
        try {
            PropertyDescriptor[] allPs;
            for (PropertyDescriptor pd : allPs = BeanKit.propertyDescriptors((Class)target)) {
                FetchMany fetchMany;
                FetchOne fetchOne = (FetchOne)BeanKit.getAnnotation((Class)target, (String)pd.getName(), FetchOne.class);
                if (fetchOne != null) {
                    String fromAttr = fetchOne.value();
                    PropertyDescriptor fromProperty = BeanKit.getPropertyDescriptor((Class)target, (String)fromAttr);
                    Class owner = target;
                    Class<?> fetchTargetType = pd.getPropertyType();
                    PropertyDescriptor toProperty = pd;
                    FetchOneAction action = new FetchOneAction(owner, fetchTargetType, fromProperty, toProperty);
                    actions.add(action);
                }
                if ((fetchMany = (FetchMany)BeanKit.getAnnotation((Class)target, (String)pd.getName(), FetchMany.class)) == null) continue;
                PropertyDescriptor beanIdProperty = this.findIdProperty(target, sqlManager);
                PropertyDescriptor toProperty = pd;
                String typeAttr = fetchMany.value();
                Class<?> classType = pd.getPropertyType();
                Type type = pd.getReadMethod().getGenericReturnType();
                if (!List.class.isAssignableFrom(classType)) {
                    throw new IllegalStateException("one2Many \u7c7b\u578b\u5e94\u8be5\u662fList");
                }
                Class targetType = this.getCollectionType(type);
                PropertyDescriptor otherTypeFrom = BeanKit.getPropertyDescriptor((Class)targetType, (String)typeAttr);
                FetchManyAction action = new FetchManyAction(target, targetType, beanIdProperty, otherTypeFrom, toProperty);
                actions.add(action);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        this.fetchConfig.put(target, actions);
        return actions;
    }

    protected PropertyDescriptor findIdProperty(Class target, SQLManager sqlManager) throws IntrospectionException {
        List ids = sqlManager.getClassDesc(target).getIdAttrs();
        if (ids.size() > 1) {
            throw new UnsupportedOperationException("\u76ee\u524d\u4e0d\u652f\u6301\u591a\u4e3b\u952efetch");
        }
        return BeanKit.getPropertyDescriptor((Class)target, (String)((String)ids.get(0)));
    }

    public Class getCollectionType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException("\u65e0\u6cdb\u578b\u7c7b\u578b\uff0c\u65e0\u6cd5Fetch");
        }
        Class paraType = this.getParamterTypeClass(type);
        if (paraType == null) {
            throw new IllegalStateException("\u65e0\u6cdb\u578b\u7c7b\u578b\uff0c\u65e0\u6cd5Fetch");
        }
        return paraType;
    }

    protected Class getParamterTypeClass(Type t) {
        if (t instanceof WildcardType || t instanceof TypeVariable) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
        throw new UnsupportedOperationException();
    }
}

