/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.MockClassDesc;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.CaseInsensitiveOrderSet;

public class TableDesc {
    private String name;
    private Set<String> idNames = new CaseInsensitiveOrderSet();
    private String remark = null;
    private Set<String> cols = new CaseInsensitiveOrderSet();
    private Map<Class, ClassDesc> classes = new ConcurrentHashMap<Class, ClassDesc>();
    private CaseInsensitiveHashMap<String, ColDesc> colsDetail = new CaseInsensitiveHashMap();
    private String schema;
    private String catalog;
    private String realTableName;

    public TableDesc(String name, String remark) {
        this.name = name;
        this.remark = remark;
    }

    public boolean containCol(String col) {
        return this.cols.contains(col);
    }

    public void addCols(ColDesc col) {
        this.colsDetail.put(col.getColName(), (Object)col);
        this.cols.add(col.getColName());
    }

    public ColDesc getColDesc(String name) {
        return (ColDesc)this.colsDetail.get((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getIdNames() {
        return this.idNames;
    }

    public void addIdName(String idName) {
        this.idNames.add(idName);
    }

    public Set<String> getCols() {
        return this.cols;
    }

    public String getRemark() {
        return this.remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDesc genClassDesc(Class c, NameConversion nc) {
        ClassDesc classDesc = this.classes.get(c);
        if (classDesc == null) {
            Map<Class, ClassDesc> map = this.classes;
            synchronized (map) {
                classDesc = this.classes.get(c);
                if (classDesc != null) {
                    return classDesc;
                }
                classDesc = new ClassDesc(c, this, nc);
                this.classes.put(c, classDesc);
            }
        }
        return classDesc;
    }

    public MockClassDesc genClassDesc(NameConversion nc) {
        MockClassDesc c = new MockClassDesc(this, nc);
        return c;
    }

    public CaseInsensitiveHashMap<String, ColDesc> getColsDetail() {
        return this.colsDetail;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getRealTableName() {
        return this.realTableName;
    }

    public void setRealTableName(String realTableName) {
        this.realTableName = realTableName;
    }
}

