/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.beetl.core.ConsoleErrorHandler;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.ErrorInfo;
import org.beetl.core.statement.GrammarToken;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.engine.SqlTemplateResource;

public class BeetlSQLTemplateExceptionHandler
extends ConsoleErrorHandler {
    public void processExcption(BeetlException ex, Writer writer) {
        ErrorInfo error = new ErrorInfo(ex);
        int line = error.getErrorTokenLine();
        SqlTemplateResource resource = (SqlTemplateResource)ex.gt.getResourceLoader().getResource(ex.resource.getId());
        int startLine = resource.getLine();
        StringBuilder sb = new StringBuilder(">>").append(this.getDateTime()).append(":").append(error.getType()).append(":").append(error.getErrorTokenText()).append(" \u4f4d\u4e8e").append(line + startLine - 1).append("\u884c").append(" \u8d44\u6e90:").append(this.getResourceName(ex.resource.getId()));
        System.out.println(sb.toString());
        if (ex.getMessage() != null) {
            this.println(writer, ex.getMessage());
        }
        ResourceLoader resLoader = ex.gt.getResourceLoader();
        String content = null;
        try {
            Resource res = resLoader.getResource(ex.resource.getId());
            int[] range = this.getRange(line);
            content = res.getContent(range[0], range[1]);
            if (content != null) {
                String[] strs = content.split(ex.cr);
                int lineNumber = range[0];
                for (int i = 0; i < strs.length; ++i) {
                    this.print(writer, "" + (lineNumber + startLine - 1));
                    this.print(writer, "|");
                    this.println(writer, strs[i]);
                    ++lineNumber;
                }
            }
        }
        catch (IOException res) {
            // empty catch block
        }
        if (error.hasCallStack()) {
            this.println(writer, "  ========================");
            this.println(writer, "  \u8c03\u7528\u6808:");
            for (int i = 0; i < error.getResourceCallStack().size(); ++i) {
                Object errorId = ((Resource)error.getResourceCallStack().get(i)).getId();
                SqlTemplateResource errorResource = (SqlTemplateResource)ex.gt.getResourceLoader().getResource(errorId);
                startLine = errorResource.getLine();
                this.println(writer, "  " + errorId + " \u884c\uff1a" + (((GrammarToken)error.getTokenCallStack().get((int)i)).line + startLine));
            }
        }
        this.printCause(error, writer);
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new BeetlSQLException(6, "SQL Script Error:" + sb, (Throwable)ex);
    }

    protected String getDateTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
        return sdf.format(date);
    }

    protected String getResourceName(String resourceId) {
        if (resourceId.length() > 30) {
            return resourceId.substring(0, 30);
        }
        return resourceId;
    }
}

