/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.annotation.builder.BeanConvert;
import org.beetl.sql.annotation.builder.TargetAdditional;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.ClassExtAnnotation;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.SQLBatchReady;
import org.beetl.sql.core.SQLExecutor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.engine.template.SQLTemplate;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.engine.template.TemplateContext;
import org.beetl.sql.core.mapping.BeanFetch;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.ResultSetMapper;
import org.beetl.sql.core.mapping.RowMapper;
import org.beetl.sql.core.mapping.RowMapperResultSetExt;
import org.beetl.sql.core.mapping.StreamData;
import org.beetl.sql.core.meta.MetadataManager;

public class BaseSQLExecutor
implements SQLExecutor {
    ExecuteContext executeContext;

    public BaseSQLExecutor(ExecuteContext executeContext) {
        this.executeContext = executeContext;
    }

    protected static boolean isBaseDataType(Class<?> clazz) {
        return BeanKit.isBaseDataType(clazz);
    }

    @Override
    public int insert(Class clazz, Object paras) {
        KeyHolder holder = paras instanceof Map ? KeyHolder.empty : KeyHolder.getKeyHolderByClass(paras.getClass());
        int ret = this.insert(paras, holder);
        this.assignKeyHolder(holder, paras);
        return ret;
    }

    @Override
    public Object[] insert(Class target, Object paras, String[] cols) {
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        InterceptorContext ctx = null;
        try {
            this.addParaIfAssignId(paras);
            Map map = this.beforeExecute(target, paras, true);
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> jdbcPara = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(map);
            sql = this.executeContext.sqlResult.jdbcSql;
            jdbcPara = this.executeContext.sqlResult.jdbcPara;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            ruh = this.dbUpdateWithHolder(conn, sql, jdbcPara, cols);
            Object[] values = null;
            if (cols != null) {
                ResultSet rs = ruh.statement.getGeneratedKeys();
                values = new Object[cols.length];
                int i = 0;
                while (rs.next()) {
                    values[i] = rs.getObject(i + 1);
                    ++i;
                }
                rs.close();
            }
            this.callInterceptorAsAfter(ctx, ruh.resultSet);
            Object[] objectArray = values;
            this.clean(true, conn, ruh);
            return objectArray;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
    }

    @Override
    public <T> T singleSelect(Class<T> target, Object paras) {
        Map map = this.beforeExecute(target, paras, false);
        return this.selectSingle(map, target);
    }

    @Override
    public <T> T selectUnique(Class<T> target, Object paras) {
        Map map = this.beforeExecute(target, paras, false);
        List<T> result = this.select(target, map);
        int size = result.size();
        if (size == 1) {
            return result.get(0);
        }
        if (size == 0) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u53c2\u6570\u662f" + map);
        }
        throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u627e\u5230\u591a\u6761\u8bb0\u5f55:\u53c2\u6570\u662f" + map);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, Object paras) {
        Map map = this.beforeExecute(clazz, paras, false);
        return this.select(clazz, map);
    }

    protected <T> T selectSingle(Map<String, Object> map, Class<T> target) {
        List<T> result = this.select(target, map);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    protected <T> List<T> select(Class<T> clazz, Map<String, Object> paras) {
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> jdbcPara = result.jdbcPara;
        ResultSetHolder rsh = null;
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        if (this.executeContext.executeResult != null) {
            this.callInterceptorAsAfter(ctx, this.executeContext.executeResult);
            return (List)this.executeContext.executeResult;
        }
        sql = this.executeContext.sqlResult.jdbcSql;
        jdbcPara = this.executeContext.sqlResult.jdbcPara;
        Connection conn = null;
        try {
            Object classAnnotation;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sql, jdbcPara);
            if (this.executeContext.customizedBeanProcessor != null) {
                resultList = this.executeContext.customizedBeanProcessor.toBeanList(this.executeContext, rsh.resultSet, clazz);
            } else {
                ResultSetMapper<?> resultSetMapper;
                classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
                RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : ((ClassAnnotation)classAnnotation).getRowMapper();
                ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : ((ClassAnnotation)classAnnotation).getResultSetMapper();
                if (resultSetMapper != null) {
                    resultList = resultSetMapper.mapping(this.executeContext, clazz, rsh.resultSet, ((ClassAnnotation)classAnnotation).getMapperConfig());
                } else if (rowMapper != null) {
                    BeanProcessor beanProcessor = this.getBeanProcessor();
                    resultList = new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, rsh.resultSet, (Class)clazz, ((ClassAnnotation)classAnnotation).getMapperConfig());
                } else {
                    resultList = this.mappingSelect(clazz, rsh.resultSet);
                }
            }
            this.executeContext.executeResult = resultList;
            this.callInterceptorAsAfter(ctx, resultList);
            classAnnotation = resultList = (List<T>)this.afterBean(resultList);
            this.clean(false, conn, rsh);
            return classAnnotation;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> mappingSelect(Class<T> target, ResultSet rs) throws SQLException {
        BeanProcessor beanProcessor = this.getBeanProcessor();
        return beanProcessor.mappingSelect(this.executeContext, rs, target);
    }

    @Override
    public <T> List<T> select(Class<T> target, Object paras, Object start, long size) {
        SQLExecutor newSqlEx = this.executeContext.sqlManager.getPageSqlScript(target, this.executeContext.sqlId);
        Map mapParas = this.beforeExecute(target, paras, false);
        this.executeContext.sqlManager.getDbStyle().getRangeSql().addTemplateRangeParas(mapParas, start, size);
        return newSqlEx.select(target, mapParas);
    }

    @Override
    public long selectCount(Object paras) {
        return this.singleSelect(Long.class, paras);
    }

    @Override
    public int update(Class target, Object object) {
        Map paras = this.beforeExecute(target, object, true);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        int rs = 0;
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        try {
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            ruh = this.dbUpdate(conn, sql, objs);
            rs = (Integer)ruh.resultSet;
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ruh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public int[] insertBatch(Class<?> target, List<?> list) {
        if (list.size() == 0) {
            return new int[0];
        }
        int[] rs = null;
        Statement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            Object firstValue = list.get(0);
            KeyHolder holder = KeyHolder.getKeyHolderByClass(firstValue.getClass());
            for (int k = 0; k < list.size(); ++k) {
                Object entity = list.get(k);
                if (entity == null) {
                    throw new NullPointerException("\u5217\u8868 " + k + "\u4e3a\u7a7a");
                }
                this.addParaIfAssignId(entity);
                Map paras = this.beforeExecute(target, entity, true);
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                if (ps == null) {
                    conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
                    ps = holder.hasAttr() ? conn.prepareStatement(result.jdbcSql, this.getKeyHolderCols(holder, entity.getClass())) : conn.prepareStatement(result.jdbcSql);
                    this.applyStatementSetting(this.executeContext, conn, ps);
                    ctx = this.callInterceptorAsBefore(paras);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            if (this.executeContext.sqlManager.getDbStyle().batchGeneratedKeysSupport() && holder.hasAttr()) {
                ResultSet keysSet = ps.getGeneratedKeys();
                String[] attrs = holder.getAttrNames();
                Object[] values = new Object[holder.getAttrNames().length];
                int index = 0;
                while (keysSet.next()) {
                    Object entity = list.get(index);
                    for (int i = 0; i < attrs.length; ++i) {
                        Object value = keysSet.getObject(i + 1);
                        BeanKit.setBeanPropertyWithCast(entity, (Object)value, (String)attrs[i]);
                    }
                    ++index;
                }
                keysSet.close();
            }
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public int[] updateBatch(Class<?> target, List<?> list) {
        if (list.size() == 0) {
            return new int[0];
        }
        Connection conn = null;
        InterceptorContext lastCtx = null;
        int[] jdbcRets = new int[list.size()];
        try {
            HashMap<String, Object> batchPs = new HashMap<String, Object>();
            HashMap<String, InterceptorContext> batchCtx = new HashMap<String, InterceptorContext>();
            HashMap<String, ArrayList<Integer>> batchRet = new HashMap<String, ArrayList<Integer>>();
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            for (int k = 0; k < list.size(); ++k) {
                if (list.get(k) == null) {
                    throw new NullPointerException("\u5217\u8868 " + k + "\u53c2\u6570\u4e3a\u7a7a");
                }
                Map paras = this.beforeExecute(target, list.get(k), true);
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                Object ps = (Interceptor[])batchPs.get(result.jdbcSql);
                ArrayList<Integer> rets = (ArrayList<Integer>)batchRet.get(result.jdbcSql);
                InterceptorContext ctx = (InterceptorContext)batchCtx.get(result.jdbcSql);
                if (ps == null) {
                    ps = conn.prepareStatement(result.jdbcSql);
                    this.applyStatementSetting(this.executeContext, conn, (Statement)ps);
                    ctx = new InterceptorContext(this.executeContext);
                    rets = new ArrayList<Integer>();
                    batchCtx.put(result.jdbcSql, ctx);
                    batchPs.put(result.jdbcSql, ps);
                    batchRet.put(result.jdbcSql, rets);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
                rets.add(k);
            }
            for (Map.Entry entry : batchPs.entrySet()) {
                PreparedStatement ps = (PreparedStatement)entry.getValue();
                lastCtx = (InterceptorContext)batchCtx.get(entry.getKey());
                List rets = (List)batchRet.get(entry.getKey());
                for (Interceptor in : this.executeContext.sqlManager.getInters()) {
                    in.before(lastCtx);
                }
                int[] rs = ps.executeBatch();
                for (int i = 0; i < rs.length; ++i) {
                    int realIndex = (Integer)rets.get(i);
                    jdbcRets[realIndex] = rs[i];
                }
                this.executeContext.executeResult = rs;
                this.callInterceptorAsAfter(lastCtx, rs);
            }
            this.clean(this.executeContext, conn);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(lastCtx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(this.executeContext, conn);
                throw throwable;
            }
        }
        return jdbcRets;
    }

    @Override
    public int[] updateBatch(List<?> list) {
        return this.updateBatch(null, list);
    }

    @Override
    public <T> T unique(Class<T> target, Object objId) {
        return this.single(target, objId, true);
    }

    @Override
    public <T> T single(Class<T> target, Object objId) {
        return this.single(target, objId, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T single(Class<T> clazz, Object objId, boolean throwException) {
        this.executeContext.target = clazz;
        SQLManager sqlManager = this.executeContext.sqlManager;
        MetadataManager mm = sqlManager.getMetaDataManager();
        TableDesc table = mm.getTable(sqlManager.getNc().getTableName(clazz));
        ClassDesc classDesc = table.genClassDesc(clazz, sqlManager.getNc());
        Map paras = this.beforeExecute(clazz, objId, false);
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        if (this.executeContext.executeResult != null) {
            this.callInterceptorAsAfter(ctx, this.executeContext.executeResult);
            return (T)this.executeContext.executeResult;
        }
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        Connection conn = null;
        ResultSetHolder rsh = null;
        try {
            conn = sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sql, objs);
            Object model = null;
            if (this.executeContext.customizedBeanProcessor != null) {
                resultList = this.executeContext.customizedBeanProcessor.toBeanList(this.executeContext, rsh.resultSet, clazz);
            } else {
                ResultSetMapper<?> resultSetMapper;
                ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
                RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
                ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
                if (resultSetMapper != null) {
                    resultList = resultSetMapper.mapping(this.executeContext, clazz, rsh.resultSet, classAnnotation.getMapperConfig());
                } else if (rowMapper != null) {
                    BeanProcessor beanProcessor = this.getBeanProcessor();
                    resultList = new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, rsh.resultSet, (Class)clazz, classAnnotation.getMapperConfig());
                } else {
                    resultList = this.mappingSelect(clazz, rsh.resultSet);
                }
            }
            if (resultList.isEmpty()) {
                if (throwException) {
                    throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6 " + objId);
                }
            } else {
                model = resultList.get(0);
            }
            this.executeContext.executeResult = model;
            this.callInterceptorAsAfter(ctx, model);
            Object object = this.afterBean(model);
            this.clean(false, conn, rsh);
            return (T)object;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
                catch (BeetlSQLException beetlSQLException) {
                    this.callInterceptorAsException(ctx, (Exception)((Object)beetlSQLException));
                    throw beetlSQLException;
                }
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
    }

    @Override
    public boolean existById(Class clazz, Object objId) {
        SQLManager sqlManager = this.executeContext.sqlManager;
        MetadataManager mm = sqlManager.getMetaDataManager();
        TableDesc table = mm.getTable(sqlManager.getNc().getTableName(clazz));
        ClassDesc classDesc = table.genClassDesc(clazz, sqlManager.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        if (this.executeContext.executeResult != null) {
            this.callInterceptorAsAfter(ctx, this.executeContext.executeResult);
            return (Boolean)this.executeContext.executeResult;
        }
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        Connection conn = null;
        ResultSetHolder rsh = null;
        boolean hasResult = false;
        try {
            conn = sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sql, objs);
            rsh.resultSet.next();
            int count = rsh.resultSet.getInt(1);
            hasResult = count != 0;
            this.executeContext.executeResult = count;
            this.callInterceptorAsAfter(ctx, hasResult);
            this.clean(false, conn, rsh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
        return hasResult;
    }

    @Override
    public int deleteById(Class<?> clazz, Object objId) {
        SQLManager sqlManager = this.executeContext.sqlManager;
        MetadataManager mm = sqlManager.getMetaDataManager();
        TableDesc table = mm.getTable(sqlManager.getNc().getTableName(clazz));
        ClassDesc classDesc = table.genClassDesc(clazz, sqlManager.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(paras);
        sql = this.executeContext.sqlResult.jdbcSql;
        objs = this.executeContext.sqlResult.jdbcPara;
        int rs = 0;
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        try {
            conn = sqlManager.getDs().getConn(this.executeContext, true);
            ruh = this.dbUpdate(conn, sql, objs);
            rs = (Integer)ruh.resultSet;
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ruh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public <T> List<T> sqlReadySelect(Class<T> clazz, SQLReady p) {
        SQLResult sqlResult;
        this.executeContext.sqlResult = sqlResult = new SQLResult(p.sql, p.args);
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.beforeExecute(clazz, Arrays.asList(p.getArgs()), false));
        Connection conn = null;
        ResultSetHolder rsh = null;
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sqlResult.jdbcSql, sqlResult.jdbcPara);
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            if (resultSetMapper != null) {
                resultList = resultSetMapper.mapping(this.executeContext, clazz, rsh.resultSet, classAnnotation.getMapperConfig());
            } else if (rowMapper != null) {
                BeanProcessor beanProcessor = this.getBeanProcessor();
                resultList = new RowMapperResultSetExt(rowMapper, beanProcessor).handleResultSet(this.executeContext, rsh.resultSet, (Class)clazz, classAnnotation.getMapperConfig());
            } else {
                resultList = this.mappingSelect(clazz, rsh.resultSet);
            }
            this.executeContext.executeResult = resultList;
            resultList = (List)this.afterBean(resultList);
            this.callInterceptorAsAfter(ctx, resultList);
            Object object = resultList;
            this.clean(false, conn, rsh);
            return object;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, rsh);
                throw throwable;
            }
        }
    }

    @Override
    public <T> StreamData<T> streamExecute(Class<T> clazz, SQLReady p) {
        SQLResult sqlResult;
        this.executeContext.sqlResult = sqlResult = new SQLResult(p.sql, p.args);
        Object resultList = null;
        Connection conn = null;
        ResultSetHolder rsh = null;
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, sqlResult.jdbcSql, sqlResult.jdbcPara);
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            if (resultSetMapper != null) {
                throw new UnsupportedOperationException("stream\u67e5\u8be2\u4e0d\u652f\u6301ResultSetMapper");
            }
            StreamData<T> data = new StreamData<T>(rsh.resultSet, this.executeContext, clazz);
            if (rowMapper != null) {
                data.setRowMapper(rowMapper, classAnnotation.getMapperConfig());
            }
            return data;
        }
        catch (SQLException e) {
            this.clean(false, conn, rsh);
            throw new BeetlSQLException(1, (Throwable)e);
        }
    }

    @Override
    public <T> StreamData<T> stream(Class<T> clazz, Object obj) {
        Map paras = this.beforeExecute(clazz, obj, false);
        SQLResult result = this.run(paras);
        ResultSetHolder rsh = null;
        Connection conn = null;
        try {
            ResultSetMapper<?> resultSetMapper;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, false);
            rsh = this.dbQuery(conn, result.jdbcSql, result.jdbcPara);
            ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(clazz);
            RowMapper<?> rowMapper = this.executeContext.rowMapper != null ? this.executeContext.rowMapper : classAnnotation.getRowMapper();
            ResultSetMapper<?> resultSetMapper2 = resultSetMapper = this.executeContext.resultMapper != null ? this.executeContext.resultMapper : classAnnotation.getResultSetMapper();
            if (resultSetMapper != null) {
                throw new UnsupportedOperationException("stream\u67e5\u8be2\u4e0d\u652f\u6301ResultSetMapper");
            }
            StreamData<T> data = new StreamData<T>(rsh.resultSet, this.executeContext, clazz);
            if (rowMapper != null) {
                data.setRowMapper(rowMapper, classAnnotation.getMapperConfig());
            }
            return data;
        }
        catch (SQLException e) {
            this.clean(false, conn, rsh);
            throw new BeetlSQLException(1, (Throwable)e);
        }
    }

    @Override
    public int sqlReadyExecuteUpdate(SQLReady p) {
        SQLResult sqlResult;
        this.executeContext.sqlResult = sqlResult = new SQLResult(p.sql, p.args);
        InterceptorContext ctx = this.callInterceptorAsBefore(this.beforeExecute(null, Arrays.asList(p.getArgs()), true));
        int rs = 0;
        Connection conn = null;
        ResultUpdateHolder rsh = null;
        try {
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            rsh = this.dbUpdate(conn, sqlResult.jdbcSql, sqlResult.jdbcPara);
            rs = (Integer)rsh.resultSet;
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, rsh);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, rsh);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public int[] sqlReadyBatchExecuteUpdate(SQLBatchReady batch) {
        List<Object[]> args = batch.getArgs();
        if (args.isEmpty()) {
            return new int[0];
        }
        InterceptorContext ctx = null;
        Connection conn = null;
        Statement ps = null;
        int[] rs = null;
        try {
            for (int i = 0; i < args.size(); ++i) {
                Object[] jdbcArgs = args.get(i);
                SQLResult sqlResult = new SQLResult(batch.sql, jdbcArgs);
                sqlResult.jdbcSql = batch.sql;
                this.executeContext.sqlResult = sqlResult;
                if (i == 0) {
                    conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
                    ctx = this.callInterceptorAsBefore(this.beforeExecute(null, Arrays.asList(jdbcArgs), true));
                    ps = conn.prepareStatement(sqlResult.jdbcSql);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, sqlResult.jdbcPara);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            this.executeContext.executeResult = rs;
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    @Override
    public ExecuteContext getExecuteContext() {
        return this.executeContext;
    }

    protected void setIdsParas(ClassDesc desc, Object obj, Map<String, Object> paras) {
        List<String> idAttrs = desc.getIdAttrs();
        if (idAttrs.size() == 1) {
            paras.put(idAttrs.get(0), obj);
        } else {
            Map<String, Object> map = desc.getIdMethods();
            for (int i = 0; i < idAttrs.size(); ++i) {
                String idCol = idAttrs.get(i);
                String idAttr = idAttrs.get(i);
                Method m = (Method)map.get(idAttr);
                try {
                    Object os = m.invoke(obj, new Object[0]);
                    paras.put(idAttr, os);
                    continue;
                }
                catch (Exception ex) {
                    throw new BeetlSQLException(14, "\u65e0\u6cd5\u8bbe\u7f6e\u590d\u5408\u4e3b\u952e:" + idCol, (Throwable)ex);
                }
            }
        }
    }

    protected int insert(Object paras, KeyHolder holder) {
        Connection conn = null;
        ResultUpdateHolder ruh = null;
        InterceptorContext ctx = null;
        try {
            this.addParaIfAssignId(paras);
            Map map = this.beforeExecute(paras.getClass(), paras, true);
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> jdbcPara = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(map);
            sql = this.executeContext.sqlResult.jdbcSql;
            jdbcPara = this.executeContext.sqlResult.jdbcPara;
            conn = this.executeContext.sqlManager.getDs().getConn(this.executeContext, true);
            String[] cols = holder.hasAttr() ? this.getKeyHolderCols(holder, paras.getClass()) : null;
            ruh = this.dbUpdateWithHolder(conn, sql, jdbcPara, cols);
            int ret = (Integer)ruh.resultSet;
            this.handleHolder(ruh.statement, holder);
            this.executeContext.executeResult = ret;
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ruh);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ruh);
                throw throwable;
            }
        }
    }

    protected void clean(boolean isUpdate, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.closeConnection(conn, isUpdate);
    }

    protected void clean(boolean isUpdate, Connection conn, Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            this.closeConnection(conn, isUpdate);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeConnection(Connection conn, boolean isUpdate) {
        this.executeContext.sqlManager.getDs().closeConnection(conn, this.executeContext, isUpdate);
    }

    protected ResultSetHolder dbQuery(Connection conn, String sql, List<SQLParameter> jdbcPara) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        this.applyStatementSetting(this.executeContext, conn, ps);
        this.setPreparedStatementPara(ps, jdbcPara);
        ResultSet rs = ps.executeQuery();
        return new ResultSetHolder(ps, rs);
    }

    protected ResultUpdateHolder dbUpdate(Connection conn, String sql, List<SQLParameter> jdbcPara) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(sql);
        this.applyStatementSetting(this.executeContext, conn, ps);
        this.setPreparedStatementPara(ps, jdbcPara);
        int result = ps.executeUpdate();
        return new ResultUpdateHolder(ps, result);
    }

    protected ResultUpdateHolder dbUpdateWithHolder(Connection conn, String sql, List<SQLParameter> jdbcPara, String[] cols) throws SQLException {
        PreparedStatement ps = null;
        ps = cols != null ? conn.prepareStatement(sql, cols) : conn.prepareStatement(sql);
        this.setPreparedStatementPara(ps, jdbcPara);
        int result = ps.executeUpdate();
        return new ResultUpdateHolder(ps, result);
    }

    protected void clean(ExecuteContext executeContext, Connection conn) {
        this.clean(true, conn, (Closeable)null);
    }

    protected void handleHolder(Statement ps, KeyHolder holder) throws SQLException {
        if (!holder.hasAttr()) {
            return;
        }
        ResultSet rs = ps.getGeneratedKeys();
        Object[] values = new Object[holder.getAttrNames().length];
        if (rs.next()) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = rs.getObject(i + 1);
            }
        }
        holder.setValues(values);
        rs.close();
    }

    protected void assignKeyHolder(KeyHolder holder, Object paras) {
        if (paras instanceof Map) {
            return;
        }
        String[] attrs = holder.getAttrNames();
        Object[] values = holder.getValues();
        int len = attrs.length;
        for (int i = 0; i < len; ++i) {
            BeanKit.setBeanPropertyWithCast((Object)paras, (Object)values[i], (String)attrs[i]);
        }
    }

    private void addParaIfAssignId(Object obj) {
        if (obj instanceof Map) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (!(this.executeContext.sqlSource instanceof SQLTableSource)) {
            return;
        }
        Class clz = this.executeContext.target;
        SQLTableSource tableSource = (SQLTableSource)this.executeContext.sqlSource;
        if (tableSource.getIdType() == 1 && tableSource.getAssignIds() != null) {
            Map<String, AssignID> ids = tableSource.getAssignIds();
            for (Map.Entry<String, AssignID> entry : ids.entrySet()) {
                String attrName = entry.getKey();
                Object value = BeanKit.getBeanProperty((Object)obj, (String)attrName);
                if (!StringKit.isNullOrEmpty((Object)value)) continue;
                AssignID assignId = entry.getValue();
                String algorithm = assignId.value();
                if (StringKit.isEmpty((String)algorithm)) {
                    throw new BeetlSQLException(7, "\u4f7f\u7528@Assign\u672a\u6307\u5b9a\u7b97\u6cd5\uff0c\u9700\u8981\u663e\u793a\u7684\u8d4b\u503c\u7ed9 " + attrName);
                }
                String param = assignId.param();
                Object o = this.executeContext.sqlManager.getAssignIdByIdAutoGen(algorithm, param, tableSource.getTableDesc().getName());
                BeanKit.setBeanProperty((Object)obj, (Object)o, (String)attrName);
            }
        }
    }

    protected String[] getKeyHolderCols(KeyHolder holder, Class target) {
        String[] attrs = holder.getAttrNames();
        String[] cols = new String[attrs.length];
        NameConversion nc = this.executeContext.sqlManager.getNc();
        for (int i = 0; i < attrs.length; ++i) {
            cols[i] = nc.getColName(target, attrs[i]);
        }
        return cols;
    }

    protected void setPreparedStatementPara(PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        if (objs.isEmpty()) {
            return;
        }
        BeanProcessor beanProcessor = this.getBeanProcessor();
        beanProcessor.setPreparedStatementPara(this.executeContext, ps, objs);
    }

    private BeanProcessor getBeanProcessor() {
        return this.executeContext.sqlManager.getDefaultBeanProcessors();
    }

    @Override
    public Map beforeExecute(Class target, Object paras, boolean isUpdate) {
        this.executeContext.target = target;
        this.executeContext.inputParas = paras;
        this.executeContext.isUpdate = isUpdate;
        if (paras == null) {
            HashMap map = new HashMap();
            this.addMoreParasFromTarget(target, map);
            return map;
        }
        if (paras instanceof Map) {
            Map map = (Map)paras;
            this.addMoreParasFromTarget(target, map);
            return map;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        Class<?> parasType = paras.getClass();
        if (BaseSQLExecutor.isBaseDataType(paras.getClass())) {
            return map;
        }
        ClassAnnotation an = ClassAnnotation.getClassAnnotation(parasType);
        if (an.isContainExtAnnotation()) {
            BeanConvert beanConvert;
            ClassExtAnnotation ext = an.getExtAnnotation();
            if (ext.hasAttributeExt()) {
                Map<String, AttributeConvert> attrMap = ext.getAttributeConvertMap();
                for (Map.Entry<String, AttributeConvert> entry : attrMap.entrySet()) {
                    String attr = entry.getKey();
                    AttributeConvert convert = entry.getValue();
                    Object newValue = convert.toDb(this.executeContext, parasType, attr, paras);
                    map.put(attr, newValue);
                }
            }
            if (ext.hasEntityExt() && (beanConvert = ext.getBeanConvert()) != null) {
                Object obj = beanConvert.before(this.executeContext, paras, ext.getBeanConvertAnnotation());
                if (obj instanceof Map) {
                    map.putAll((Map)obj);
                } else {
                    map.put("_root", obj);
                }
            }
        }
        this.addMoreParasFromTarget(target, map);
        return map;
    }

    protected void addMoreParasFromTarget(Class target, Map map) {
        TargetAdditional targetAdditional;
        Map<String, Object> moreParas;
        ClassExtAnnotation targetExtClassAnnotation;
        Annotation annotation;
        Map extPara = this.executeContext.sqlManager.getSqlManagerExtend().getParaExtend().morePara(this.executeContext);
        if (extPara != null) {
            map.putAll(extPara);
        }
        if (target == null) {
            return;
        }
        ClassAnnotation targetClassAnnotation = ClassAnnotation.getClassAnnotation(target);
        if (targetClassAnnotation.isContainExtAnnotation() && (annotation = (targetExtClassAnnotation = targetClassAnnotation.getExtAnnotation()).getAdditionalAnnotation()) != null && (moreParas = (targetAdditional = targetExtClassAnnotation.getTargetAdditional()).getAdditional(this.executeContext, annotation)) != null && !moreParas.isEmpty()) {
            map.putAll(moreParas);
        }
    }

    @Override
    public SQLResult run(Map<String, Object> parasMap) {
        return this.run(parasMap, null);
    }

    @Override
    public SQLResult run(Map<String, Object> parasMap, TemplateContext ctx) {
        String jdbcSql;
        SQLTemplateEngine gt = this.executeContext.sqlManager.sqlTemplateEngine;
        SQLTemplate t = null;
        ExecuteContext parentExecuteContext = ctx == null ? null : (ExecuteContext)ctx.getVar("_executeContext");
        t = parentExecuteContext != null ? gt.getSqlTemplate(this.executeContext.sqlId, ctx) : gt.getSqlTemplate(this.executeContext.sqlId);
        LinkedList<SQLParameter> jdbcPara = new LinkedList<SQLParameter>();
        if (parasMap != null) {
            for (Map.Entry<String, Object> entry : parasMap.entrySet()) {
                t.setPara(entry.getKey(), entry.getValue());
            }
        }
        t.setPara("_paras", jdbcPara);
        t.setPara("_executeContext", this.executeContext);
        this.executeContext.sqlResult.jdbcSql = jdbcSql = t.render();
        this.executeContext.sqlResult.jdbcPara = jdbcPara;
        SQLResult result = new SQLResult();
        result.jdbcSql = jdbcSql;
        result.jdbcPara = jdbcPara;
        return result;
    }

    protected InterceptorContext callInterceptorAsBefore(Map<String, Object> inputParas) {
        InterceptorContext ctx = new InterceptorContext(this.executeContext);
        for (Interceptor in : this.executeContext.sqlManager.inters) {
            in.before(ctx);
        }
        return ctx;
    }

    protected void callInterceptorAsAfter(InterceptorContext ctx, Object result) {
        SQLManager sqlManager = this.executeContext.sqlManager;
        if (sqlManager.inters == null) {
            return;
        }
        for (Interceptor in : this.executeContext.sqlManager.inters) {
            in.after(ctx);
        }
    }

    protected Object afterBean(Object result) {
        BeanFetch beanFetch;
        BeanConvert convert;
        if (result == null) {
            return null;
        }
        Class target = this.executeContext.target;
        if (target == null) {
            return result;
        }
        if (target == Map.class) {
            return result;
        }
        if (BaseSQLExecutor.isBaseDataType(target)) {
            return result;
        }
        ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(target);
        ClassExtAnnotation extAnnotation = classAnnotation.getExtAnnotation();
        if (extAnnotation != null && extAnnotation.getBeanConvert() != null && (convert = extAnnotation.getBeanConvert()) != null) {
            Annotation annotation = extAnnotation.getBeanConvertAnnotation();
            if (result instanceof List) {
                List resultList = (List)result;
                resultList.stream().forEach(obj -> convert.after(this.executeContext, obj, annotation));
            } else {
                convert.after(this.executeContext, result, annotation);
            }
        }
        if ((beanFetch = classAnnotation.getBeanFetch()) != null) {
            if (result instanceof List) {
                List resultList = (List)result;
                beanFetch.fetchMore(this.executeContext, resultList, classAnnotation.getBeanFetchAnnotation());
            } else {
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(result);
                beanFetch.fetchMore(this.executeContext, list, classAnnotation.getBeanFetchAnnotation());
                result = list.get(0);
            }
        }
        return result;
    }

    protected void callInterceptorAsAfter(InterceptorContext ctx) {
        this.callInterceptorAsAfter(ctx, null);
    }

    private void callInterceptorAsException(InterceptorContext ctx, Exception ex) {
        if (ctx == null) {
            return;
        }
        SQLManager sqlManager = this.executeContext.sqlManager;
        if (sqlManager.inters == null) {
            return;
        }
        for (Interceptor in : sqlManager.inters) {
            in.exception(ctx, ex);
        }
    }

    protected void applyStatementSetting(ExecuteContext ctx, Connection conn, Statement statement) throws SQLException {
        this.getExecuteContext().sqlManager.getDs().applyStatementSetting(ctx, conn, statement);
    }

    public static class ResultUpdateHolder
    implements Closeable {
        Statement statement;
        Object resultSet;

        public ResultUpdateHolder(Statement statement, Object result) {
            this.statement = statement;
            this.resultSet = result;
        }

        @Override
        public void close() throws SQLException {
            if (this.statement != null) {
                this.statement.close();
            }
        }
    }

    public static class ResultSetHolder
    implements Closeable {
        Statement statement;
        ResultSet resultSet;

        public ResultSetHolder(Statement statement, ResultSet resultSet) {
            this.statement = statement;
            this.resultSet = resultSet;
        }

        @Override
        public void close() throws SQLException {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
        }
    }

    static interface Closeable {
        public void close() throws SQLException;
    }
}

