/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.db.SqlServerStyle;
import org.beetl.sql.core.range.RangeSql;

public class SqlServer2012Style
extends SqlServerStyle {
    SqlServer2012Range sqlServer2012Range = new SqlServer2012Range(this);

    public SqlServer2012Style() {
    }

    public SqlServer2012Style(boolean fetchRemark) {
        super(fetchRemark);
    }

    @Override
    public RangeSql getRangeSql() {
        return this.sqlServer2012Range;
    }

    static class SqlServer2012Range
    implements RangeSql {
        SqlServer2012Style style = null;

        public SqlServer2012Range(SqlServer2012Style sqlServerStyle) {
            this.style = sqlServerStyle;
        }

        @Override
        public String toRange(String jdbcSql, Object objOffset, Long limit) {
            Long offset = ((Number)objOffset).longValue();
            StringBuilder builder = new StringBuilder(jdbcSql);
            if (!jdbcSql.matches("(?is).*\\s+order\\s+by[^)]+$")) {
                builder.append(" order by current_timestamp ");
            }
            return builder.append(" offset ").append(PageParamKit.sqlServer2012Offset(this.style.offsetStartZero, offset)).append(" rows fetch next ").append(limit).append(" rows only ").toString();
        }

        @Override
        public String toTemplateRange(Class mapping, String template) {
            StringBuilder builder = new StringBuilder(template);
            if (!template.matches("(?is).*pageIgnoreTag\\s*\\(\\s*\\)[^}]*?order\\s+by.*|.*\\s+order\\s+by[^)]+$")) {
                builder.append(this.style.getOrderBy());
            }
            return builder.append(" offset ").append(this.style.appendExpress("_pageOffset")).append(" rows fetch next ").append(this.style.appendExpress("_pageSize")).append(" rows only ").toString();
        }

        @Override
        public void addTemplateRangeParas(Map<String, Object> paras, Object objOffset, long size) {
            Long offset = (Long)objOffset;
            long s = offset - (long)(this.style.offsetStartZero ? 0 : 1);
            paras.put("_pageOffset", s);
            paras.put("_pageSize", size);
        }
    }
}

