/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.loader.AbstractClassPathSQLLoader;
import org.beetl.sql.core.loader.MarkdownParser;
import org.beetl.sql.core.loader.SQLFileParser;

public class MarkdownClasspathLoader
extends AbstractClassPathSQLLoader {
    protected String sqlRoot = null;
    protected String charset;
    protected Map<SqlId, SQLSource> sqlSourceMap = new ConcurrentHashMap<SqlId, SQLSource>();
    protected SQLSource EMPTY = SQLSource.emptySource();

    public MarkdownClasspathLoader(String root, String charset) {
        this.sqlRoot = root;
        this.charset = charset;
    }

    public MarkdownClasspathLoader(String root) {
        this.sqlRoot = root;
        this.charset = Charset.defaultCharset().name();
    }

    public MarkdownClasspathLoader() {
        this("sql");
    }

    @Override
    public SQLSource queryExternalSource(SqlId id) {
        SQLSource source = this.sqlSourceMap.get(id);
        if (source == this.EMPTY) {
            return null;
        }
        if (source != null) {
            return source;
        }
        this.loadFromClassPath(id);
        source = this.sqlSourceMap.computeIfAbsent(id, key -> this.EMPTY);
        if (source == this.EMPTY) {
            return null;
        }
        return source;
    }

    @Override
    public boolean existExternalSource(SqlId id) {
        SQLSource source = this.queryExternalSource(id);
        return source != null;
    }

    @Override
    public boolean isExternalSourceModified(SqlId id) {
        SQLSource source = this.sqlSourceMap.get(id);
        if (source == null) {
            return false;
        }
        long oldRootVersion = source.getVersion().root;
        long oldDbVersion = source.getVersion().db;
        URL root = this.getRootFile(id);
        URL db = this.getDBRootFile(id);
        return this.getURLVersion(root) != oldRootVersion || this.getURLVersion(db) != oldDbVersion;
    }

    @Override
    public void removeExternalSource(SqlId id) {
        this.sqlSourceMap.remove(id);
    }

    protected Long getURLVersion(URL url) {
        if (url == null) {
            return 0L;
        }
        if (url.getProtocol().equals("file")) {
            String path = url.getFile();
            return new File(path).lastModified();
        }
        return 0L;
    }

    protected void loadFromClassPath(SqlId id) {
        URL ins = this.getRootFile(id);
        this.readSqlFile(id, ins, true);
        ins = this.getDBRootFile(id);
        this.readSqlFile(id, ins, false);
    }

    protected void readSqlFile(SqlId sqlId, URL url, boolean isRoot) {
        InputStream ins;
        if (url == null) {
            return;
        }
        try {
            ins = url.openStream();
        }
        catch (IOException e1) {
            return;
        }
        if (ins == null) {
            return;
        }
        String modelName = sqlId.getNamespace();
        long lastModified = this.getURLVersion(url);
        BufferedReader bf = null;
        try {
            bf = this.buildBufferedReader(ins, this.charset);
            SQLFileParser parser = this.getParser(modelName, bf);
            SQLSource source = null;
            while ((source = parser.next()) != null) {
                source.sqlType = SQLType.UNKNOWN;
                SQLFileVersion version = new SQLFileVersion();
                version.url = url;
                if (isRoot) {
                    version.root = lastModified;
                } else {
                    version.db = lastModified;
                }
                source.setVersion(version);
                this.sqlSourceMap.put(source.getId(), source);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected URL getRootFile(SqlId id) {
        URL url = this.getFilePath(this.sqlRoot, id);
        return url;
    }

    protected URL getDBRootFile(SqlId id) {
        String root = this.sqlRoot + "/" + this.dbs.getName();
        URL url = this.getFilePath(root, id);
        return url;
    }

    protected URL getFilePath(String root, SqlId id) {
        String path = this.getPathBySqlId(id);
        String filePath0 = root + "/" + path + ".sql";
        String filePath1 = root + "/" + path + ".md";
        URL is = this.getFile(filePath0);
        if (is == null && (is = this.getFile(filePath1)) == null) {
            return null;
        }
        return is;
    }

    private URL getFile(String filePath) {
        return this.classLoaderKit.loadResourceAsURL(filePath);
    }

    public String toString() {
        return this.sqlRoot;
    }

    protected SQLFileParser getParser(String modelName, BufferedReader br) throws IOException {
        MarkdownParser parser = new MarkdownParser(modelName, br);
        return parser;
    }

    protected BufferedReader buildBufferedReader(InputStream inputStream, String charset) {
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream, charset));
            return bf;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684charset " + charset);
        }
    }

    public String getSqlRoot() {
        return this.sqlRoot;
    }

    public void setSqlRoot(String sqlRoot) {
        this.sqlRoot = sqlRoot;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public static class SQLFileVersion {
        public URL url;
        public long root = 0L;
        public long db = 0L;

        public boolean isModified(SQLFileVersion newVersion) {
            return newVersion.root != this.root || newVersion.db != this.db;
        }
    }
}

