/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import org.beetl.sql.clazz.ClassAnnotation;

public class KeyHolder {
    String[] attrNames = null;
    Object[] values = null;
    public static KeyHolder empty = new KeyHolder();

    protected KeyHolder() {
    }

    public KeyHolder(String[] attrNames) {
        this.attrNames = attrNames;
    }

    public KeyHolder(String attrName) {
        this.attrNames = new String[]{attrName};
    }

    public int getInt(String attrName) {
        int index = this.findIndex(attrName);
        return ((Number)this.values[index]).intValue();
    }

    public static KeyHolder getKeyHolderByClass(Class c) {
        ClassAnnotation annotation = ClassAnnotation.getClassAnnotation(c);
        String[] attrs = annotation.getInsertAutoAttrs();
        return new KeyHolder(attrs);
    }

    public Long getLong(String attrName) {
        int index = this.findIndex(attrName);
        return this.values[index] == null ? null : Long.valueOf(((Number)this.values[index]).longValue());
    }

    public String getString(String attrName) {
        int index = this.findIndex(attrName);
        return this.values[index] == null ? null : this.values[index].toString();
    }

    public Object getObject(String attrName) {
        int index = this.findIndex(attrName);
        return this.values[index] == null ? null : this.values[index];
    }

    private int findIndex(String attrName) {
        if (this.attrNames.length == 1 && this.attrNames[0].equals(attrName)) {
            return 0;
        }
        for (int i = 0; i < this.attrNames.length; ++i) {
            if (!attrName.equalsIgnoreCase(this.attrNames[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5c5e\u6027" + attrName);
    }

    public boolean hasAttr() {
        return this.attrNames != null && this.attrNames.length != 0;
    }

    public String[] getAttrNames() {
        return this.attrNames;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }
}

