/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.concat.ConcatContext;
import org.beetl.sql.core.concat.Express;
import org.beetl.sql.core.concat.UpdateConstantsExpress;
import org.beetl.sql.core.concat.UpdateNotEmptyExpress;
import org.beetl.sql.core.concat.UpdateValueExpress;
import org.beetl.sql.core.concat.UpdateVersionExpress;
import org.beetl.sql.core.concat.WhereNode;

public class Update
extends WhereNode {
    String mainTable;
    boolean trim;
    List<Express> updateList = new ArrayList<Express>();

    public Update(ConcatContext ctx) {
        super(ctx);
    }

    public Update from(Class target) {
        this.mainTable = this.ctx.nc.getTableName(target);
        return this;
    }

    public Update from(String table) {
        this.mainTable = table;
        return this;
    }

    public Update table(String table) {
        this.mainTable = table;
        return this;
    }

    public UpdateValueExpress assign(String col) {
        UpdateValueExpress updateValueExpress = new UpdateValueExpress(this);
        updateValueExpress.col = col;
        this.updateList.add(updateValueExpress);
        return updateValueExpress;
    }

    public Update assignConstants(String col, Object value) {
        UpdateConstantsExpress updateValueExpress = new UpdateConstantsExpress(this);
        updateValueExpress.col = col;
        updateValueExpress.value(value);
        this.updateList.add(updateValueExpress);
        return this;
    }

    public Update assignVersion(String col) {
        UpdateVersionExpress updateValueExpress = new UpdateVersionExpress(this);
        updateValueExpress.col = col;
        this.updateList.add(updateValueExpress);
        return this;
    }

    public Update notEmptyAssign(String varName, String col) {
        UpdateValueExpress updateValueExpress = new UpdateValueExpress(this).col(col);
        updateValueExpress.tplValue(varName);
        UpdateNotEmptyExpress notEmptyExpress = new UpdateNotEmptyExpress(varName, updateValueExpress);
        this.updateList.add(notEmptyExpress);
        this.trim = true;
        return this;
    }

    @Override
    public void toSql(ConcatBuilder sb) {
        sb.append("update");
        sb.append(this.mainTable).append("set");
        if (this.trim) {
            sb.appendTrimStart();
            for (int i = 0; i < this.updateList.size(); ++i) {
                Express express = this.updateList.get(i);
                express.toSql(sb);
            }
            sb.appendTrimEnd();
        } else {
            for (int i = 0; i < this.updateList.size(); ++i) {
                Express express = this.updateList.get(i);
                if (i != 0) {
                    sb.append(",");
                }
                express.toSql(sb);
            }
        }
        super.toSql(sb);
    }

    public String toSql() {
        ConcatBuilder sb = this.ctx.concatBuilder;
        this.toSql(sb);
        return sb.toString();
    }
}

